/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.chatbot;

import io.rong.RongCloud;
import io.rong.methods.BaseMethod;
import io.rong.models.bot.ChatbotInfoModel;
import io.rong.models.bot.SetChatbotIntegration;
import io.rong.models.response.PagingQueryChatbotsResult;
import io.rong.models.response.QueryChatbotsResult;
import io.rong.models.response.ResponseResult;
import io.rong.util.GsonUtil;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Chatbot
extends BaseMethod {
    private static final String API_JSON_PATH = "chatbot";

    public Chatbot(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
        this.initPath();
    }

    @Override
    protected void initPath() {
        this.path = API_JSON_PATH;
    }

    public ResponseResult create(ChatbotInfoModel info) throws Exception {
        String method = "botCreate";
        ResponseResult result = this.checkFiled(info, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        return this.doRequest("/v3/bot/create.json", info.toString(), method, ResponseResult.class, "application/json");
    }

    public PagingQueryChatbotsResult query(Integer page, Integer pageSize, Boolean includeIntegration) throws Exception {
        String method = "botList";
        HashMap<String, Constable> params = new HashMap<String, Constable>();
        if (page != null) {
            params.put("page", page);
        }
        if (pageSize != null) {
            params.put("pageSize", pageSize);
        }
        if (includeIntegration != null) {
            params.put("includeIntegration", includeIntegration);
        }
        return this.doRequest("/v3/bot/query.json", GsonUtil.toJson(params, Map.class), method, PagingQueryChatbotsResult.class, "application/json");
    }

    public QueryChatbotsResult get(String ... userIds) throws Exception {
        String method = "botGet";
        if (userIds == null) {
            return new QueryChatbotsResult(20005, "The parameter 'userIds' is required");
        }
        QueryChatbotsResult result = this.checkParam("userIds", userIds, method, QueryChatbotsResult.class);
        if (result != null) {
            return result;
        }
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("userIds", userIds);
        return this.doRequest("/v3/bot/get.json", GsonUtil.toJson(params, Map.class), method, QueryChatbotsResult.class, "application/json");
    }

    public ResponseResult delete(String userId) throws Exception {
        String method = "botDelete";
        if (StringUtils.isBlank((CharSequence)userId)) {
            return new ResponseResult(20005, "The parameter 'userId' is required");
        }
        ResponseResult result = this.checkParam("userId", userId, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", userId);
        return this.doRequest("/v3/bot/delete.json", GsonUtil.toJson(params, Map.class), method, ResponseResult.class, "application/json");
    }

    public ResponseResult update(ChatbotInfoModel model) throws Exception {
        String method = "botUpdate";
        return this.doRequest("/v3/bot/update.json", model.toString(), method, ResponseResult.class, "application/json");
    }

    public ResponseResult createIntegration(SetChatbotIntegration integration) throws Exception {
        String method = "botAddIntegration";
        ResponseResult result = this.checkFiled(integration, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        return this.doRequest("/v3/bot/integration/create.json", integration.toString(), method, ResponseResult.class, "application/json");
    }

    public ResponseResult deleteIntegration(String userId, String type) throws Exception {
        String method = "botDeleteIntegration";
        if (StringUtils.isBlank((CharSequence)userId)) {
            return new ResponseResult(20005, "The parameter 'userId' is required");
        }
        if (StringUtils.isBlank((CharSequence)type)) {
            return new ResponseResult(20005, "The parameter 'type' is required");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("userId", userId);
        params.put("type", type);
        return this.doRequest("/v3/bot/integration/delete.json", GsonUtil.toJson(params, Map.class), method, ResponseResult.class, "application/json");
    }

    public ResponseResult updateIntegration(SetChatbotIntegration integration) throws Exception {
        String method = "botDUpdateIntegration";
        ResponseResult result = this.checkFiled(integration, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        return this.doRequest("/v3/bot/integration/update.json", integration.toString(), method, ResponseResult.class, "application/json");
    }
}

