/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.message.system;

import com.alibaba.fastjson.JSONException;
import com.google.gson.JsonParseException;
import io.rong.RongCloud;
import io.rong.models.Result;
import io.rong.models.Templates;
import io.rong.models.message.BroadcastMessage;
import io.rong.models.message.MessageModel;
import io.rong.models.message.PushUserMessage;
import io.rong.models.message.RecallMessage;
import io.rong.models.message.SystemMessage;
import io.rong.models.message.TemplateMessage;
import io.rong.models.response.BroadcastResult;
import io.rong.models.response.MessageResult;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;

public class MsgSystem {
    private static final String UTF8 = "UTF-8";
    private String appKey;
    private String appSecret;
    private static final String PATH = "message/system";
    private static final String RECAL_PATH = "message/recall";
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public MsgSystem(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public MessageResult send(MessageModel message) throws Exception {
        String body;
        SystemMessage systemMessage = (SystemMessage)message;
        String code = CommonUtil.checkFiled(systemMessage, PATH, "send");
        if (null != code) {
            return (MessageResult)GsonUtil.fromJson(code, MessageResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&fromUserId=").append(URLEncoder.encode(systemMessage.getSenderId().toString(), UTF8));
        for (int i = 0; i < systemMessage.getTargetId().length; ++i) {
            String child = systemMessage.getTargetId()[i];
            if (null == child) continue;
            sb.append("&toUserId=").append(URLEncoder.encode(child, UTF8));
        }
        sb.append("&objectName=").append(URLEncoder.encode(systemMessage.getObjectName(), UTF8));
        sb.append("&content=").append(URLEncoder.encode(systemMessage.getContent().toString(), UTF8));
        if (systemMessage.getPushContent() != null) {
            sb.append("&pushContent=").append(URLEncoder.encode(systemMessage.getPushContent().toString(), UTF8));
        }
        if (systemMessage.getPushData() != null) {
            sb.append("&pushData=").append(URLEncoder.encode(systemMessage.getPushData().toString(), UTF8));
        }
        if (message.getPushExt() != null) {
            sb.append("&pushExt=").append(URLEncoder.encode(message.getPushExt(), UTF8));
        }
        if (systemMessage.getIsPersisted() != null) {
            sb.append("&isPersisted=").append(URLEncoder.encode(systemMessage.getIsPersisted().toString(), UTF8));
        }
        if (systemMessage.getIsCounted() != null) {
            sb.append("&isCounted=").append(URLEncoder.encode(systemMessage.getIsCounted().toString(), UTF8));
        }
        if (systemMessage.getContentAvailable() != null) {
            sb.append("&contentAvailable=").append(URLEncoder.encode(systemMessage.getContentAvailable().toString(), UTF8));
        }
        if (systemMessage.getDisablePush() != null) {
            sb.append("&disablePush=").append(URLEncoder.encode(systemMessage.getDisablePush().toString(), UTF8));
        }
        if (message.getMsgRandom() != null) {
            sb.append("&msgRandom=").append(message.getMsgRandom());
        }
        if (message.getDisableUpdateLastMsg() != null) {
            sb.append("&disableUpdateLastMsg=").append(message.getDisableUpdateLastMsg());
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/message/system/publish.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        MessageResult result = null;
        String response = "";
        try {
            response = HttpUtil.returnResult(conn, this.rongCloud.getConfig());
            result = (MessageResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "send", response), MessageResult.class);
        }
        catch (JSONException | JsonParseException | IllegalStateException e) {
            this.rongCloud.getConfig().errorCounter.incrementAndGet();
            result = new MessageResult(500, "request:" + conn.getURL() + " ,response:" + response + " ,JSONException:" + e.getMessage());
        }
        result.setReqBody(body);
        return result;
    }

    public Result recall(RecallMessage message) throws Exception {
        String body;
        String errMsg = CommonUtil.checkFiled(message, RECAL_PATH, "recall");
        if (null != errMsg) {
            return (ResponseResult)GsonUtil.fromJson(errMsg, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&conversationType=").append(URLEncoder.encode("6", UTF8));
        sb.append("&fromUserId=").append(URLEncoder.encode(message.senderId.toString(), UTF8));
        sb.append("&targetId=").append(URLEncoder.encode(message.targetId.toString(), UTF8));
        sb.append("&messageUID=").append(URLEncoder.encode(message.uId.toString(), UTF8));
        if (message.sentTime != null) {
            sb.append("&sentTime=").append(URLEncoder.encode(message.sentTime.toString(), UTF8));
        }
        if (message.getDisablePush() != null) {
            sb.append("&disablePush=").append(URLEncoder.encode(message.getDisablePush().toString(), UTF8));
        }
        if (message.getIsAdmin() != null) {
            sb.append("&isAdmin=").append(URLEncoder.encode(message.getIsAdmin().toString(), UTF8));
        }
        if (message.getIsDelete() != null) {
            sb.append("&isDelete=").append(URLEncoder.encode(message.getIsDelete().toString(), UTF8));
        }
        if (message.getExtra() != null) {
            sb.append("&extra=").append(URLEncoder.encode(message.getExtra().toString(), UTF8));
        }
        if (message.getDisableUpdateLastMsg() != null) {
            sb.append("&disableUpdateLastMsg=").append(message.getDisableUpdateLastMsg());
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/message/recall.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        ResponseResult result = null;
        String response = "";
        try {
            response = HttpUtil.returnResult(conn, this.rongCloud.getConfig());
            result = (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "recall", response), ResponseResult.class);
        }
        catch (JSONException | JsonParseException | IllegalStateException e) {
            this.rongCloud.getConfig().errorCounter.incrementAndGet();
            result = new ResponseResult(500, "request:" + conn.getURL() + " ,response:" + response + " ,JSONException:" + e.getMessage());
        }
        result.setReqBody(body);
        return result;
    }

    public MessageResult sendTemplate(TemplateMessage template) throws Exception {
        String code = CommonUtil.checkFiled(template, PATH, "sendTemplate");
        if (null != code) {
            return (MessageResult)GsonUtil.fromJson(code, MessageResult.class);
        }
        Templates templateMessage = new Templates();
        ArrayList<String> toUserIds = new ArrayList<String>();
        ArrayList<Map<String, String>> values = new ArrayList<Map<String, String>>();
        ArrayList<String> push = new ArrayList<String>();
        for (Map.Entry<String, TemplateMessage.Data> vo : template.getContent().entrySet()) {
            toUserIds.add(vo.getKey());
            values.add(vo.getValue().getData());
            push.add(vo.getValue().getPush());
        }
        templateMessage.setFromUserId(template.getSenderId());
        templateMessage.setToUserId(toUserIds.toArray(new String[toUserIds.size()]));
        templateMessage.setObjectName(template.getObjectName());
        templateMessage.setContent(GsonUtil.toJson(template.getTemplate(), Map.class));
        templateMessage.setValues(values);
        templateMessage.setPushContent(push.toArray(new String[push.size()]));
        templateMessage.setPushData(template.getPushData());
        templateMessage.setPushExt(template.getPushExt());
        templateMessage.setContentAvailable(template.getContentAvailable());
        templateMessage.setDisableUpdateLastMsg(template.getDisableUpdateLastMsg());
        if (template.getMsgRandom() != null) {
            templateMessage.setMsgRandom(template.getMsgRandom());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/message/system/publish_template.json", "application/json");
        HttpUtil.setBodyParameter(templateMessage.toString(), conn, this.rongCloud.getConfig());
        MessageResult result = null;
        String response = "";
        try {
            response = HttpUtil.returnResult(conn, this.rongCloud.getConfig());
            result = (MessageResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "sendTemplate", response), MessageResult.class);
        }
        catch (JSONException | JsonParseException | IllegalStateException e) {
            this.rongCloud.getConfig().errorCounter.incrementAndGet();
            result = new MessageResult(500, "request:" + conn.getURL() + " ,response:" + response + " ,JSONException:" + e.getMessage());
        }
        result.setReqBody(templateMessage.toString());
        return result;
    }

    public BroadcastResult broadcast(BroadcastMessage message) throws Exception {
        String body;
        String errMsg = CommonUtil.checkFiled(message, PATH, "broadcast");
        if (null != errMsg) {
            return (BroadcastResult)GsonUtil.fromJson(errMsg, BroadcastResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&fromUserId=").append(URLEncoder.encode(message.getSenderId().toString(), UTF8));
        sb.append("&objectName=").append(URLEncoder.encode(message.getContent().getType(), UTF8));
        sb.append("&content=").append(URLEncoder.encode(message.getContent().toString(), UTF8));
        if (message.getPushContent() != null) {
            sb.append("&pushContent=").append(URLEncoder.encode(message.getPushContent().toString(), UTF8));
        }
        if (message.getPushData() != null) {
            sb.append("&pushData=").append(URLEncoder.encode(message.getPushData().toString(), UTF8));
        }
        if (message.getPushExt() != null) {
            sb.append("&pushExt=").append(URLEncoder.encode(message.getPushExt(), UTF8));
        }
        if (message.getOs() != null) {
            sb.append("&os=").append(URLEncoder.encode(message.getOs().toString(), UTF8));
        }
        if (message.getContentAvailable() != null) {
            sb.append("&contentAvailable=").append(URLEncoder.encode(message.getContentAvailable().toString(), UTF8));
        }
        if (message.getMsgRandom() != null) {
            sb.append("&msgRandom=").append(message.getMsgRandom());
        }
        if (message.getDisableUpdateLastMsg() != null) {
            sb.append("&disableUpdateLastMsg=").append(message.getDisableUpdateLastMsg());
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/message/broadcast.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        BroadcastResult result = null;
        String response = "";
        try {
            response = HttpUtil.returnResult(conn, this.rongCloud.getConfig());
            result = (BroadcastResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "broadcast", response), BroadcastResult.class);
        }
        catch (JSONException | JsonParseException | IllegalStateException e) {
            this.rongCloud.getConfig().errorCounter.incrementAndGet();
            result = new BroadcastResult(500, "request:" + conn.getURL() + " ,response:" + response + " ,JSONException:" + e.getMessage());
        }
        result.setReqBody(body);
        return result;
    }

    public BroadcastResult onlineBroadcast(BroadcastMessage message) throws Exception {
        String body;
        String errMsg = CommonUtil.checkFiled(message, PATH, "online");
        if (null != errMsg) {
            return (BroadcastResult)GsonUtil.fromJson(errMsg, BroadcastResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&fromUserId=").append(URLEncoder.encode(message.getSenderId().toString(), UTF8));
        sb.append("&objectName=").append(URLEncoder.encode(message.getContent().getType(), UTF8));
        sb.append("&content=").append(URLEncoder.encode(message.getContent().toString(), UTF8));
        if (message.getMsgRandom() != null) {
            sb.append("&msgRandom=").append(message.getMsgRandom());
        }
        if (message.getDisableUpdateLastMsg() != null) {
            sb.append("&disableUpdateLastMsg=").append(message.getDisableUpdateLastMsg());
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/message/online/broadcast.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        BroadcastResult result = null;
        String response = "";
        try {
            response = HttpUtil.returnResult(conn, this.rongCloud.getConfig());
            result = (BroadcastResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "online", response), BroadcastResult.class);
        }
        catch (JSONException | JsonParseException | IllegalStateException e) {
            this.rongCloud.getConfig().errorCounter.incrementAndGet();
            result = new BroadcastResult(500, "request:" + conn.getURL() + " ,response:" + response + " ,JSONException:" + e.getMessage());
        }
        result.setReqBody(body);
        return result;
    }

    public ResponseResult recallBroadcast(RecallMessage message) throws Exception {
        String body;
        String errMsg = CommonUtil.checkFiled(message, RECAL_PATH, "broadcast");
        if (null != errMsg) {
            return (ResponseResult)GsonUtil.fromJson(errMsg, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&fromUserId=").append(URLEncoder.encode(message.senderId.toString(), UTF8));
        sb.append("&messageUID=").append(URLEncoder.encode(message.uId.toString(), UTF8));
        if (message.sentTime != null) {
            sb.append("&sentTime=").append(URLEncoder.encode(message.sentTime.toString(), UTF8));
        }
        if (message.getIsAdmin() != null) {
            sb.append("&isAdmin=").append(URLEncoder.encode(message.getIsAdmin().toString(), UTF8));
        }
        if (message.getIsDelete() != null) {
            sb.append("&isDelete=").append(URLEncoder.encode(message.getIsDelete().toString(), UTF8));
        }
        if (message.getExtra() != null) {
            sb.append("&extra=").append(URLEncoder.encode(message.getExtra().toString(), UTF8));
        }
        if (message.getDisableUpdateLastMsg() != null) {
            sb.append("&disableUpdateLastMsg=").append(message.getDisableUpdateLastMsg());
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/message/broadcast/recall.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        ResponseResult result = null;
        String response = "";
        try {
            response = HttpUtil.returnResult(conn, this.rongCloud.getConfig());
            result = (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "broadcast", response), ResponseResult.class);
        }
        catch (JSONException | JsonParseException | IllegalStateException e) {
            this.rongCloud.getConfig().errorCounter.incrementAndGet();
            result = new ResponseResult(500, "request:" + conn.getURL() + " ,response:" + response + " ,JSONException:" + e.getMessage());
        }
        result.setReqBody(body);
        return result;
    }

    public ResponseResult sendUser(PushUserMessage pushUser) throws Exception {
        String code = CommonUtil.checkFiled(pushUser, PATH, "sendUser");
        if (null != code) {
            return (ResponseResult)GsonUtil.fromJson(code, ResponseResult.class);
        }
        String body = GsonUtil.toJson(pushUser);
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/push/user.json", "application/json");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        System.out.println("bbbbb" + body);
        ResponseResult result = null;
        String response = "";
        try {
            response = HttpUtil.returnResult(conn, this.rongCloud.getConfig());
            result = (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "sendUser", response), ResponseResult.class);
        }
        catch (JSONException | JsonParseException | IllegalStateException e) {
            this.rongCloud.getConfig().errorCounter.incrementAndGet();
            result = new ResponseResult(500, "request:" + conn.getURL() + " ,response:" + response + " ,JSONException:" + e.getMessage());
        }
        result.setReqBody(body);
        return result;
    }
}

