/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.profile;

import io.rong.RongCloud;
import io.rong.methods.BaseMethod;
import io.rong.models.profile.PagingQueryUserProfilesModel;
import io.rong.models.profile.UserProfileModel;
import io.rong.models.response.CheckFriendsResult;
import io.rong.models.response.QueryUserProfilesResp;
import io.rong.models.response.ResponseResult;
import org.apache.commons.lang3.StringUtils;

public class EntrustUser
extends BaseMethod {
    private static final String API_JSON_PATH = "profile/user";

    public EntrustUser(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
        this.initPath();
    }

    @Override
    protected void initPath() {
        this.path = API_JSON_PATH;
    }

    public ResponseResult setProfile(UserProfileModel profileModel) throws Exception {
        String method = "setUserProfile";
        ResponseResult result = this.checkFiled(profileModel, method, ResponseResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", profileModel.getUserId());
        this.addFormParam(sb, "&userProfile=", profileModel.getUserProfile());
        this.addFormParam(sb, "&userExtProfile=", profileModel.getUserExtProfile());
        String body = sb.toString();
        return this.doRequest("/user/profile/set.json", body, method, ResponseResult.class);
    }

    public QueryUserProfilesResp batchQueryUserProfiles(String ... userId) throws Exception {
        String method = "batchQueryUserProfiles";
        QueryUserProfilesResp result = this.checkParam("userId", userId, method, QueryUserProfilesResp.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", StringUtils.join((Object[])this.removeDuplicates(userId), (String)","));
        String body = sb.toString();
        return this.doRequest("/user/profile/batch/query.json", body, method, QueryUserProfilesResp.class);
    }

    public CheckFriendsResult cleanProfile(String ... userId) throws Exception {
        String method = "cleanProfile";
        CheckFriendsResult result = this.checkParam("userId", userId, method, CheckFriendsResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", StringUtils.join((Object[])this.removeDuplicates(userId), (String)","));
        String body = sb.toString();
        return this.doRequest("/user/profile/clean.json", body, method, CheckFriendsResult.class);
    }

    public QueryUserProfilesResp pagingQueryUserProfiles(PagingQueryUserProfilesModel input) throws Exception {
        String method = "pagingQueryUserProfiles";
        QueryUserProfilesResp result = this.checkFiled(input, method, QueryUserProfilesResp.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "page=", input.getPage());
        this.addFormParam(sb, "&size=", input.getSize());
        this.addFormParam(sb, "&order=", input.getOrder());
        String body = sb.toString();
        return this.doRequest("/user/profile/query.json", body, method, QueryUserProfilesResp.class);
    }
}

