/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.sensitive;

import io.rong.RongCloud;
import io.rong.models.response.BatchAddSensitiveWordResult;
import io.rong.models.response.ListWordfilterResult;
import io.rong.models.response.ResponseResult;
import io.rong.models.sensitiveword.AddSensitiveWordsModel;
import io.rong.models.sensitiveword.SensitiveWordModel;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;

public class SensitiveWord {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "sensitiveword";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public SensitiveWord(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public ResponseResult add(SensitiveWordModel sensitiveword) throws Exception {
        String body;
        String errMsg = CommonUtil.checkFiled(sensitiveword, PATH, "add");
        if (null != errMsg) {
            return (ResponseResult)GsonUtil.fromJson(errMsg, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&word=").append(URLEncoder.encode(sensitiveword.getKeyword().toString(), UTF8));
        if (0 == sensitiveword.getType()) {
            if (null == sensitiveword.getReplace()) {
                return new ResponseResult(20005, "The replace parameter is required");
            }
            sb.append("&replaceWord=").append(URLEncoder.encode(sensitiveword.getReplace().toString(), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/sensitiveword/add.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "add", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public BatchAddSensitiveWordResult batchAdd(AddSensitiveWordsModel sensitiveWords) throws Exception {
        if (sensitiveWords == null || sensitiveWords.getWords() == null || sensitiveWords.getWords().isEmpty()) {
            return new BatchAddSensitiveWordResult(20005, "The sensitiveWords parameter is required");
        }
        if (sensitiveWords.getWords().size() > 50) {
            return new BatchAddSensitiveWordResult(20005, "The number of sensitive words exceeds 50");
        }
        for (AddSensitiveWordsModel.SensitiveWord word : sensitiveWords.getWords()) {
            if (StringUtils.isEmpty((CharSequence)word.getWord())) {
                return new BatchAddSensitiveWordResult(20005, "The word parameter is required");
            }
            if (word.getWord().length() > 32) {
                return new BatchAddSensitiveWordResult(20005, "The length of the 'word' parameter exceeds 32");
            }
            if (word.getReplaceWord() == null || word.getReplaceWord().length() <= 32) continue;
            return new BatchAddSensitiveWordResult(20005, "The length of the 'replaceWord' parameter exceeds 32");
        }
        String body = GsonUtil.toJson(sensitiveWords);
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/sensitiveword/batch/add.json", "application/json");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        String responseByCode = CommonUtil.getResponseByCode(PATH, "batchAdd", HttpUtil.returnResult(conn, this.rongCloud.getConfig()));
        return (BatchAddSensitiveWordResult)GsonUtil.fromJson(responseByCode, BatchAddSensitiveWordResult.class);
    }

    public ListWordfilterResult getList(Integer type) throws Exception {
        String body;
        StringBuilder sb = new StringBuilder();
        if (type != null) {
            sb.append("&type=").append(URLEncoder.encode(type.toString(), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/sensitiveword/list.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ListWordfilterResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "getList", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ListWordfilterResult.class);
    }

    public ResponseResult remove(String word) throws Exception {
        String message = CommonUtil.checkParam("keyword", word, PATH, "remove");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&word=").append(URLEncoder.encode(word.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/sensitiveword/delete.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "remove", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public ResponseResult batchDelete(String[] words) throws Exception {
        String message = CommonUtil.checkParam("keyword", words, PATH, "batchDelete");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (String word : words) {
            sb.append("&words=").append(URLEncoder.encode(word.toString(), UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/sensitiveword/batch/delete.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "batchDelete", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }
}

