/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.ultragroup;

import io.rong.RongCloud;
import io.rong.methods.ultragroup.ban.Ban;
import io.rong.methods.ultragroup.ban.User;
import io.rong.methods.ultragroup.ban.WhiteList;
import io.rong.methods.ultragroup.channel.BusChannel;
import io.rong.methods.ultragroup.expansion.Expansion;
import io.rong.methods.ultragroup.notdisturb.Notdisturb;
import io.rong.models.Result;
import io.rong.models.response.CheckStatusResult;
import io.rong.models.response.ResponseResult;
import io.rong.models.ultragroup.UltraGroupModel;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class UltraGroup {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "ultragroup";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;
    public Ban ban;
    public User user;
    public WhiteList whiteList;
    public BusChannel busChannel;
    public Expansion expansion;
    public Notdisturb notdisturb;

    public UltraGroup(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
        this.user = new User(appKey, appSecret, rongCloud);
        this.whiteList = new WhiteList(appKey, appSecret, rongCloud);
        this.ban = new Ban(appKey, appSecret, rongCloud);
        this.busChannel = new BusChannel(appKey, appSecret, rongCloud);
        this.expansion = new Expansion(appKey, appSecret, rongCloud);
        this.notdisturb = new Notdisturb(appKey, appSecret, rongCloud);
    }

    public Result create(UltraGroupModel group) throws Exception {
        String message = CommonUtil.checkFiled(group, PATH, "create");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(group.getUserId().toString(), UTF8));
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        sb.append("&groupName=").append(URLEncoder.encode(group.getName().toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/ultragroup/create.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "create", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public Result dis(String groupId) throws Exception {
        String message = CommonUtil.checkParam("id", groupId, PATH, "dis");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("groupId=").append(URLEncoder.encode(groupId, UTF8));
        String body = sb.toString();
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/ultragroup/dis.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "dis", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public Result join(UltraGroupModel group) throws Exception {
        String message = CommonUtil.checkFiled(group, PATH, "join");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("groupId=").append(URLEncoder.encode(group.getId(), UTF8));
        sb.append("&userId=").append(URLEncoder.encode(group.getUserId(), UTF8));
        String body = sb.toString();
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/ultragroup/join.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "join", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public Result quit(UltraGroupModel group) throws Exception {
        String message = CommonUtil.checkFiled(group, PATH, "quit");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("groupId=").append(URLEncoder.encode(group.getId(), UTF8));
        sb.append("&userId=").append(URLEncoder.encode(group.getUserId(), UTF8));
        String body = sb.toString();
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/ultragroup/quit.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "quit", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public Result inMember(UltraGroupModel group) throws Exception {
        String message = CommonUtil.checkFiled(group, PATH, "isExist");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("groupId=").append(URLEncoder.encode(group.getId(), UTF8));
        sb.append("&userId=").append(URLEncoder.encode(group.getUserId(), UTF8));
        String body = sb.toString();
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/ultragroup/member/exist.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (CheckStatusResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "isExist", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), CheckStatusResult.class);
    }

    public Result refresh(UltraGroupModel group) throws Exception {
        String message = CommonUtil.checkFiled(group, PATH, "refresh");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        sb.append("&groupName=").append(URLEncoder.encode(group.getName().toString(), UTF8));
        String body = sb.toString();
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/ultragroup/refresh.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "refresh", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }
}

