/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.ultragroup.ban;

import io.rong.RongCloud;
import io.rong.models.Result;
import io.rong.models.response.GroupUserQueryResult;
import io.rong.models.response.ResponseResult;
import io.rong.models.ultragroup.UltraGroupMember;
import io.rong.models.ultragroup.UltraGroupModel;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class WhiteList {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "ultragroup/ban/whitelist";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public WhiteList(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
    }

    public Result add(UltraGroupModel group) throws Exception {
        String body;
        UltraGroupMember[] members;
        String message = CommonUtil.checkFiled(group, PATH, "add");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (UltraGroupMember member : members = group.getMembers()) {
            sb.append("&userIds=").append(URLEncoder.encode(member.getId().toString(), UTF8));
        }
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        if (group.getBusChannel() != null) {
            sb.append("&busChannel=").append(URLEncoder.encode(group.getBusChannel().toString(), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/ultragroup/banned/whitelist/add.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "add", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public Result get(String groupId) throws Exception {
        return this.get(groupId, "");
    }

    public Result get(String groupId, String busChannel) throws Exception {
        String errMsg = CommonUtil.checkParam("id", groupId, PATH, "get");
        if (null != errMsg) {
            return (GroupUserQueryResult)GsonUtil.fromJson(errMsg, GroupUserQueryResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("groupId=").append(URLEncoder.encode(groupId, UTF8));
        sb.append("&busChannel=").append(URLEncoder.encode(busChannel, UTF8));
        String body = sb.toString();
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/ultragroup/banned/whitelist/get.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (GroupUserQueryResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "get", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), GroupUserQueryResult.class);
    }

    public Result remove(UltraGroupModel group) throws Exception {
        String body;
        UltraGroupMember[] members;
        String message = CommonUtil.checkFiled(group, PATH, "del");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        for (UltraGroupMember member : members = group.getMembers()) {
            sb.append("&userIds=").append(URLEncoder.encode(member.getId().toString(), UTF8));
        }
        sb.append("&groupId=").append(URLEncoder.encode(group.getId().toString(), UTF8));
        if (group.getBusChannel() != null) {
            sb.append("&busChannel=").append(URLEncoder.encode(group.getBusChannel().toString(), UTF8));
        }
        if ((body = sb.toString()).indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/ultragroup/banned/whitelist/del.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "del", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }
}

