/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.user.blacklist;

import io.rong.RongCloud;
import io.rong.methods.BaseMethod;
import io.rong.models.Result;
import io.rong.models.response.BlackListResult;
import io.rong.models.response.PagingQueryBlacklistResult;
import io.rong.models.response.ResponseResult;
import io.rong.models.user.UserModel;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class Blacklist
extends BaseMethod {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "user/blacklist";

    @Override
    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    @Override
    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    @Override
    protected void initPath() {
        this.path = PATH;
    }

    public Blacklist(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
        this.initPath();
    }

    public Result add(UserModel user) throws Exception {
        String message = CommonUtil.checkFiled(user, PATH, "add");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(user.getId().toString(), UTF8));
        for (UserModel blackUser : user.getBlacklist()) {
            sb.append("&blackUserId=").append(URLEncoder.encode(blackUser.getId().toString(), UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/user/blacklist/add.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "add", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }

    public BlackListResult getList(UserModel user) throws Exception {
        String message = CommonUtil.checkFiled(user, PATH, "getList");
        if (null != message) {
            return (BlackListResult)GsonUtil.fromJson(message, BlackListResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(user.getId().toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/user/blacklist/query.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (BlackListResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "getList", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), BlackListResult.class);
    }

    public PagingQueryBlacklistResult pagingQueryBlacklist(String userId, String pageToken, Integer size) throws Exception {
        String method = "pagingQueryBlacklist";
        PagingQueryBlacklistResult result = this.checkParam("userId", userId, method, PagingQueryBlacklistResult.class);
        if (result != null) {
            return result;
        }
        StringBuilder sb = new StringBuilder();
        this.addFormParam(sb, "userId=", userId);
        this.addFormParam(sb, "&pageToken=", pageToken);
        this.addFormParam(sb, "&size=", size);
        String body = sb.toString();
        return this.doRequest("/user/blacklist/query.json", body, method, PagingQueryBlacklistResult.class);
    }

    public Result remove(UserModel user) throws Exception {
        String message = CommonUtil.checkFiled(user, PATH, "remove");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(user.getId().toString(), UTF8));
        for (UserModel blackUser : user.getBlacklist()) {
            sb.append("&blackUserId=").append(URLEncoder.encode(blackUser.getId().toString(), UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, "/user/blacklist/remove.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "remove", HttpUtil.returnResult(conn, this.rongCloud.getConfig())), ResponseResult.class);
    }
}

