/*
 * Decompiled with CFR 0.152.
 */
package io.rong.models.message;

import com.google.gson.annotations.SerializedName;
import io.rong.models.message.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PushExt {
    private static final String P_MI = "MI";
    private static final String P_HW = "HW";
    private static final String P_HONOR = "HONOR";
    private static final String P_APNS = "APNs";
    private static final String P_VIVO = "VIVO";
    private static final String P_OPPO = "OPPO";
    private static final String P_FCM = "FCM";
    private static final String P_OHOS = "OHOS";
    private static final String CHANNEL_ID = "channelId";
    private static final String IMPORTANCE = "importance";
    private static final String IMAGE = "image";
    private static final String CATEGORY = "category";
    private static final String COLLAPSE_KEY = "collapse_key";
    private static final String IMAGE_URL = "imageUrl";
    private static final String CLASSIFICATION = "classification";
    private static final String THREAD_ID = "thread-id";
    private static final String APNS_COLLAPSE_ID = "apns-collapse-id";
    private static final String RICH_MEDIA_URI = "richMediaUri";
    private static final String INTERRUPTION_LEVEL = "interruption-level";
    private static final String LARGE_ICON_URI = "large_icon_uri";
    private String title;
    private String templateId;
    private int forceShowPushContent;
    private List<Platform> pushConfigs;

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setForceShowPushContent(int forceShowPushContent) {
        this.forceShowPushContent = forceShowPushContent;
    }

    public int getForceShowPushContent() {
        return this.forceShowPushContent;
    }

    public void setPushConfigs(List<Platform> pushConfigs) {
        this.pushConfigs = pushConfigs;
    }

    public List<Platform> getPushConfigs() {
        return this.pushConfigs;
    }

    public static PushExt build(String title, Integer forceShowPushContent, Platform ... platforms) {
        PushExt pe = new PushExt();
        pe.setTitle(title);
        if (forceShowPushContent != null) {
            pe.setForceShowPushContent(forceShowPushContent);
        }
        ArrayList<Platform> pushConfigs = new ArrayList<Platform>();
        for (Platform p : platforms) {
            pushConfigs.add(p);
        }
        pe.setPushConfigs(pushConfigs);
        return pe;
    }

    public static class OHOS
    implements Platform {
        @SerializedName(value="OHOS")
        protected HashMap<String, String> params = new HashMap();

        public OHOS(String category, String image) {
            this.addParamIfNotBlank(PushExt.CATEGORY, category);
            this.addParamIfNotBlank(PushExt.IMAGE, image);
        }

        @Override
        public void addParamIfNotBlank(String name, String param) {
            if (StringUtils.isNotBlank((CharSequence)param)) {
                this.params.put(name, param);
            }
        }
    }

    public static class FCM
    implements Platform {
        @SerializedName(value="FCM")
        protected HashMap<String, String> params = new HashMap();

        public FCM(String channelId) {
            this.addParamIfNotBlank(PushExt.CHANNEL_ID, channelId);
        }

        public FCM(String channelId, String collapseKey, String imageUrl) {
            this.addParamIfNotBlank(PushExt.CHANNEL_ID, channelId);
            this.addParamIfNotBlank(PushExt.COLLAPSE_KEY, collapseKey);
            this.addParamIfNotBlank(PushExt.IMAGE_URL, imageUrl);
        }

        @Override
        public void addParamIfNotBlank(String name, String param) {
            if (StringUtils.isNotBlank((CharSequence)param)) {
                this.params.put(name, param);
            }
        }
    }

    public static class OPPO
    implements Platform {
        @SerializedName(value="OPPO")
        private HashMap<String, String> params = new HashMap();

        public OPPO(String channelId) {
            this.addParamIfNotBlank(PushExt.CHANNEL_ID, channelId);
        }

        @Override
        public void addParamIfNotBlank(String name, String param) {
            if (StringUtils.isNotBlank((CharSequence)param)) {
                this.params.put(name, param);
            }
        }
    }

    public static class VIVO
    implements Platform {
        @SerializedName(value="VIVO")
        private HashMap<String, String> params = new HashMap();

        public VIVO(String classification) {
            this.addParamIfNotBlank(PushExt.CLASSIFICATION, classification);
        }

        public VIVO(String classification, String category) {
            this.addParamIfNotBlank(PushExt.CLASSIFICATION, classification);
            this.addParamIfNotBlank(PushExt.CATEGORY, category);
        }

        @Override
        public void addParamIfNotBlank(String name, String param) {
            if (StringUtils.isNotBlank((CharSequence)param)) {
                this.params.put(name, param);
            }
        }
    }

    public static class APNs
    implements Platform {
        @SerializedName(value="APNs")
        private HashMap<String, String> params = new HashMap();

        public APNs(String threadId, String apnsCollapseId) {
            this.addParamIfNotBlank(PushExt.THREAD_ID, threadId);
            this.addParamIfNotBlank(PushExt.APNS_COLLAPSE_ID, apnsCollapseId);
        }

        public APNs(String threadId, String apnsCollapseId, String richMediaUri, String interruptionLevel) {
            this.addParamIfNotBlank(PushExt.THREAD_ID, threadId);
            this.addParamIfNotBlank(PushExt.APNS_COLLAPSE_ID, apnsCollapseId);
            this.addParamIfNotBlank(PushExt.RICH_MEDIA_URI, richMediaUri);
            this.addParamIfNotBlank(PushExt.INTERRUPTION_LEVEL, interruptionLevel);
        }

        @Override
        public void addParamIfNotBlank(String name, String param) {
            if (StringUtils.isNotBlank((CharSequence)param)) {
                this.params.put(name, param);
            }
        }
    }

    public static class MI
    implements Platform {
        @SerializedName(value="MI")
        private HashMap<String, String> params = new HashMap();

        public MI(String channelId, String largeIconUri) {
            this.addParamIfNotBlank(PushExt.CHANNEL_ID, channelId);
            this.addParamIfNotBlank(PushExt.LARGE_ICON_URI, largeIconUri);
        }

        @Override
        public void addParamIfNotBlank(String name, String param) {
            if (StringUtils.isNotBlank((CharSequence)param)) {
                this.params.put(name, param);
            }
        }
    }

    public static class HONOR
    implements Platform {
        @SerializedName(value="HONOR")
        private HashMap<String, String> params = new HashMap();

        public HONOR(String importance) {
            this.addParamIfNotBlank(PushExt.IMPORTANCE, importance);
        }

        public HONOR(String importance, String image) {
            this.addParamIfNotBlank(PushExt.IMPORTANCE, importance);
            this.addParamIfNotBlank(PushExt.IMAGE, image);
        }

        @Override
        public void addParamIfNotBlank(String name, String param) {
            if (StringUtils.isNotBlank((CharSequence)param)) {
                this.params.put(name, param);
            }
        }
    }

    public static class HW
    implements Platform {
        @SerializedName(value="HW")
        private HashMap<String, String> params = new HashMap();

        public HW(String channelId) {
            this.addParamIfNotBlank(PushExt.CHANNEL_ID, channelId);
        }

        public HW(String channelId, String importance) {
            this.addParamIfNotBlank(PushExt.CHANNEL_ID, channelId);
            this.addParamIfNotBlank(PushExt.IMPORTANCE, importance);
        }

        public HW(String channelId, String importance, String image, String category) {
            this.addParamIfNotBlank(PushExt.CHANNEL_ID, channelId);
            this.addParamIfNotBlank(PushExt.IMPORTANCE, importance);
            this.addParamIfNotBlank(PushExt.IMAGE, image);
            this.addParamIfNotBlank(PushExt.CATEGORY, category);
        }

        @Override
        public void addParamIfNotBlank(String name, String param) {
            if (StringUtils.isNotBlank((CharSequence)param)) {
                this.params.put(name, param);
            }
        }
    }
}

