/*
 * Decompiled with CFR 0.152.
 */
package io.rong.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.rong.models.group.GroupBanModel;
import io.rong.models.group.GroupModel;
import io.rong.models.response.BlackListResult;
import io.rong.models.response.GroupBanInfo;
import io.rong.models.response.GroupBanResult;
import io.rong.models.response.PWhiteListResult;
import io.rong.models.response.UserList;
import io.rong.models.response.WhiteListResult;
import io.rong.models.user.UserModel;
import io.rong.util.GsonUtil;
import io.rong.util.JsonUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CommonUtil {
    public static final String VERIFY_JSON_NAME = "/verify.json";
    public static final String API_JSON_NAME = "/api.json";
    public static final String CHRARCTER = "UTF-8";
    private static String sdkVersion = null;

    public static boolean validateParams(Object params, int length) {
        try {
            String[] param;
            int len;
            if (null == params) {
                return false;
            }
            if (params instanceof String[] ? (len = (param = (String[])params).length) <= length : (params instanceof String ? (len = (param = (String)params).length()) <= length : params instanceof Integer && (param = (Integer)params) <= length)) {
                return true;
            }
        }
        catch (Exception e) {
            System.out.println("Length validation error" + e);
        }
        return false;
    }

    public static String checkFiled(Object model, String path, String method) {
        return CommonUtil.checkFiled(model, path, method, false);
    }

    public static String checkFiled(Object model, String path, String method, boolean checkMin) {
        try {
            String code = "200";
            Integer max = 64;
            Integer min = 1;
            String apiPath = path;
            String type = "";
            if (path.contains("/")) {
                path = path.substring(0, path.indexOf("/"));
            }
            String[] fileds = new String[]{};
            String checkObjectKey = "";
            Map<String, String[]> checkInfo = CommonUtil.getCheckInfo(apiPath, method);
            for (Map.Entry<String, String[]> entry : checkInfo.entrySet()) {
                fileds = entry.getValue();
                checkObjectKey = entry.getKey();
            }
            if (null == model) {
                return (String)CommonUtil.getErrorMessage(apiPath, method, "20005", "object", String.valueOf(max), "1", type, 0);
            }
            JSONObject verify = (JSONObject)JsonUtil.getJsonObject(path, VERIFY_JSON_NAME);
            Set keys = verify.getJSONObject(checkObjectKey).keySet();
            JSONObject entity = verify.getJSONObject(checkObjectKey);
            int size = 0;
            for (String name : fileds) {
                for (String key : keys) {
                    Object value;
                    if (!name.equals(key)) continue;
                    String nameTemp = name.substring(0, 1).toUpperCase() + name.substring(1);
                    Method m = model.getClass().getMethod("get" + nameTemp, new Class[0]);
                    JSONObject object = entity.getJSONObject(name);
                    if (object.containsKey((Object)"require")) {
                        if (m.invoke(model, new Object[0]) instanceof String) {
                            value = (String)m.invoke(model, new Object[0]);
                            if (StringUtils.isBlank((CharSequence)value)) {
                                code = (String)object.getJSONObject("require").get((Object)"invalid");
                            }
                        } else {
                            value = m.invoke(model, new Object[0]);
                            if (null == value) {
                                code = (String)object.getJSONObject("require").get((Object)"invalid");
                            }
                        }
                    }
                    if (object.containsKey((Object)"length")) {
                        min = (Integer)object.getJSONObject("length").get((Object)"min");
                        max = (Integer)object.getJSONObject("length").get((Object)"max");
                        if (m.invoke(model, new Object[0]) instanceof String) {
                            value = (String)m.invoke(model, new Object[0]);
                            if ("200".equals(code) && StringUtils.isBlank((CharSequence)value)) {
                                code = (String)object.getJSONObject("length").get((Object)"invalid");
                            }
                            if ("200".equals(code) && ((String)value).length() > max) {
                                size = ((String)value).length();
                                code = (String)object.getJSONObject("length").get((Object)"invalid");
                            }
                        } else if (m.invoke(model, new Object[0]) instanceof String[]) {
                            value = (String[])m.invoke(model, new Object[0]);
                            if (checkMin && "200".equals(code) && ((Object)value).length < min) {
                                size = ((Object)value).length;
                                code = (String)object.getJSONObject("length").get((Object)"invalid");
                            }
                            if ("200".equals(code) && ((Object)value).length > max) {
                                size = ((Object)value).length;
                                code = (String)object.getJSONObject("length").get((Object)"invalid");
                            }
                        }
                    }
                    if (object.containsKey((Object)"size")) {
                        min = (Integer)object.getJSONObject("size").get((Object)"min");
                        max = (Integer)object.getJSONObject("size").get((Object)"max");
                        type = (String)object.getJSONObject("typeof").get((Object)"type");
                        if (type.contains("array")) {
                            value = (Object[])m.invoke(model, new Object[0]);
                            if ("200".equals(code) && null == value) {
                                code = (String)object.getJSONObject("size").get((Object)"invalid");
                            }
                            if ("200".equals(code) && ((Object)value).length > max) {
                                size = ((Object)value).length;
                                code = (String)object.getJSONObject("size").get((Object)"invalid");
                            }
                        } else if (type.contains("int")) {
                            value = 0;
                            try {
                                value = (Integer)m.invoke(model, new Object[0]);
                            }
                            catch (Exception e) {
                                code = (String)object.getJSONObject("typeof").get((Object)"invalid");
                            }
                            if ("200".equals(code) && value != null) {
                                if (checkMin && (Integer)value < min) {
                                    size = (Integer)value;
                                    code = (String)object.getJSONObject("size").get((Object)"invalid");
                                }
                                if ((Integer)value > max) {
                                    size = (Integer)value;
                                    code = (String)object.getJSONObject("size").get((Object)"invalid");
                                }
                            }
                        }
                    }
                    if ("200".equals(code)) continue;
                    return (String)CommonUtil.getErrorMessage(apiPath, method, code, name, String.valueOf(max), String.valueOf(min), type, size);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String checkParam(String checkFiled, Object value, String path, String method) {
        return CommonUtil.checkParam(checkFiled, value, path, method, false);
    }

    public static String checkParam(String checkFiled, Object value, String path, String method, boolean checkMin) {
        try {
            String code = "200";
            Integer max = 64;
            Integer min = 1;
            String type = "";
            String apiPath = path;
            if (path.contains("/")) {
                path = path.substring(0, path.indexOf("/"));
            }
            String checkObject = "";
            Map<String, String[]> checkInfo = CommonUtil.getCheckInfo(apiPath, method);
            for (Map.Entry<String, String[]> entry : checkInfo.entrySet()) {
                checkObject = entry.getKey();
            }
            JSONObject verify = (JSONObject)JsonUtil.getJsonObject(path, VERIFY_JSON_NAME);
            Set keys = verify.getJSONObject(checkObject).keySet();
            JSONObject entity = verify.getJSONObject(checkObject);
            int size = 0;
            for (String key : keys) {
                Object valueTemp;
                if (!checkFiled.equals(key)) continue;
                JSONObject object = entity.getJSONObject(checkFiled);
                if (object.containsKey((Object)"require")) {
                    if (value instanceof String) {
                        if (StringUtils.isBlank((CharSequence)String.valueOf(value))) {
                            code = (String)object.getJSONObject("require").get((Object)"invalid");
                        }
                    } else if (null == value) {
                        code = (String)object.getJSONObject("require").get((Object)"invalid");
                    }
                }
                if (object.containsKey((Object)"length")) {
                    max = (Integer)object.getJSONObject("length").get((Object)"max");
                    min = (Integer)object.getJSONObject("length").get((Object)"min");
                    if (value instanceof String) {
                        if ("200".equals(code) && StringUtils.isBlank((CharSequence)String.valueOf(value))) {
                            code = (String)object.getJSONObject("length").get((Object)"invalid");
                        }
                        if ("200".equals(code) && (String.valueOf(value).length() > max || String.valueOf(value).length() < min)) {
                            size = String.valueOf(value).length();
                            code = (String)object.getJSONObject("length").get((Object)"invalid");
                        }
                    } else if (value instanceof String[]) {
                        valueTemp = new String[]{};
                        try {
                            valueTemp = (String[])value;
                        }
                        catch (Exception e) {
                            code = (String)object.getJSONObject("typeof").get((Object)"invalid");
                        }
                        if ("200".equals(code) && ((String[])valueTemp).length > max) {
                            code = (String)object.getJSONObject("length").get((Object)"invalid");
                        }
                    }
                }
                if (object.containsKey((Object)"size")) {
                    min = (Integer)object.getJSONObject("size").get((Object)"min");
                    max = (Integer)object.getJSONObject("size").get((Object)"max");
                    type = (String)object.getJSONObject("typeof").get((Object)"type");
                    if (type.contains("array")) {
                        valueTemp = null;
                        if ("200".equals(code) && null == value) {
                            code = (String)object.getJSONObject("size").get((Object)"invalid");
                        }
                        try {
                            valueTemp = (String[])value;
                        }
                        catch (Exception e) {
                            code = (String)object.getJSONObject("typeof").get((Object)"invalid");
                        }
                        if (checkMin && "200".equals(code) && ((String[])valueTemp).length < min) {
                            size = ((Object)valueTemp).length;
                            code = (String)object.getJSONObject("size").get((Object)"invalid");
                        }
                        if ("200".equals(code) && ((String[])valueTemp).length > max) {
                            size = ((Object)valueTemp).length;
                            code = (String)object.getJSONObject("size").get((Object)"invalid");
                        }
                    } else if (type.contains("int")) {
                        valueTemp = 64;
                        try {
                            valueTemp = (Integer)value;
                        }
                        catch (Exception e) {
                            code = (String)object.getJSONObject("typeof").get((Object)"invalid");
                        }
                        if ("200".equals(code) && value != null) {
                            if (checkMin && (Integer)valueTemp < min) {
                                size = (Integer)valueTemp;
                                code = (String)object.getJSONObject("size").get((Object)"invalid");
                            }
                            if ((Integer)valueTemp > max) {
                                size = (Integer)valueTemp;
                                code = (String)object.getJSONObject("size").get((Object)"invalid");
                            }
                        }
                    }
                }
                return (String)CommonUtil.getErrorMessage(apiPath, method, code, checkFiled, String.valueOf(max), String.valueOf(min), type, size);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object getErrorMessage(String path, String method, String errorCode, String name, String max, String min, String type, int size) {
        JSONObject api = null;
        try {
            api = (JSONObject)JsonUtil.getJsonObject(path, API_JSON_NAME);
            Set keys = api.getJSONObject(method).getJSONObject("response").getJSONObject("fail").entrySet();
            String[] serchList = new String[]{"{{name}}", "{{max}}", "{{name}}", "{{min}}", "{{currentType}}", "{{size}}"};
            String[] replaceList = new String[]{name, max, name, min, type, String.valueOf(size)};
            for (Map.Entry entry : keys) {
                if (!errorCode.equals(entry.getKey())) continue;
                String text = entry.getValue().toString();
                return StringUtils.replaceEach((String)text, (String[])serchList, (String[])replaceList);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static Map<String, String[]> getCheckInfo(String path, String method) {
        try {
            JSONObject api = (JSONObject)JsonUtil.getJsonObject(path, API_JSON_NAME);
            Set keys = api.getJSONObject(method).getJSONObject("params").keySet();
            String key = (String)keys.iterator().next();
            try {
                Object object = api.getJSONObject(method).getJSONObject("params").get((Object)key);
                Set subkeys = null != object && object instanceof JSONObject ? api.getJSONObject(method).getJSONObject("params").getJSONObject(key).keySet() : keys;
                HashMap<String, String[]> map = new HashMap<String, String[]>();
                map.put(key, subkeys.toArray(new String[subkeys.size()]));
                return map;
            }
            catch (ClassCastException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new HashMap<String, String[]>();
    }

    public static String getResponseByCode(String path, String method, String response) {
        try {
            JSONObject responseNode;
            JSONObject object = JSON.parseObject((String)response);
            String code = String.valueOf(object.get((Object)"code"));
            String requestId = String.valueOf(object.get((Object)"requestId"));
            JSONObject api = (JSONObject)JsonUtil.getJsonObject(path, API_JSON_NAME);
            Set keys = Collections.emptySet();
            if (api != null && api.containsKey((Object)method) && (responseNode = api.getJSONObject(method).getJSONObject("response")) != null && responseNode.containsKey((Object)"fail")) {
                keys = responseNode.getJSONObject("fail").entrySet();
            }
            String text = response;
            if (code.equals("200")) {
                if (path.contains("blacklist") && method.equals("getList")) {
                    UserList userList = (UserList)GsonUtil.fromJson(response, UserList.class);
                    UserModel[] members = CommonUtil.parseUserList(userList);
                    BlackListResult blacklist = new BlackListResult(userList.getCode(), null, members);
                    blacklist.requestId = requestId;
                    text = blacklist.toString();
                } else if (path.contains("user/whitelist") && method.equals("getList")) {
                    UserList userList = (UserList)GsonUtil.fromJson(response, UserList.class);
                    UserModel[] members = CommonUtil.parseUserList(userList);
                    PWhiteListResult whitelist = new PWhiteListResult(userList.getCode(), null, members);
                    whitelist.requestId = requestId;
                    text = whitelist.toString();
                } else if (path.contains("whitelist/user") && method.equals("getList")) {
                    UserList userList = (UserList)GsonUtil.fromJson(response, UserList.class);
                    UserModel[] members = CommonUtil.parseUserList(userList);
                    WhiteListResult whitelist = new WhiteListResult(userList.getCode(), null, members);
                    whitelist.requestId = requestId;
                    text = whitelist.toString();
                } else if (path.contains("chatroom") || path.contains("group")) {
                    text = StringUtils.replace((String)response, (String)"users", (String)"members");
                    if (text.contains("whitlistMsgType")) {
                        text = StringUtils.replace((String)text, (String)"whitlistMsgType", (String)"objectNames");
                    }
                    if (path.contains("gag") || path.contains("block") || path.contains("ban/user")) {
                        text = StringUtils.replace((String)text, (String)"userId", (String)"id");
                    }
                    if (path.contains("mute")) {
                        if (path.contains("member")) {
                            text = StringUtils.replace((String)text, (String)"\"userId\"", (String)"\"id\"");
                        }
                        GroupBanModel groupBanModel = (GroupBanModel)GsonUtil.fromJson(response, GroupBanModel.class);
                        GroupBanInfo[] groupBanInfos = groupBanModel.getGroupinfo();
                        ArrayList<GroupModel> groupinfos = new ArrayList<GroupModel>();
                        if (null != groupBanInfos) {
                            for (GroupBanInfo groupBanInfo : groupBanInfos) {
                                groupinfos.add(new GroupModel(groupBanInfo.getGroupId(), groupBanInfo.getStat()));
                            }
                            GroupModel[] groupModels = groupinfos.toArray(new GroupModel[groupinfos.size()]);
                            GroupBanResult groupBanResult = new GroupBanResult(groupBanModel.getCode(), null, groupModels);
                            groupBanResult.requestId = requestId;
                            text = groupBanResult.toString();
                        }
                    }
                    if (path.equals("group/ban") && method.equals("getList")) {
                        text = StringUtils.replace((String)response, (String)"\"groupinfo\"", (String)"\"groups\"");
                        text = StringUtils.replace((String)text, (String)"\"groupId\"", (String)"\"id\"");
                        text = StringUtils.replace((String)text, (String)"\"stat\"", (String)"\"status\"");
                    }
                } else if (path.contains("user")) {
                    if (path.contains("block") || path.contains("blacklist")) {
                        text = StringUtils.replace((String)response, (String)"userId", (String)"id");
                    }
                } else if (path.contains("sensitiveword")) {
                    text = StringUtils.replace((String)response, (String)"word", (String)"keyword");
                    if (text.contains("keywords")) {
                        text = StringUtils.replace((String)text, (String)"keywords", (String)"words");
                    }
                    text = StringUtils.replace((String)text, (String)"replaceWord", (String)"replace");
                } else {
                    text = response;
                }
                return text;
            }
            for (Map.Entry entry : keys) {
                if (!code.equals(entry.getKey())) continue;
                text = entry.getValue().toString();
                return text;
            }
            if (path.contains("chatroom")) {
                text = StringUtils.replace((String)text, (String)"users", (String)"members");
                if (path.contains("keepalive") && "0".equals(code)) {
                    text = StringUtils.replace((String)text, (String)"chatroomIds", (String)"chatrooms");
                    text = StringUtils.replace((String)text, (String)"0", (String)"200");
                }
            }
            if (text.contains("\"message\"")) {
                text = StringUtils.replace((String)text, (String)"message", (String)"errorMessage");
            }
            return text;
        }
        catch (Exception e) {
            e.printStackTrace();
            return response;
        }
    }

    private static UserModel[] parseUserList(UserList userList) {
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (String id : userList.getUsers()) {
            users.add(new UserModel().setId(id));
        }
        return users.toArray(new UserModel[users.size()]);
    }

    public static String getSDKVersion() {
        if (null == sdkVersion) {
            Properties properties = new Properties();
            try {
                properties.load(CommonUtil.class.getClassLoader().getResourceAsStream("app.properties"));
                if (!properties.isEmpty()) {
                    sdkVersion = properties.getProperty("app.version");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sdkVersion;
    }
}

