/*
 * Decompiled with CFR 0.152.
 */
package cn.ruleengine.common.vo;

import cn.ruleengine.common.vo.ResultState;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

@ApiModel
public class BaseResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u8fd4\u56de\u72b6\u6001")
    private ResultState state = ResultState.SUCCESS;
    @ApiModelProperty(value="\u8fd4\u56de\u6d88\u606f")
    private String message = "\u6267\u884c\u6210\u529f";
    @ApiModelProperty(value="\u8fd4\u56de\u7801")
    private Integer code = 200;
    @ApiModelProperty(value="\u65f6\u95f4\u8f74")
    @JsonFormat(timezone="yyyy-MM-dd HH:mm:ss")
    private Date timestamp = new Date();

    public static BaseResult ok() {
        return new BaseResult();
    }

    public static BaseResult err() {
        return BaseResult.err(400, "\u6267\u884c\u5931\u8d25");
    }

    public static BaseResult err(Integer code, String message) {
        BaseResult baseResult = new BaseResult();
        baseResult.setState(ResultState.ERROR);
        baseResult.setMessage(message);
        baseResult.setCode(code);
        baseResult.setTimestamp(new Date());
        return baseResult;
    }

    public ResultState getState() {
        return this.state;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getCode() {
        return this.code;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setState(ResultState state) {
        this.state = state;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    @JsonFormat(timezone="yyyy-MM-dd HH:mm:ss")
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResult)) {
            return false;
        }
        BaseResult other = (BaseResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$code = this.getCode();
        Integer other$code = other.getCode();
        if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
            return false;
        }
        ResultState this$state = this.getState();
        ResultState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Date this$timestamp = this.getTimestamp();
        Date other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
        ResultState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Date $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    public String toString() {
        return "BaseResult(state=" + (Object)((Object)this.getState()) + ", message=" + this.getMessage() + ", code=" + this.getCode() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

