/*
 * Decompiled with CFR 0.152.
 */
package cn.smallbun.screw.maven.plugin.mojo;

import cn.smallbun.screw.core.Configuration;
import cn.smallbun.screw.core.engine.EngineConfig;
import cn.smallbun.screw.core.engine.EngineFileType;
import cn.smallbun.screw.core.engine.EngineTemplateType;
import cn.smallbun.screw.core.execute.DocumentationExecute;
import cn.smallbun.screw.core.process.ProcessConfig;
import cn.smallbun.screw.core.query.DatabaseType;
import cn.smallbun.screw.core.util.FileUtils;
import cn.smallbun.screw.core.util.JdbcUtils;
import cn.smallbun.screw.core.util.StringUtils;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.List;
import javax.sql.DataSource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="run", threadSafe=true, defaultPhase=LifecyclePhase.COMPILE)
public class RunDocMojo
extends AbstractMojo {
    @Parameter(property="organization")
    private String organization;
    @Parameter(property="organizationUrl")
    private String organizationUrl;
    @Parameter(property="title")
    private String title;
    @Parameter(property="version")
    private String version;
    @Parameter(property="description")
    private String description;
    @Parameter
    private volatile String username;
    @Parameter
    private volatile String password;
    @Parameter
    private String driverClassName;
    @Parameter
    private String jdbcUrl;
    @Parameter
    private List<String> tableName;
    @Parameter
    private List<String> tablePrefix;
    @Parameter
    private List<String> tableSuffix;
    @Parameter
    private List<String> designatedTableName;
    @Parameter
    private List<String> designatedTablePrefix;
    @Parameter
    private List<String> designatedTableSuffix;
    @Parameter(defaultValue="true")
    private boolean openOutputDir;
    @Parameter
    private String fileOutputDir;
    @Parameter(defaultValue="HTML")
    private EngineFileType fileType;
    @Parameter(defaultValue="freemarker")
    private EngineTemplateType produceType;
    @Parameter
    private String template;
    @Parameter
    private String fileName;

    public void execute() throws MojoFailureException {
        this.getLog().info((CharSequence)"Database design document generation begins \ud83d\ude80");
        long start = System.currentTimeMillis();
        this.validator();
        Configuration config = Configuration.builder().organization(this.getOrganization()).organizationUrl(this.getOrganizationUrl()).title(this.getTitle()).version(this.getVersion()).description(this.getDescription()).dataSource(this.getDataSource()).engineConfig(this.getEngineConfig()).produceConfig(this.getProcessConfig()).build();
        new DocumentationExecute(config).execute();
        this.getLog().info((CharSequence)String.format("Database design document generation is complete , time cost:%s second \ud83c\udf87", (System.currentTimeMillis() - start) / 1000L));
    }

    private EngineConfig getEngineConfig() {
        return EngineConfig.builder().openOutputDir(this.isOpenOutputDir()).fileOutputDir(this.getFileOutputDir()).fileType(this.getFileType()).produceType(this.getProduceType()).customTemplate(this.getTemplate()).fileName(this.getFileName()).build();
    }

    private ProcessConfig getProcessConfig() {
        return ProcessConfig.builder().ignoreTableName(this.getTableName()).ignoreTablePrefix(this.getTablePrefix()).ignoreTableSuffix(this.getTableSuffix()).designatedTableName(this.getDesignatedTableName()).designatedTablePrefix(this.getDesignatedTablePrefix()).designatedTableSuffix(this.getDesignatedTableSuffix()).build();
    }

    private DataSource getDataSource() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setPoolName("screw");
        hikariConfig.setDriverClassName(this.getDriverClassName().trim());
        hikariConfig.setJdbcUrl(this.getJdbcUrl());
        hikariConfig.setUsername(this.getUsername());
        hikariConfig.setPassword(this.getPassword());
        if (JdbcUtils.getDbType((String)this.getJdbcUrl()).equals((Object)DatabaseType.MYSQL) || JdbcUtils.getDbType((String)this.getJdbcUrl()).equals((Object)DatabaseType.MARIADB)) {
            hikariConfig.addDataSourceProperty("useInformationSchema", (Object)"true");
        }
        if (JdbcUtils.getDbType((String)this.getJdbcUrl()).equals((Object)DatabaseType.ORACLE)) {
            hikariConfig.addDataSourceProperty("remarks", (Object)"true");
        }
        return new HikariDataSource(hikariConfig);
    }

    private void validator() throws MojoFailureException {
        String path;
        boolean exists;
        if (StringUtils.isBlank((CharSequence)this.getUsername())) {
            throw new MojoFailureException("\u8bf7\u914d\u7f6e\u6570\u636e\u5e93\u7528\u6237\u540d");
        }
        if (StringUtils.isBlank((CharSequence)this.getDriverClassName())) {
            throw new MojoFailureException("\u8bf7\u914d\u7f6e\u6570\u636e\u5e93\u9a71\u52a8\u540d\u79f0");
        }
        if (StringUtils.isBlank((CharSequence)this.getJdbcUrl())) {
            throw new MojoFailureException("\u8bf7\u914d\u7f6e\u6570\u636e\u5e93URL\u5730\u5740");
        }
        if (StringUtils.isNotBlank((CharSequence)this.getTemplate()) && !(exists = FileUtils.isFileExists((String)(path = FileUtils.getRealFilePath((String)this.getTemplate()))))) {
            throw new MojoFailureException("\u672a\u68c0\u7d22\u5230\u6a21\u677f\u6587\u4ef6[" + path + "]");
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RunDocMojo)) {
            return false;
        }
        RunDocMojo other = (RunDocMojo)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$organization = this.getOrganization();
        String other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
            return false;
        }
        String this$organizationUrl = this.getOrganizationUrl();
        String other$organizationUrl = other.getOrganizationUrl();
        if (this$organizationUrl == null ? other$organizationUrl != null : !this$organizationUrl.equals(other$organizationUrl)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$driverClassName = this.getDriverClassName();
        String other$driverClassName = other.getDriverClassName();
        if (this$driverClassName == null ? other$driverClassName != null : !this$driverClassName.equals(other$driverClassName)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        List<String> this$tableName = this.getTableName();
        List<String> other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !((Object)this$tableName).equals(other$tableName)) {
            return false;
        }
        List<String> this$tablePrefix = this.getTablePrefix();
        List<String> other$tablePrefix = other.getTablePrefix();
        if (this$tablePrefix == null ? other$tablePrefix != null : !((Object)this$tablePrefix).equals(other$tablePrefix)) {
            return false;
        }
        List<String> this$tableSuffix = this.getTableSuffix();
        List<String> other$tableSuffix = other.getTableSuffix();
        if (this$tableSuffix == null ? other$tableSuffix != null : !((Object)this$tableSuffix).equals(other$tableSuffix)) {
            return false;
        }
        List<String> this$designatedTableName = this.getDesignatedTableName();
        List<String> other$designatedTableName = other.getDesignatedTableName();
        if (this$designatedTableName == null ? other$designatedTableName != null : !((Object)this$designatedTableName).equals(other$designatedTableName)) {
            return false;
        }
        List<String> this$designatedTablePrefix = this.getDesignatedTablePrefix();
        List<String> other$designatedTablePrefix = other.getDesignatedTablePrefix();
        if (this$designatedTablePrefix == null ? other$designatedTablePrefix != null : !((Object)this$designatedTablePrefix).equals(other$designatedTablePrefix)) {
            return false;
        }
        List<String> this$designatedTableSuffix = this.getDesignatedTableSuffix();
        List<String> other$designatedTableSuffix = other.getDesignatedTableSuffix();
        if (this$designatedTableSuffix == null ? other$designatedTableSuffix != null : !((Object)this$designatedTableSuffix).equals(other$designatedTableSuffix)) {
            return false;
        }
        if (this.isOpenOutputDir() != other.isOpenOutputDir()) {
            return false;
        }
        String this$fileOutputDir = this.getFileOutputDir();
        String other$fileOutputDir = other.getFileOutputDir();
        if (this$fileOutputDir == null ? other$fileOutputDir != null : !this$fileOutputDir.equals(other$fileOutputDir)) {
            return false;
        }
        EngineFileType this$fileType = this.getFileType();
        EngineFileType other$fileType = other.getFileType();
        if (this$fileType == null ? other$fileType != null : !this$fileType.equals(other$fileType)) {
            return false;
        }
        EngineTemplateType this$produceType = this.getProduceType();
        EngineTemplateType other$produceType = other.getProduceType();
        if (this$produceType == null ? other$produceType != null : !this$produceType.equals(other$produceType)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        return !(this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RunDocMojo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        String $organizationUrl = this.getOrganizationUrl();
        result = result * 59 + ($organizationUrl == null ? 43 : $organizationUrl.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $driverClassName = this.getDriverClassName();
        result = result * 59 + ($driverClassName == null ? 43 : $driverClassName.hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        List<String> $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : ((Object)$tableName).hashCode());
        List<String> $tablePrefix = this.getTablePrefix();
        result = result * 59 + ($tablePrefix == null ? 43 : ((Object)$tablePrefix).hashCode());
        List<String> $tableSuffix = this.getTableSuffix();
        result = result * 59 + ($tableSuffix == null ? 43 : ((Object)$tableSuffix).hashCode());
        List<String> $designatedTableName = this.getDesignatedTableName();
        result = result * 59 + ($designatedTableName == null ? 43 : ((Object)$designatedTableName).hashCode());
        List<String> $designatedTablePrefix = this.getDesignatedTablePrefix();
        result = result * 59 + ($designatedTablePrefix == null ? 43 : ((Object)$designatedTablePrefix).hashCode());
        List<String> $designatedTableSuffix = this.getDesignatedTableSuffix();
        result = result * 59 + ($designatedTableSuffix == null ? 43 : ((Object)$designatedTableSuffix).hashCode());
        result = result * 59 + (this.isOpenOutputDir() ? 79 : 97);
        String $fileOutputDir = this.getFileOutputDir();
        result = result * 59 + ($fileOutputDir == null ? 43 : $fileOutputDir.hashCode());
        EngineFileType $fileType = this.getFileType();
        result = result * 59 + ($fileType == null ? 43 : $fileType.hashCode());
        EngineTemplateType $produceType = this.getProduceType();
        result = result * 59 + ($produceType == null ? 43 : $produceType.hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        return result;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getOrganizationUrl() {
        return this.organizationUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public List<String> getTableName() {
        return this.tableName;
    }

    public List<String> getTablePrefix() {
        return this.tablePrefix;
    }

    public List<String> getTableSuffix() {
        return this.tableSuffix;
    }

    public List<String> getDesignatedTableName() {
        return this.designatedTableName;
    }

    public List<String> getDesignatedTablePrefix() {
        return this.designatedTablePrefix;
    }

    public List<String> getDesignatedTableSuffix() {
        return this.designatedTableSuffix;
    }

    public boolean isOpenOutputDir() {
        return this.openOutputDir;
    }

    public String getFileOutputDir() {
        return this.fileOutputDir;
    }

    public EngineFileType getFileType() {
        return this.fileType;
    }

    public EngineTemplateType getProduceType() {
        return this.produceType;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public void setOrganizationUrl(String organizationUrl) {
        this.organizationUrl = organizationUrl;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setTableName(List<String> tableName) {
        this.tableName = tableName;
    }

    public void setTablePrefix(List<String> tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setTableSuffix(List<String> tableSuffix) {
        this.tableSuffix = tableSuffix;
    }

    public void setDesignatedTableName(List<String> designatedTableName) {
        this.designatedTableName = designatedTableName;
    }

    public void setDesignatedTablePrefix(List<String> designatedTablePrefix) {
        this.designatedTablePrefix = designatedTablePrefix;
    }

    public void setDesignatedTableSuffix(List<String> designatedTableSuffix) {
        this.designatedTableSuffix = designatedTableSuffix;
    }

    public void setOpenOutputDir(boolean openOutputDir) {
        this.openOutputDir = openOutputDir;
    }

    public void setFileOutputDir(String fileOutputDir) {
        this.fileOutputDir = fileOutputDir;
    }

    public void setFileType(EngineFileType fileType) {
        this.fileType = fileType;
    }

    public void setProduceType(EngineTemplateType produceType) {
        this.produceType = produceType;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String toString() {
        return "RunDocMojo(organization=" + this.getOrganization() + ", organizationUrl=" + this.getOrganizationUrl() + ", title=" + this.getTitle() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", driverClassName=" + this.getDriverClassName() + ", jdbcUrl=" + this.getJdbcUrl() + ", tableName=" + this.getTableName() + ", tablePrefix=" + this.getTablePrefix() + ", tableSuffix=" + this.getTableSuffix() + ", designatedTableName=" + this.getDesignatedTableName() + ", designatedTablePrefix=" + this.getDesignatedTablePrefix() + ", designatedTableSuffix=" + this.getDesignatedTableSuffix() + ", openOutputDir=" + this.isOpenOutputDir() + ", fileOutputDir=" + this.getFileOutputDir() + ", fileType=" + this.getFileType() + ", produceType=" + this.getProduceType() + ", template=" + this.getTemplate() + ", fileName=" + this.getFileName() + ")";
    }
}

