/*
 * Decompiled with CFR 0.152.
 */
package cn.sticki.spel.validator.constraintvalidator;

import cn.sticki.spel.validator.core.SpelConstraintValidator;
import cn.sticki.spel.validator.core.exception.SpelParserException;
import cn.sticki.spel.validator.core.parse.SpelParser;
import cn.sticki.spel.validator.core.result.FieldValidResult;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractSpelNumberCompareValidator<T extends Annotation>
implements SpelConstraintValidator<T> {
    static final Set<Class<?>> SUPPORT_TYPE;

    public FieldValidResult isValid(Number fieldValue, String spel, String errorMessage, Object obj) {
        if (fieldValue == null) {
            return FieldValidResult.success();
        }
        Object numberValue = SpelParser.parse((String)spel, (Object)obj);
        if (!(numberValue instanceof Number)) {
            throw new SpelParserException("Expression [" + spel + "] calculate result must be Number.");
        }
        if (!this.compare(fieldValue, (Number)numberValue)) {
            return FieldValidResult.of((boolean)false, (Object[])new Object[]{numberValue});
        }
        return FieldValidResult.success();
    }

    protected abstract boolean compare(Number var1, Number var2);

    public Set<Class<?>> supportType() {
        return SUPPORT_TYPE;
    }

    static {
        HashSet<Class<Number>> hashSet = new HashSet<Class<Number>>();
        hashSet.add(Number.class);
        hashSet.add(Integer.TYPE);
        hashSet.add(Long.TYPE);
        hashSet.add(Float.TYPE);
        hashSet.add(Double.TYPE);
        hashSet.add(Short.TYPE);
        hashSet.add(Byte.TYPE);
        SUPPORT_TYPE = Collections.unmodifiableSet(hashSet);
    }
}

