/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.timer.hutool;

import cn.hutool.core.util.StrUtil;
import cn.hutool.cron.CronUtil;
import cn.hutool.cron.task.Task;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import cn.stylefeng.roses.kernel.timer.api.TimerAction;
import cn.stylefeng.roses.kernel.timer.api.TimerExeService;
import cn.stylefeng.roses.kernel.timer.api.exception.TimerException;
import cn.stylefeng.roses.kernel.timer.api.exception.enums.TimerExceptionEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HutoolTimerExeServiceImpl
implements TimerExeService {
    private static final Logger log = LoggerFactory.getLogger(HutoolTimerExeServiceImpl.class);

    public void start() {
        CronUtil.setMatchSecond((boolean)true);
        CronUtil.start();
    }

    public void stop() {
        CronUtil.stop();
    }

    public void startTimer(String taskId, String cron, String className) {
        if (StrUtil.isBlank((CharSequence)taskId)) {
            throw new TimerException((AbstractExceptionEnum)TimerExceptionEnum.PARAM_HAS_NULL, new Object[]{"taskId"});
        }
        if (StrUtil.isBlank((CharSequence)cron)) {
            throw new TimerException((AbstractExceptionEnum)TimerExceptionEnum.PARAM_HAS_NULL, new Object[]{"cron"});
        }
        if (StrUtil.isBlank((CharSequence)className)) {
            throw new TimerException((AbstractExceptionEnum)TimerExceptionEnum.PARAM_HAS_NULL, new Object[]{"className"});
        }
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new TimerException((AbstractExceptionEnum)TimerExceptionEnum.CLASS_NOT_FOUND, new Object[]{className});
        }
        Task task = () -> {
            try {
                TimerAction timerAction = (TimerAction)SpringUtil.getBean(Class.forName(className));
                timerAction.action();
            }
            catch (ClassNotFoundException e) {
                log.error("\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
        };
        CronUtil.schedule((String)taskId, (String)cron, (Task)task);
    }

    public void stopTimer(String taskId) {
        CronUtil.remove((String)taskId);
    }
}

