/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.usms.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.exception.ValidatorException;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import java.util.ArrayList;
import java.util.List;

public class DeleteUSMSSignatureParam
extends BaseRequestParam {
    private List<String> sigIds;

    @UcloudParam(value="SigIds")
    public List<Param> checkSigIds() throws ValidatorException {
        ArrayList<Param> params = new ArrayList<Param>();
        if (this.sigIds == null || this.sigIds.isEmpty()) {
            throw new ValidatorException("sigIds can not be empty");
        }
        int size = this.sigIds.size();
        String sigIdFormat = "SigIds.%d";
        for (int i = 0; i < size; ++i) {
            String sigId = this.sigIds.get(i);
            if (sigId == null || sigId.isEmpty()) {
                throw new ValidatorException(String.format("sigIds[%d] can not be empty", i));
            }
            params.add(new Param(String.format(sigIdFormat, i), (Object)sigId));
        }
        return params;
    }

    public DeleteUSMSSignatureParam(List<String> sigIds) {
        super("DeleteUSMSSignature");
        this.sigIds = sigIds;
    }

    public List<String> getSigIds() {
        return this.sigIds;
    }

    public void setSigIds(List<String> sigIds) {
        this.sigIds = sigIds;
    }
}

