/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.usms.model;

import cn.ucloud.common.annotation.UcloudParam;
import cn.ucloud.common.exception.ValidatorException;
import cn.ucloud.common.pojo.BaseRequestParam;
import cn.ucloud.common.pojo.Param;
import java.util.ArrayList;
import java.util.List;

public class DeleteUSMSTemplateParam
extends BaseRequestParam {
    private List<String> templateIds;

    @UcloudParam(value="TemplateIds")
    public List<Param> checkSigIds() throws ValidatorException {
        ArrayList<Param> params = new ArrayList<Param>();
        if (this.templateIds == null || this.templateIds.isEmpty()) {
            throw new ValidatorException("templateIds can not be empty");
        }
        int size = this.templateIds.size();
        String templateIdFormat = "TemplateIds.%d";
        for (int i = 0; i < size; ++i) {
            String templateId = this.templateIds.get(i);
            if (templateId == null || templateId.isEmpty()) {
                throw new ValidatorException(String.format("templateIds[%d] can not be empty", i));
            }
            params.add(new Param(String.format(templateIdFormat, i), (Object)templateId));
        }
        return params;
    }

    public DeleteUSMSTemplateParam(List<String> templateIds) {
        super("DeleteUSMSTemplate");
        this.templateIds = templateIds;
    }

    public List<String> getTemplateIds() {
        return this.templateIds;
    }

    public void setTemplateIds(List<String> templateIds) {
        this.templateIds = templateIds;
    }
}

