/*
 * Decompiled with CFR 0.152.
 */
package cn.ucloud.usms.util;

import cn.ucloud.common.exception.ValidatorException;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    public static String getFileContent2StringAfterBase64Encode(String path) throws ValidatorException {
        String value = "";
        FileInputStream fileInputStream = null;
        try {
            URL fileUrl = new URL("file://" + path);
            URLConnection urlConnection = fileUrl.openConnection();
            String type = urlConnection.getContentType();
            fileInputStream = new FileInputStream(path);
            int available = fileInputStream.available();
            byte[] buffer = new byte[available];
            int readLen = fileInputStream.read(buffer);
            log.info("file({}) mime-type:{} , size:{} , read size:{}", new Object[]{path, type, available, readLen});
            value = String.format("data:%s;base64,%s", type, new String(Base64.encodeBase64((byte[])buffer)));
        }
        catch (IOException e) {
            throw new ValidatorException(e.getMessage());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    log.error("close file({}) error:{}", (Object)path, (Object)e.getMessage());
                }
            }
        }
        return value;
    }
}

