/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.buildplugin;

import cn.weforward.buildplugin.RevisionControl;
import cn.weforward.buildplugin.support.AbstractBuildMojo;
import cn.weforward.buildplugin.util.VersionUtil;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="custom")
public class CustomMojo
extends AbstractBuildMojo {
    protected final boolean m_IsGenVersion = !"false".equalsIgnoreCase(System.getProperty("genVersion"));
    protected final boolean m_IsGrowVersion = "true".equalsIgnoreCase(System.getProperty("growVersion"));
    protected final boolean m_IsPackage = "true".equalsIgnoreCase(System.getProperty("package"));
    protected final boolean m_IsCommit = "true".equalsIgnoreCase(System.getProperty("commit"));
    protected final boolean m_IsTag = this.m_IsGrowVersion || "true".equalsIgnoreCase(System.getProperty("tag"));
    protected final boolean m_IsDist = "true".equalsIgnoreCase(System.getProperty("dist"));
    protected final boolean m_IsInstall = "true".equalsIgnoreCase(System.getProperty("install"));
    protected final boolean m_IsDeploy = "true".equalsIgnoreCase(System.getProperty("deploy"));

    public void execute() throws MojoExecutionException, MojoFailureException {
        File source;
        File jar;
        String version;
        RevisionControl rc = this.getRC();
        String incVersion = this.m_IsGrowVersion && this.m_IsGenVersion ? VersionUtil.genIncVersion(this.project, this.getMainVersion()) : VersionUtil.getIncVersion(this.project, this.getMainVersion());
        if (this.m_IsGenVersion) {
            boolean isDirty = rc.isDirty();
            if (isDirty) {
                if (this.m_IsGrowVersion) {
                    throw new MojoExecutionException("\u7248\u672c\u4e0d\u5e72\u51c0,\u4e0d\u80fd\u4e0a\u7ebf");
                }
                this.getLog().warn((CharSequence)"\u7248\u672c\u4e0d\u5e72\u51c0,\u6ce8\u610f\u4e0d\u80fd\u4e0a\u7ebf");
            }
            version = String.valueOf(this.genVersion(incVersion)) + (isDirty ? "M" : "");
            VersionUtil.setVersion(this.project, version);
        } else {
            version = this.project.getVersion();
        }
        if (this.m_IsPackage) {
            if ("jar".equals(this.project.getPackaging())) {
                this.createJar(version);
            }
        } else {
            version = this.project.getVersion();
        }
        if (this.m_IsCommit && !this.m_IsTag) {
            this.getLog().info((CharSequence)("Commit \u7248\u672c " + version));
            rc.commit("build \u7248\u672c " + version);
        }
        String tag = String.valueOf(this.getMainVersion()) + "." + incVersion;
        if (this.m_IsTag) {
            this.getLog().info((CharSequence)("Commit \u7248\u672c " + version));
            rc.commit("build \u7248\u672c " + version);
            String message = "Create Tag " + tag + " ";
            this.getLog().info((CharSequence)message);
            rc.tag(tag, message);
        }
        if (this.m_IsDist) {
            jar = AbstractBuildMojo.getJarFile(this.outputDirectory, this.finalName, "");
            this.getLog().info((CharSequence)("Dist " + jar.getName()));
            this.dist(jar, tag);
            this.getLog().info((CharSequence)("Dist \u7248\u672c " + version));
        }
        if (this.m_IsInstall) {
            jar = AbstractBuildMojo.getJarFile(this.outputDirectory, this.finalName, "");
            source = AbstractBuildMojo.getJarFile(this.outputDirectory, this.finalName, "sources");
            this.install(this.project.getArtifact(), this.project.getPackaging(), this.project.getFile(), jar, source);
            this.getLog().info((CharSequence)("Install \u7248\u672c " + this.project.getArtifact().getVersion()));
        }
        if (this.m_IsDeploy) {
            jar = AbstractBuildMojo.getJarFile(this.outputDirectory, this.finalName, "");
            source = AbstractBuildMojo.getJarFile(this.outputDirectory, this.finalName, "sources");
            this.deploy(this.project.getArtifact(), this.project.getPackaging(), this.project.getFile(), jar, source);
            this.getLog().info((CharSequence)("Deploy \u7248\u672c " + this.project.getArtifact().getVersion()));
        }
    }
}

