/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.buildplugin;

import cn.weforward.buildplugin.RevisionControl;
import cn.weforward.buildplugin.support.AbstractBuildMojo;
import cn.weforward.buildplugin.util.VersionUtil;
import java.io.File;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="jar")
public class JarBuildMojo
extends AbstractBuildMojo {
    protected final boolean m_IsGenVersion = !"false".equalsIgnoreCase(System.getProperty("genVersion"));
    @Parameter(defaultValue="${autoupload}")
    protected boolean autoupload;

    public void execute() throws MojoFailureException {
        String version;
        String tag;
        if (this.m_IsGenVersion) {
            RevisionControl rc = this.getRC();
            boolean isDirty = rc.isDirty();
            if (isDirty) {
                this.getLog().warn((CharSequence)"\u7248\u672c\u4e0d\u5e72\u51c0,\u6ce8\u610f\u4e0d\u80fd\u4e0a\u7ebf");
            }
            String incVersion = VersionUtil.getIncVersion(this.project, this.getMainVersion());
            tag = String.valueOf(this.getMainVersion()) + "." + incVersion;
            version = String.valueOf(this.genVersion(incVersion)) + (isDirty ? "M" : "");
            VersionUtil.setVersion(this.project, version);
        } else {
            String incVersion = VersionUtil.getIncVersion(this.project, this.getMainVersion());
            tag = String.valueOf(this.getMainVersion()) + "." + incVersion;
            version = this.project.getVersion();
        }
        if ("jar".equals(this.project.getPackaging())) {
            this.createJar(version);
        }
        if (this.autoupload) {
            File jar = AbstractBuildMojo.getJarFile(this.outputDirectory, this.finalName, "");
            this.getLog().info((CharSequence)("Dist " + jar.getName()));
            this.dist(jar, tag);
            this.getLog().info((CharSequence)("Dist \u7248\u672c " + version));
        }
    }
}

