/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.buildplugin;

import cn.weforward.buildplugin.support.AbstractBuildMojo;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="license")
public class LicenseBuildMojo
extends AbstractBuildMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        String dir = System.getProperty("user.dir");
        String licensePath = String.valueOf(dir) + File.separator + "LICENSE";
        File license = new File(licensePath);
        if (!license.exists() || !license.isFile()) {
            this.getLog().info((CharSequence)"LICENSE\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u6dfb\u52a0");
            return;
        }
        try {
            this.padding(this.sourceDirectory, license);
            this.padding(this.testSourceDirectory, license);
        }
        catch (IOException e) {
            throw new MojoFailureException("\u6dfb\u52a0LICENSE\u5f02\u5e38", (Throwable)e);
        }
    }

    private void padding(File directory, File license) throws IOException {
        if (directory == null) {
            return;
        }
        if (!directory.exists()) {
            this.getLog().info((CharSequence)("\u5ffd\u7565\u4e0d\u5b58\u5728\u7684\u76ee\u5f55:" + directory));
            return;
        }
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append("/**");
        Throwable throwable = null;
        Object var6_7 = null;
        try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(license)));){
            String line;
            while ((line = in.readLine()) != null) {
                sb.append(lineSeparator);
                sb.append(" * ");
                sb.append(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        sb.append(lineSeparator);
        sb.append(" * ");
        sb.append(lineSeparator);
        sb.append(" */");
        sb.append(lineSeparator);
        byte[] licenseContent = sb.toString().getBytes();
        this.paddingLicense(directory, licenseContent);
    }

    private void paddingLicense(File project, byte[] licenseContent) throws IOException {
        if (project.isDirectory()) {
            File[] fileArray = project.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.paddingLicense(child, licenseContent);
                ++n2;
            }
        } else if (project.getName().endsWith(".java")) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            boolean first = true;
            Throwable throwable = null;
            Object var6_4 = null;
            try (FileInputStream in = new FileInputStream(project);){
                byte[] bs = new byte[1024];
                int l = 0;
                while (-1 != (l = ((InputStream)in).read(bs))) {
                    if (first) {
                        if (new String(bs, 0, l).toString().startsWith("/**")) {
                            return;
                        }
                        first = false;
                    }
                    bytes.write(bs, 0, l);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.getLog().info((CharSequence)("\u6dfb\u52a0\u8bb8\u53ef\u8bc1 " + project));
            throwable = null;
            var6_4 = null;
            try (FileOutputStream out = new FileOutputStream(project);){
                ((OutputStream)out).write(licenseContent);
                ((OutputStream)out).write(bytes.toByteArray());
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }
}

