/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.buildplugin;

import cn.weforward.buildplugin.RevisionControl;
import cn.weforward.buildplugin.support.AbstractBuildMojo;
import cn.weforward.buildplugin.util.VersionUtil;
import java.io.File;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="prepare")
public class PrepareBuildMojo
extends AbstractBuildMojo {
    @Parameter(defaultValue="${autoupload}")
    protected boolean autoupload;

    public void execute() throws MojoFailureException {
        RevisionControl rc = this.getRC();
        boolean isDirty = rc.isDirty();
        if (isDirty) {
            this.getLog().warn((CharSequence)"\u7248\u672c\u4e0d\u5e72\u51c0,\u6ce8\u610f\u4e0d\u80fd\u4e0a\u7ebf");
        }
        String incVersion = VersionUtil.getIncVersion(this.project, this.getMainVersion());
        String tag = String.valueOf(this.getMainVersion()) + "." + incVersion;
        String newVersion = String.valueOf(this.genVersion(incVersion)) + (isDirty ? "M" : "");
        VersionUtil.setVersion(this.project, newVersion);
        if ("jar".equals(this.project.getPackaging())) {
            this.createJar(newVersion);
        }
        this.getLog().info((CharSequence)("Commit \u7248\u672c " + newVersion));
        rc.commit("build \u7248\u672c " + newVersion);
        if (this.autoupload) {
            File jar = AbstractBuildMojo.getJarFile(this.outputDirectory, this.finalName, "");
            this.getLog().info((CharSequence)("Dist " + jar.getName()));
            this.dist(jar, tag);
            this.getLog().info((CharSequence)("Dist \u7248\u672c " + newVersion));
        }
    }
}

