/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.buildplugin;

import cn.weforward.buildplugin.RevisionControl;
import cn.weforward.buildplugin.support.AbstractBuildMojo;
import cn.weforward.buildplugin.util.VersionUtil;
import java.io.File;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="public")
public class PublicBuildMojo
extends AbstractBuildMojo {
    @Parameter(defaultValue="${autoupload}")
    protected boolean autoupload;

    public void execute() throws MojoFailureException {
        RevisionControl rc = this.getRC();
        if (rc.isDirty()) {
            throw new MojoFailureException("\u7248\u672c\u4e0d\u5e72\u51c0\u4e0d\u80fd\u53d1\u5e03");
        }
        String incVersion = VersionUtil.genIncVersion(this.project, this.getMainVersion());
        String newVersion = this.genVersion(incVersion);
        VersionUtil.setVersion(this.project, newVersion);
        if ("jar".equals(this.project.getPackaging())) {
            this.createJar(newVersion);
        }
        String tag = String.valueOf(this.getMainVersion()) + "." + incVersion;
        this.getLog().info((CharSequence)("Commit \u7248\u672c " + newVersion));
        rc.commit("build \u7248\u672c " + newVersion);
        String message = "Create Tag " + tag + " ";
        this.getLog().info((CharSequence)message);
        rc.tag(tag, message);
        if (this.autoupload) {
            File jar = AbstractBuildMojo.getJarFile(this.outputDirectory, this.finalName, "");
            this.getLog().info((CharSequence)("Dist " + jar.getName()));
            this.dist(jar, tag);
            this.getLog().info((CharSequence)("Dist \u7248\u672c " + newVersion));
        }
    }
}

