/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.buildplugin;

import cn.weforward.buildplugin.RevisionControl;
import cn.weforward.buildplugin.support.AbstractBuildMojo;
import cn.weforward.buildplugin.util.StringUtil;
import cn.weforward.buildplugin.util.VersionUtil;
import org.apache.maven.model.Parent;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="version")
public class VersionBuildMojo
extends AbstractBuildMojo {
    @Parameter(defaultValue="${weforward.build.growVersion}")
    protected boolean growVersion = false;
    @Parameter(defaultValue="${weforward.build.growSerialVersion}")
    protected boolean growSerialVersion = true;
    @Parameter(defaultValue="${weforward.build.version.skip}")
    protected boolean skip = false;
    protected static String VERSION;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            return;
        }
        if (!this.project.isExecutionRoot()) {
            if (VERSION != null) {
                Parent modelParent;
                VersionUtil.setVersion(this.project, VERSION);
                MavenProject parent = this.project.getParent();
                if (parent != null) {
                    parent.setVersion(VERSION);
                }
                if ((modelParent = this.project.getModel().getParent()) != null) {
                    modelParent.setVersion(VERSION);
                }
            }
            return;
        }
        RevisionControl rc = this.getRC();
        boolean isDirty = rc.isDirty();
        if (isDirty) {
            if (this.growVersion) {
                throw new MojoExecutionException("\u7248\u672c\u4e0d\u5e72\u51c0,\u4e0d\u80fd\u4e0a\u7ebf");
            }
            this.getLog().warn((CharSequence)"\u7248\u672c\u4e0d\u5e72\u51c0,\u6ce8\u610f\u4e0d\u80fd\u4e0a\u7ebf");
        }
        String incVersion = this.growVersion ? VersionUtil.genIncVersion(this.project, this.getMainVersion()) : VersionUtil.getIncVersion(this.project, this.getMainVersion());
        String version = String.valueOf(this.getMainVersion()) + "." + incVersion + (this.growSerialVersion ? "." + rc.getVersion() : "") + (isDirty ? "M" : "");
        if (StringUtil.eq(this.project.getVersion(), version)) {
            return;
        }
        VersionUtil.setVersion(this.project, version);
        VERSION = version;
        this.getLog().info((CharSequence)("\u63d0\u4ea4\u7248\u672c " + version));
        rc.commit("\u63d0\u4ea4\u7248\u672c " + version);
        String tagVersion = String.valueOf(this.getMainVersion()) + "." + incVersion;
        if (this.growVersion) {
            String message = "\u751f\u6210\u6807\u7b7e " + tagVersion + " ";
            this.getLog().info((CharSequence)message);
            rc.tag(tagVersion, message);
        }
    }
}

