/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.buildplugin.support;

import cn.weforward.buildplugin.RevisionControl;
import cn.weforward.buildplugin.support.MojoLogUploadProgressBar;
import cn.weforward.buildplugin.support.RevisionControlByEmpty;
import cn.weforward.buildplugin.support.RevisionControlByGit;
import cn.weforward.buildplugin.support.RevisionControlBySvn;
import cn.weforward.buildplugin.util.DistUtil;
import cn.weforward.buildplugin.util.FileUtil;
import cn.weforward.buildplugin.util.JarUtil;
import cn.weforward.buildplugin.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.filter.DependencyNodeFilter;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.FilteringDependencyNodeVisitor;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;

public abstract class AbstractBuildMojo
extends AbstractMojo {
    private static final String DEFAULT_MAIN_VERSION = "1";
    @Component(hint="default")
    protected DependencyGraphBuilder m_DependencyGraphBuilder;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    protected ArtifactRepository localRepository;
    @Parameter(defaultValue="${main.version}")
    private String mainVersion;
    @Parameter
    protected String mainClass;
    @Parameter
    protected boolean fatjar;
    @Parameter(defaultValue="true")
    protected boolean withSource;
    @Parameter
    protected String[] includes;
    @Parameter
    protected String[] excludes;
    @Parameter
    protected boolean generatePomFile;
    @Parameter
    protected String artifactId;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    protected File outputDirectory;
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    protected File sourceDirectory;
    @Parameter(defaultValue="${project.build.testSourceDirectory}")
    protected File testSourceDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    protected File classDirectory;
    @Parameter(defaultValue="${project.build.libDirectory}")
    protected String libDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    protected String finalName;
    @Parameter(defaultValue="${svn.username}")
    protected String svnUserName;
    @Parameter(defaultValue="${svn.password}")
    protected String svnPassword;
    @Parameter(defaultValue="${git.username}")
    protected String gitUserName;
    @Parameter(defaultValue="${git.password}")
    protected String gitPassword;
    protected RevisionControl m_RC;
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @Parameter(defaultValue="${disthub.url}")
    protected String distHubUrl;
    @Parameter(defaultValue="${dist.username}")
    protected String distUsername;
    @Parameter(defaultValue="${dist.password}")
    protected String distPassword;
    @Component
    protected ArtifactFactory m_ArtifactFactory;
    @Component
    protected ArtifactRepositoryFactory m_RepositoryFactory;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> m_RepositoryLayouts;
    @Component
    private ArtifactDeployer m_Deployer;
    @Component
    protected ArtifactInstaller m_Installer;
    @Parameter(defaultValue="${distribution.repository.id}")
    protected String repositoryId;
    @Parameter(defaultValue="${distribution.repository.url}")
    protected String repositoryUrl;
    @Parameter(defaultValue="${distribution.repository.snapshot.url}")
    protected String repositorySnapshotUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String format(Date date) {
        SimpleDateFormat simpleDateFormat = FORMAT;
        synchronized (simpleDateFormat) {
            return FORMAT.format(date);
        }
    }

    public String getSvnUserName() {
        return this.svnUserName;
    }

    public String getSvnPassword() {
        return this.svnPassword;
    }

    public String getGitUserName() {
        return this.gitUserName;
    }

    public String getGitPassword() {
        return this.gitPassword;
    }

    protected String[] getIncludes() {
        return this.includes;
    }

    protected String[] getExcludes() {
        return this.excludes;
    }

    public String getMainVersion() {
        return this.mainVersion == null ? DEFAULT_MAIN_VERSION : this.mainVersion;
    }

    public String getCopyright() {
        Calendar cal = Calendar.getInstance();
        return "honintech (c) " + cal.get(1);
    }

    public RevisionControl getRC() throws MojoFailureException {
        if (this.m_RC != null) {
            return this.m_RC;
        }
        Scm scm = this.project.getScm();
        if (scm == null) {
            this.m_RC = new RevisionControlByEmpty();
        } else {
            String url = scm.getUrl();
            if (StringUtil.isEmpty(url)) {
                throw new MojoFailureException("\u8bf7\u5148\u914d\u7f6e<scm><url>");
            }
            this.m_RC = RevisionControlByGit.isGit(url) ? new RevisionControlByGit(this, this.project) : new RevisionControlBySvn(this, this.project);
        }
        return this.m_RC;
    }

    protected String genVersion(String incVersion) throws MojoFailureException {
        String newVersion = null;
        newVersion = String.valueOf(this.getMainVersion()) + "." + incVersion + "." + this.getRC().getVersion();
        return newVersion;
    }

    protected void createJar(String version) throws MojoFailureException {
        File original;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Implementation-Version", version);
        map.put("Main-Version", this.getMainVersion());
        map.put("Copyright", this.getCopyright());
        map.put("Built-Date", AbstractBuildMojo.format(new Date()));
        if (this.mainClass != null) {
            map.put("Main-Class", this.mainClass);
        }
        try {
            File jarFile = AbstractBuildMojo.getJarFile(this.outputDirectory, this.finalName, "");
            if (jarFile.exists()) {
                original = new File(jarFile.getAbsoluteFile() + ".original");
                if (original.exists()) {
                    original.delete();
                }
                jarFile.renameTo(original);
            }
            JarArchiver archiver = new JarArchiver();
            archiver.setDestFile(jarFile);
            if (this.fatjar) {
                JarUtil.packageSpringBootJar(archiver, this.classDirectory, map, this.getLibFiles(), this.getIncludes(), this.getExcludes());
            } else {
                JarUtil.packageJar(archiver, this.classDirectory, map, this.getIncludes(), this.getExcludes());
            }
            archiver.createArchive();
        }
        catch (Throwable e) {
            throw new MojoFailureException("\u751f\u6210jar\u5305\u5931\u8d25:" + e.getMessage(), e);
        }
        if (this.withSource && !this.fatjar) {
            File sourceJarFile = AbstractBuildMojo.getJarFile(this.outputDirectory, this.finalName, "sources");
            if (sourceJarFile.exists()) {
                original = new File(sourceJarFile.getAbsoluteFile() + ".original");
                if (original.exists()) {
                    original.delete();
                }
                sourceJarFile.renameTo(original);
            }
            JarArchiver sourceArchiver = new JarArchiver();
            sourceArchiver.setDestFile(sourceJarFile);
            try {
                JarUtil.packageJar(sourceArchiver, this.sourceDirectory, map, this.getIncludes(), this.getExcludes());
                sourceArchiver.createArchive();
            }
            catch (Exception e) {
                throw new MojoFailureException("\u751f\u6210source\u5305\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            }
        }
        this.getLog().info((CharSequence)("Build \u7248\u672c " + version));
    }

    public static File getJarFile(File dir, String name, String classifier) {
        if (dir == null) {
            throw new NullPointerException("\u76ee\u5f55\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (name == null) {
            throw new NullPointerException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StringBuilder fileName = new StringBuilder(name);
        if (!StringUtil.isEmpty(classifier)) {
            fileName.append("-").append(classifier);
        }
        fileName.append(".jar");
        return new File(dir, fileName.toString());
    }

    private List<DependencyNode> getDependencys() throws MojoFailureException {
        DependencyNode rootNode;
        ArtifactFilter artifactFilter = null;
        try {
            rootNode = this.m_DependencyGraphBuilder.buildDependencyGraph(this.project, artifactFilter);
        }
        catch (DependencyGraphBuilderException e) {
            throw new MojoFailureException("\u83b7\u53d6\u4f9d\u8d56\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        CollectingDependencyNodeVisitor collecting = new CollectingDependencyNodeVisitor();
        DependencyNodeFilter _NoMySelf = new DependencyNodeFilter(){

            public boolean accept(DependencyNode node) {
                Artifact a = node.getArtifact();
                return !StringUtil.eq(a.getGroupId(), AbstractBuildMojo.this.project.getGroupId()) || !StringUtil.eq(a.getArtifactId(), AbstractBuildMojo.this.project.getArtifactId()) || !StringUtil.eq(a.getVersion(), AbstractBuildMojo.this.project.getVersion());
            }
        };
        FilteringDependencyNodeVisitor visitor = new FilteringDependencyNodeVisitor((DependencyNodeVisitor)collecting, _NoMySelf);
        rootNode.accept((DependencyNodeVisitor)visitor);
        return collecting.getNodes();
    }

    private List<File> getLibFiles() throws MojoFailureException {
        File f;
        ArrayList<File> libs = new ArrayList<File>();
        for (DependencyNode node : this.getDependencys()) {
            Artifact a = node.getArtifact();
            if (!StringUtil.eq(a.getScope(), "runtime") && !StringUtil.eq(a.getScope(), "compile")) continue;
            if (!StringUtil.eq(a.getType(), "jar")) {
                throw new MojoFailureException("\u6682\u4e0d\u652f\u6301" + a.getType() + "\u7c7b\u578b\u7684\u4f9d\u8d56\u5bfc\u51fa," + a);
            }
            f = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(a));
            libs.add(f);
        }
        if (StringUtil.isEmpty(this.libDirectory)) {
            return libs;
        }
        File dir = new File(FileUtil.getAbsolutePath(this.libDirectory, null));
        if (!dir.exists() || !dir.isDirectory()) {
            return libs;
        }
        File[] fs = dir.listFiles();
        if (fs == null || fs.length == 0) {
            return libs;
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] fileArray = fs;
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            f = fileArray[n2];
            if (f.isFile() && f.getName().endsWith(".jar")) {
                list.add(f);
            }
            ++n2;
        }
        return list;
    }

    protected void dist(File file, String tag) throws MojoFailureException {
        String url = String.valueOf(this.distHubUrl) + this.project.getName() + "/" + tag + "/";
        try {
            DistUtil.uploadFile(url, file, this.distUsername, this.distPassword, new MojoLogUploadProgressBar(this.getLog()));
        }
        catch (IOException | InterruptedException e) {
            throw new MojoFailureException("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
    }

    protected void install(Artifact artifact, String packaging, File pom, File jar, File source) throws MojoFailureException {
        try {
            if ("pom".equals(packaging)) {
                this.m_Installer.install(pom, artifact, this.localRepository);
            } else {
                if (jar != null && jar.isFile()) {
                    Artifact myArtifact;
                    if (this.generatePomFile) {
                        myArtifact = this.m_ArtifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), packaging, null);
                        myArtifact.addMetadata((ArtifactMetadata)new ProjectArtifactMetadata(artifact, this.generatePomFile()));
                    } else {
                        artifact.addMetadata((ArtifactMetadata)new ProjectArtifactMetadata(artifact, pom));
                        myArtifact = artifact;
                    }
                    this.m_Installer.install(jar, artifact, this.localRepository);
                } else {
                    this.getLog().warn((CharSequence)"\u6ca1\u6709jar\u5305\u53ef\u5b89\u88c5");
                }
                if (source != null && source.isFile()) {
                    Artifact sourceArtifact = this.m_ArtifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "jar", "sources");
                    this.m_Installer.install(source, sourceArtifact, this.localRepository);
                }
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("\u5b89\u88c5\u9879\u76ee\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
    }

    public String getArtifactId() {
        return this.artifactId == null ? this.project.getArtifactId() : this.artifactId;
    }

    protected void deploy(Artifact artifact, String packaging, File pom, File jar, File source) throws MojoFailureException {
        File sshFile;
        ArtifactRepository remoteRepository = this.getRemoteRepository();
        if (remoteRepository == null) {
            throw new MojoFailureException("\u672a\u914d\u7f6e\u53d1\u5e03\u7528\u7684\u4ed3\u5e93");
        }
        String protocol = remoteRepository.getProtocol();
        if (protocol.equalsIgnoreCase("scp") && !(sshFile = new File(System.getProperty("user.home"), ".ssh")).exists()) {
            sshFile.mkdirs();
        }
        try {
            if ("pom".equals(packaging)) {
                this.m_Deployer.deploy(pom, artifact, remoteRepository, this.localRepository);
            } else if ("jar".equals(packaging)) {
                if (jar != null && jar.isFile()) {
                    Artifact myArtifact;
                    if (this.generatePomFile) {
                        myArtifact = this.m_ArtifactFactory.createArtifactWithClassifier(artifact.getGroupId(), this.getArtifactId(), artifact.getVersion(), packaging, null);
                        myArtifact.addMetadata((ArtifactMetadata)new ProjectArtifactMetadata(artifact, this.generatePomFile()));
                    } else {
                        artifact.addMetadata((ArtifactMetadata)new ProjectArtifactMetadata(artifact, pom));
                        myArtifact = artifact;
                    }
                    this.m_Deployer.deploy(jar, myArtifact, remoteRepository, this.localRepository);
                } else {
                    this.getLog().warn((CharSequence)"\u6ca1\u6709jar\u5305\u53ef\u53d1\u5e03");
                }
                if (source != null && source.isFile()) {
                    Artifact sourceArtifact = this.m_ArtifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), packaging, "sources");
                    this.m_Deployer.deploy(source, sourceArtifact, remoteRepository, this.localRepository);
                }
            }
        }
        catch (Exception e) {
            throw new MojoFailureException("\u5b89\u88c5\u9879\u76ee\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
    }

    private File generatePomFile() throws MojoExecutionException {
        File file;
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.project.getGroupId());
        model.setArtifactId(this.project.getArtifactId());
        model.setVersion(this.project.getVersion());
        model.setPackaging(this.project.getPackaging());
        model.setDescription(this.project.getDescription());
        XmlStreamWriter fw = null;
        try {
            File tempFile = File.createTempFile("mvndeploy", ".pom");
            tempFile.deleteOnExit();
            fw = WriterFactory.newXmlWriter((File)tempFile);
            new MavenXpp3Writer().write((Writer)fw, model);
            file = tempFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fw);
                throw throwable;
            }
        }
        IOUtil.close((Writer)fw);
        return file;
    }

    private ArtifactRepository getRemoteRepository() {
        String repid = this.repositoryId;
        String repourl = ArtifactUtils.isSnapshot((String)this.project.getVersion()) && !StringUtil.isEmpty(this.repositorySnapshotUrl) ? this.repositorySnapshotUrl : this.repositoryUrl;
        ArtifactRepository repository = null;
        if (!StringUtil.isEmpty(repourl) && !StringUtil.isEmpty(repid)) {
            repository = this.m_RepositoryFactory.createDeploymentArtifactRepository(repid, repourl, this.m_RepositoryLayouts.get("default"), true);
        }
        if (repository == null) {
            repository = this.project.getDistributionManagementArtifactRepository();
        }
        return repository;
    }
}

