/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.buildplugin.support;

import cn.weforward.buildplugin.RevisionControl;
import cn.weforward.buildplugin.support.AbstractBuildMojo;
import cn.weforward.buildplugin.util.StringUtil;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class RevisionControlByGit
implements RevisionControl {
    protected Log m_Log;
    protected Git m_Git;
    protected final String m_Url;
    protected final String m_TagUrl;
    protected UsernamePasswordCredentialsProvider m_CredentialsProvider;
    private static DateFormat FORMAT;

    static {
        System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
        JschConfigSessionFactory jschConfigSessionFactory = new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host hc, Session session) {
                session.setConfig("StrictHostKeyChecking", "no");
            }
        };
        SshSessionFactory.setInstance((SshSessionFactory)jschConfigSessionFactory);
        FORMAT = new SimpleDateFormat("yyyyMMdd");
    }

    public RevisionControlByGit(AbstractBuildMojo mojo, MavenProject project) throws MojoFailureException {
        this(new File(System.getProperty("user.dir")), project.getScm().getUrl(), project.getScm().getTag(), mojo.getGitUserName(), mojo.getGitPassword());
        this.setLog(mojo.getLog());
    }

    public RevisionControlByGit(File workspace, String url, String tagUrl, String username, String password) throws MojoFailureException {
        this.m_Url = url;
        this.m_TagUrl = tagUrl;
        while (workspace != null && workspace.exists()) {
            try {
                this.m_Git = Git.open((File)workspace);
                break;
            }
            catch (RepositoryNotFoundException e) {
                workspace = workspace.getParentFile();
            }
            catch (IOException e) {
                throw new MojoFailureException("\u5f00\u542fgit\u5931\u8d25:" + e.getMessage(), (Throwable)e);
            }
        }
        if (username != null && password != null) {
            this.m_CredentialsProvider = new UsernamePasswordCredentialsProvider(username, password);
        }
    }

    public static boolean isGit(String url) {
        return url.endsWith(".git") || url.startsWith("git@");
    }

    private boolean isHttp(String url) {
        return url.startsWith("http");
    }

    public void setLog(Log log) {
        this.m_Log = log;
    }

    protected void info(String message) {
        if (this.m_Log != null) {
            this.m_Log.info((CharSequence)message);
        } else {
            System.out.println(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() throws MojoFailureException {
        Iterable it;
        try {
            it = this.m_Git.log().setMaxCount(1).all().call();
        }
        catch (IOException | GitAPIException e) {
            throw new MojoFailureException("\u8c03\u7528Git\u65e5\u5fd7\u5931\u8d25:" + e.getMessage(), e);
        }
        Iterator iterator = it.iterator();
        if (iterator.hasNext()) {
            RevCommit r = (RevCommit)iterator.next();
            DateFormat dateFormat = FORMAT;
            synchronized (dateFormat) {
                return FORMAT.format(new Date((long)r.getCommitTime() * 1000L));
            }
        }
        throw new MojoFailureException("\u672a\u6709Git\u63d0\u4ea4\u65e5\u5fd7");
    }

    @Override
    public boolean isDirty() throws MojoFailureException {
        try {
            Status status = this.m_Git.status().call();
            boolean uncommit = status.hasUncommittedChanges();
            if (uncommit) {
                for (String add : status.getAdded()) {
                    this.info("add " + add);
                }
                for (String changed : status.getChanged()) {
                    this.info("changed " + changed);
                }
                for (String removed : status.getRemoved()) {
                    this.info("removed " + removed);
                }
                for (String conflicting : status.getMissing()) {
                    this.info("conflicting " + conflicting);
                }
                for (String modified : status.getModified()) {
                    this.info("modified " + modified);
                }
            }
            return uncommit;
        }
        catch (GitAPIException | NoWorkTreeException e) {
            throw new MojoFailureException("\u8c03\u7528Git\u72b6\u6001\u5931\u8d25:" + e.getMessage(), e);
        }
    }

    @Override
    public void commit(String message) throws MojoFailureException {
        Iterable rr;
        try {
            AddCommand add = this.m_Git.add().addFilepattern(".");
            add.call();
        }
        catch (GitAPIException e) {
            throw new MojoFailureException("\u8c03\u7528Git\u6dfb\u52a0\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        try {
            RevCommit commitCommand = this.m_Git.commit().setMessage(message).call();
            this.info(commitCommand.getId().toString());
        }
        catch (GitAPIException e) {
            throw new MojoFailureException("\u8c03\u7528Git\u63d0\u4ea4\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        try {
            rr = this.createPushCommond(this.m_Url).call();
        }
        catch (GitAPIException e) {
            throw new MojoFailureException("\u8c03\u7528Git\u63a8\u9001\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        this.checkPushResult(rr);
    }

    @Override
    public void tag(String tag, String message) throws MojoFailureException {
        Iterable rr;
        Ref ref;
        try {
            ref = this.m_Git.tag().setForceUpdate(true).setName(tag).setMessage(message).call();
        }
        catch (GitAPIException e) {
            throw new MojoFailureException("\u8c03\u7528Git\u6807\u7b7e\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        RefSpec specs = new RefSpec(ref.getName());
        try {
            PushCommand push = this.createPushCommond(this.m_TagUrl);
            push.setRefSpecs(new RefSpec[]{specs});
            rr = push.call();
        }
        catch (GitAPIException e) {
            throw new MojoFailureException("\u8c03\u7528Git\u63a8\u9001\u5931\u8d25:" + e.getMessage(), (Throwable)e);
        }
        this.checkPushResult(rr);
    }

    private PushCommand createPushCommond(String url) {
        PushCommand push = this.m_Git.push();
        if (this.isHttp(url)) {
            push.setCredentialsProvider((CredentialsProvider)this.m_CredentialsProvider);
        }
        push.setRemote(url);
        return push;
    }

    private void checkPushResult(Iterable<PushResult> rr) throws MojoFailureException {
        for (PushResult r : rr) {
            if (!StringUtil.isEmpty(r.getMessages())) {
                this.info(r.getMessages());
            }
            for (RemoteRefUpdate update : r.getRemoteUpdates()) {
                if (!StringUtil.isEmpty(update.getMessage())) {
                    this.info(String.valueOf(update.getRemoteName()) + "->" + update.getMessage());
                    continue;
                }
                this.info(String.valueOf(update.getRemoteName()) + "->" + update.getStatus());
            }
        }
    }
}

