/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.buildplugin.support;

import cn.weforward.buildplugin.RevisionControl;
import cn.weforward.buildplugin.support.AbstractBuildMojo;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class RevisionControlBySvn
implements RevisionControl {
    protected final File m_Workspace;
    protected final String m_Url;
    protected final String m_TagUrl;
    protected final Log m_Log;
    protected final SVNRepository m_Repository;
    protected final SVNClientManager m_ClientManager;

    static {
        DAVRepositoryFactory.setup();
    }

    public RevisionControlBySvn(AbstractBuildMojo mojo, MavenProject project) throws MojoFailureException {
        this.m_Log = mojo.getLog();
        Scm scm = project.getScm();
        this.m_Url = scm.getUrl();
        this.m_TagUrl = scm.getTag();
        this.m_Workspace = new File(System.getProperty("user.dir"));
        String userName = mojo.getSvnUserName();
        char[] Password = mojo.getSvnPassword().toCharArray();
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)userName, (char[])Password);
        try {
            this.m_Repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)this.m_Url));
        }
        catch (SVNException e) {
            throw new MojoFailureException("\u89e3\u6790" + this.m_Url + "\u51fa\u9519", (Throwable)e);
        }
        this.m_Repository.setAuthenticationManager(authManager);
        this.m_ClientManager = SVNClientManager.newInstance((ISVNOptions)SVNWCUtil.createDefaultOptions((boolean)true), (ISVNAuthenticationManager)authManager);
    }

    private Log getLog() {
        return this.m_Log;
    }

    @Override
    public String getVersion() throws MojoFailureException {
        try {
            return String.valueOf(this.m_Repository.getLatestRevision());
        }
        catch (SVNException e) {
            throw new MojoFailureException("\u83b7\u53d6\u7248\u672c\u4fe1\u606f\u51fa\u9519:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isDirty() throws MojoFailureException {
        SVNStatusClient ssc = this.m_ClientManager.getStatusClient();
        DirtyList list = new DirtyList();
        try {
            ssc.doStatus(this.m_Workspace, SVNRevision.create((Date)new Date()), SVNDepth.INFINITY, false, false, false, false, (ISVNStatusHandler)list, null);
        }
        catch (SVNException e) {
            throw new MojoFailureException("\u83b7\u53d6\u7248\u672c\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
        boolean isDirty = false;
        for (File f : list.getModfiles()) {
            this.getLog().error((CharSequence)(String.valueOf(f.getAbsolutePath()) + "\u6587\u4ef6\u4fee\u6539\u672a\u63d0\u4ea4"));
            isDirty = true;
        }
        for (File f : list.getDeleteFiles()) {
            this.getLog().error((CharSequence)(String.valueOf(f.getAbsolutePath()) + "\u6587\u4ef6\u5220\u9664\u672a\u63d0\u4ea4"));
            isDirty = true;
        }
        for (File f : list.getAddFiles()) {
            this.getLog().error((CharSequence)(String.valueOf(f.getAbsolutePath()) + "\u6587\u4ef6\u589e\u52a0\u672a\u63d0\u4ea4"));
            isDirty = true;
        }
        return isDirty;
    }

    @Override
    public void commit(String message) throws MojoFailureException {
        SVNStatusClient ssc = this.m_ClientManager.getStatusClient();
        DirtyList list = new DirtyList();
        try {
            ssc.doStatus(this.m_Workspace, SVNRevision.create((Date)new Date()), SVNDepth.INFINITY, false, false, false, false, (ISVNStatusHandler)list, null);
        }
        catch (SVNException e) {
            throw new MojoFailureException("\u83b7\u53d6\u7248\u672c\u4fe1\u606f\u51fa\u9519", (Throwable)e);
        }
        SVNWCClient wcc = this.m_ClientManager.getWCClient();
        if (!list.getDeleteFiles().isEmpty()) {
            File[] fileArr = new File[list.getDeleteFiles().size()];
            fileArr = list.getDeleteFiles().toArray(fileArr);
            for (File file : list.getDeleteFiles()) {
                try {
                    wcc.doDelete(file, true, true, true);
                }
                catch (SVNException e) {
                    throw new MojoFailureException("\u63d0\u4ea4\u5220\u9664\u4fee\u6539\u51fa\u9519", (Throwable)e);
                }
            }
        }
        if (!list.getAddFiles().isEmpty()) {
            for (File f : list.getAddFiles()) {
                try {
                    wcc.doAdd(f, true, f.isDirectory(), true, SVNDepth.fromRecurse((boolean)true), true, false, true);
                }
                catch (SVNException e) {
                    throw new MojoFailureException("\u63d0\u4ea4\u6dfb\u52a0\u4fee\u6539\u51fa\u9519", (Throwable)e);
                }
            }
        }
        SVNCommitClient ctc = this.m_ClientManager.getCommitClient();
        if (!list.getModfiles().isEmpty()) {
            File[] fileArray2 = new File[list.getModfiles().size()];
            fileArray2 = list.getModfiles().toArray(fileArray2);
            try {
                ctc.doCommit(fileArray2, false, message, new SVNProperties(), null, true, true, SVNDepth.INFINITY);
            }
            catch (SVNException e) {
                throw new MojoFailureException("\u63d0\u4ea4\u4fee\u6539\u51fa\u9519", (Throwable)e);
            }
        }
    }

    @Override
    public void tag(String tag, String message) throws MojoFailureException {
        long latestRevision;
        SVNURL tags;
        SVNURL trunk;
        String trunkUrl = this.m_Url;
        String tagsUrl = String.valueOf(this.m_TagUrl) + "/" + tag;
        try {
            trunk = SVNURL.parseURIEncoded((String)trunkUrl);
        }
        catch (SVNException e) {
            throw new MojoFailureException("\u89e3\u6790" + trunkUrl + "\u51fa\u9519", (Throwable)e);
        }
        try {
            tags = SVNURL.parseURIEncoded((String)tagsUrl);
        }
        catch (SVNException e) {
            throw new MojoFailureException("\u89e3\u6790" + tagsUrl + "\u51fa\u9519", (Throwable)e);
        }
        SVNCopyClient cpClient = this.m_ClientManager.getCopyClient();
        try {
            latestRevision = this.m_Repository.getLatestRevision();
        }
        catch (SVNException e) {
            throw new MojoFailureException("\u83b7\u53d6svn\u7248\u672c\u51fa\u9519", (Throwable)e);
        }
        SVNRevision pegRevision = SVNRevision.create((long)latestRevision);
        SVNRevision revision = SVNRevision.create((long)latestRevision);
        SVNCopySource[] sources = new SVNCopySource[]{new SVNCopySource(pegRevision, revision, trunk)};
        try {
            cpClient.doCopy(sources, tags, false, true, true, message, new SVNProperties());
        }
        catch (SVNException e) {
            throw new MojoFailureException("\u590d\u5236\u4e3b\u5e72\u51fa\u9519", (Throwable)e);
        }
    }

    public static class DirtyList
    implements ISVNStatusHandler {
        protected List<File> modfiles = new ArrayList<File>();
        protected List<File> deletefiles = new ArrayList<File>();
        protected List<File> addFiles = new ArrayList<File>();

        public List<File> getModfiles() {
            return this.modfiles;
        }

        public List<File> getDeleteFiles() {
            return this.deletefiles;
        }

        public List<File> getAddFiles() {
            return this.addFiles;
        }

        public void handleStatus(SVNStatus status) throws SVNException {
            SVNStatusType type = status.getNodeStatus();
            if (type.getID() == SVNStatusType.STATUS_MODIFIED.getID()) {
                this.modfiles.add(status.getFile());
            } else if (type.getID() == SVNStatusType.STATUS_ADDED.getID()) {
                this.addFiles.add(status.getFile());
            } else if (type.getID() == SVNStatusType.STATUS_DELETED.getID()) {
                this.deletefiles.add(status.getFile());
                this.modfiles.add(status.getFile());
            }
        }
    }
}

