/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.buildplugin.util;

import cn.weforward.buildplugin.UploadProgressBar;
import cn.weforward.buildplugin.util.StringUtil;
import cn.weforward.buildplugin.util.UploadFileHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;

public class DistUtil {
    public static void uploadFile(String disturl, File file, String username, String password, UploadProgressBar progressBar) throws IOException, InterruptedException {
        URI uri;
        NioEventLoopGroup group = null;
        try {
            uri = new URI(disturl);
        }
        catch (URISyntaxException e) {
            throw new UnsupportedOperationException(String.valueOf(disturl) + "\u4e0d\u5408\u6cd5");
        }
        try {
            final UploadFileHandler handler = new UploadFileHandler(uri, file, progressBar, username, password);
            group = new NioEventLoopGroup();
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) throws Exception {
                    channel.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(61L, 30L, 0L, TimeUnit.SECONDS)});
                    channel.pipeline().addLast("s-encoder", (ChannelHandler)new HttpRequestEncoder());
                    channel.pipeline().addLast("s-decoder", (ChannelHandler)new HttpResponseDecoder());
                    channel.pipeline().addLast(new ChannelHandler[]{handler});
                }
            });
            int port = uri.getPort();
            if (port == -1) {
                port = StringUtil.eq(uri.getScheme(), "https") ? 443 : 80;
            }
            String host = uri.getHost();
            ChannelFuture future = bootstrap.connect(host, port).sync();
            future.channel().closeFuture().sync();
        }
        finally {
            if (group != null) {
                group.shutdownGracefully();
            }
        }
    }

    public static void uploadFile(String disturl, File file, String username, String password) throws IOException {
        String end = "\r\n";
        String twoHyphens = "--";
        String boundary = "----WeforwardBoundary" + System.currentTimeMillis();
        FilterOutputStream ds = null;
        InputStream inputStream = null;
        String actionUrl = String.valueOf(disturl) + file.getName();
        try {
            URL url = new URL(actionUrl);
            URLConnection urlConnection = url.openConnection();
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setRequestProperty("Connection", "Keep-Alive");
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
            if (!StringUtil.isEmpty(username) && !StringUtil.isEmpty(password)) {
                String basic = "Basic " + new String(Base64.encodeBase64URLSafe((byte[])(String.valueOf(username) + ":" + password).getBytes()));
                httpURLConnection.setRequestProperty("Authorization", basic);
            }
            httpURLConnection.setReadTimeout(1800000);
            ds = new DataOutputStream(httpURLConnection.getOutputStream());
            ((DataOutputStream)ds).writeBytes(String.valueOf(twoHyphens) + boundary + end);
            ((DataOutputStream)ds).writeBytes("Content-Disposition: form-data; name=\"file\";filename=\"" + file.getName() + "\"" + end);
            ((DataOutputStream)ds).writeBytes(end);
            FileInputStream fStream = new FileInputStream(file);
            int bufferSize = 4096;
            byte[] buffer = new byte[bufferSize];
            int length = -1;
            while ((length = fStream.read(buffer)) != -1) {
                ((DataOutputStream)ds).write(buffer, 0, length);
            }
            ((DataOutputStream)ds).writeBytes(end);
            fStream.close();
            ((DataOutputStream)ds).writeBytes(String.valueOf(twoHyphens) + boundary + twoHyphens + end);
            ((DataOutputStream)ds).flush();
            if (httpURLConnection.getResponseCode() != 200) {
                throw new IOException("HTTP Request is not success, Response code is " + httpURLConnection.getResponseCode());
            }
        }
        finally {
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

