/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.buildplugin.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.plugin.logging.Log;

public class FileUtil {
    public static FilenameFilter DEFAULT_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.equals(".svn") && !name.equals("classes");
        }
    };

    private FileUtil() {
    }

    public static String getAbsolutePath(String path, String root) {
        char ch;
        path = path == null ? "" : path.trim();
        char c = ch = path.length() > 0 ? (char)path.charAt(0) : (char)' ';
        if ('/' != ch && '\\' != ch && (path.length() < 2 || path.charAt(1) != ':')) {
            String sp;
            if (root == null) {
                root = System.getProperty("user.dir");
            }
            if ((sp = System.getProperty("file.separator")) == null || sp.length() == 0) {
                sp = "/";
            }
            if ('/' == (ch = (char)root.charAt(root.length() - 1)) || '\\' == ch || sp.charAt(0) == ch) {
                root = root.substring(0, root.length() - 1);
            }
            while (path.startsWith("../")) {
                int idx = root.lastIndexOf(sp);
                if (-1 == idx) break;
                root = root.substring(0, idx);
                path = path.substring(3, path.length());
            }
            path = String.valueOf(root) + sp + path;
        }
        return path;
    }

    public static void close(Closeable able) throws IOException {
        if (able != null) {
            able.close();
        }
    }

    public static void copy(File file, String newPath, Log log, int options) throws IOException {
        if (file.isDirectory()) {
            new File(newPath).mkdirs();
            if (log != null) {
                log.debug((CharSequence)("mkdir " + newPath));
            }
            File[] fileArray = file.listFiles(DEFAULT_FILTER);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FileUtil.copy(f, String.valueOf(newPath) + File.separator + f.getName(), log, options);
                ++n2;
            }
        } else {
            FileUtil.copyFile(file, newPath, log);
        }
    }

    public static void delate(File file, Log log) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FileUtil.delate(f, log);
                ++n2;
            }
            boolean isSuccess = file.delete();
            if (log != null) {
                log.debug((CharSequence)("delete " + file.getAbsolutePath() + " " + isSuccess));
            }
            if (!isSuccess) {
                throw new IOException("\u5220\u9664" + file.getAbsolutePath() + "\u5931\u8d25");
            }
        } else {
            boolean isSuccess = file.delete();
            if (log != null) {
                log.debug((CharSequence)("delete " + file.getAbsolutePath() + " " + isSuccess));
            }
            if (!isSuccess) {
                throw new IOException("\u5220\u9664" + file.getAbsolutePath() + "\u5931\u8d25");
            }
        }
    }

    public static void copyFile(File file, String newPath, Log log) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(file);
            out = new FileOutputStream(newPath);
            int byteread = 0;
            byte[] buffer = new byte[1024];
            while ((byteread = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, byteread);
            }
            if (log != null) {
                log.debug((CharSequence)("copy  " + file.getAbsolutePath() + " to " + newPath));
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(in);
            FileUtil.close(out);
            throw throwable;
        }
        FileUtil.close(in);
        FileUtil.close(out);
    }

    public static void sureDir(File file) {
        if (file == null) {
            return;
        }
        File p = file.getParentFile();
        if (p.exists()) {
            return;
        }
        FileUtil.sureDir(p);
        p.mkdir();
    }

    public static void clearDir(File dir) {
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                FileUtil.clearDir(f);
                ++n2;
            }
            dir.deleteOnExit();
        } else {
            dir.deleteOnExit();
        }
    }

    public static void copyFile(InputStream in, String newPath) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(newPath);
            int byteread = 0;
            byte[] buffer = new byte[1024];
            while ((byteread = in.read(buffer)) != -1) {
                out.write(buffer, 0, byteread);
            }
        }
        finally {
            FileUtil.close(in);
            FileUtil.close(out);
        }
    }

    public static boolean isOption(int options, int option) {
        return options == (options & options);
    }
}

