/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.buildplugin.util;

import cn.weforward.buildplugin.util.FileUtil;
import cn.weforward.buildplugin.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.springframework.boot.loader.JarLauncher;
import org.springframework.boot.loader.Launcher;

public class JarUtil {
    private JarUtil() {
    }

    public static void packageJar(JarArchiver archiver, File classdir, Map<String, String> mainfest, String[] includes, String[] excludes) throws ArchiverException, ManifestException, IOException {
        if (classdir.isDirectory()) {
            archiver.addDirectory(classdir, includes, excludes);
        }
        if (mainfest != null) {
            Manifest newManifest = Manifest.getDefaultManifest();
            for (Map.Entry<String, String> e : mainfest.entrySet()) {
                newManifest.addConfiguredAttribute(new Manifest.Attribute(e.getKey(), e.getValue()));
            }
            archiver.addConfiguredManifest(newManifest);
        }
    }

    public static JarArchiver packageSpringBootJar(JarArchiver archiver, File classdir, Map<String, String> mainfest, List<File> libs, String[] includes, String[] excludes) throws ArchiverException, ManifestException, IOException {
        File boottmp = new File(System.getProperty("java.io.tmpdir"), "springbootloader");
        if (!boottmp.exists()) {
            boottmp.mkdir();
        }
        JarUtil.initSpringBootLoader(boottmp, archiver);
        String classes = "BOOT-INF/classes/";
        String lib = "BOOT-INF/lib/";
        archiver.addDirectory(classdir, classes, includes, JarUtil.concat(excludes, "**/META-INF/**"));
        File[] fileArray = classdir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (StringUtil.eq(f.getName(), "META-INF")) {
                archiver.addDirectory(f, "/META-INF/", null, JarUtil.concat(null, "**/MANIFEST.MF/**"));
                break;
            }
            ++n2;
        }
        if (libs != null) {
            String prefix = lib;
            for (File f : libs) {
                String name = String.valueOf(prefix) + f.getName();
                archiver.addFile(f, name);
            }
        }
        Manifest newManifest = Manifest.getDefaultManifest();
        String mainClass = mainfest.get("Main-Class");
        mainfest.remove("Main-Class");
        newManifest.addConfiguredAttribute(new Manifest.Attribute("Start-Class", mainClass));
        newManifest.addConfiguredAttribute(new Manifest.Attribute("Main-Class", JarLauncher.class.getName()));
        newManifest.addConfiguredAttribute(new Manifest.Attribute("Spring-Boot-Classes", classes));
        newManifest.addConfiguredAttribute(new Manifest.Attribute("Spring-Boot-Lib", lib));
        newManifest.addConfiguredAttribute(new Manifest.Attribute("Spring-Boot-Version", "1.5.9.RELEASE"));
        for (Map.Entry entry : mainfest.entrySet()) {
            newManifest.addConfiguredAttribute(new Manifest.Attribute((String)entry.getKey(), (String)entry.getValue()));
        }
        archiver.addConfiguredManifest(newManifest);
        archiver.setCompress(false);
        return archiver;
    }

    private static String[] concat(String[] orgs, String v) {
        if (orgs == null) {
            String[] arr = new String[]{v};
            return arr;
        }
        String[] arr = new String[orgs.length + 1];
        System.arraycopy(orgs, 0, arr, 0, orgs.length);
        arr[arr.length - 1] = v;
        return arr;
    }

    private static void initSpringBootLoader(File boottmp, JarArchiver archiver) throws IOException {
        URL url = Launcher.class.getProtectionDomain().getCodeSource().getLocation();
        File jar = new File(URLDecoder.decode(url.getFile(), Charset.defaultCharset().name()));
        JarFile jfile = new JarFile(jar);
        Enumeration<JarEntry> e = jfile.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            if (name.startsWith("META-INF/") || name.endsWith("/")) continue;
            File f = new File(boottmp, name);
            FileUtil.sureDir(f);
            FileUtil.copyFile(jfile.getInputStream(entry), f.getAbsolutePath());
            archiver.addFile(f, name);
        }
        jfile.close();
    }
}

