/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.buildplugin.util;

import cn.weforward.buildplugin.UploadProgressBar;
import cn.weforward.buildplugin.util.StringUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import org.apache.commons.codec.binary.Base64;

public class UploadFileHandler
extends ChannelInboundHandlerAdapter
implements Runnable {
    protected ChannelHandlerContext m_Ctx;
    private URI m_Uri;
    private File m_File;
    private String m_Username;
    private String m_Password;
    protected Thread m_Thread;
    protected UploadProgressBar m_ProgressBar;

    public UploadFileHandler(URI uri, File file, UploadProgressBar progressBar, String username, String password) {
        this.m_Uri = uri;
        this.m_File = file;
        this.m_ProgressBar = progressBar;
        this.m_Username = username;
        this.m_Password = password;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.m_Ctx = ctx;
        this.startUpload();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.stopUpload();
    }

    private synchronized void startUpload() {
        if (this.m_Thread == null) {
            Thread t = new Thread((Runnable)this, "uploadfile-" + this.m_File.getName());
            t.start();
            this.m_Thread = t;
        }
    }

    private synchronized void stopUpload() {
        if (this.m_Thread != null) {
            this.m_Thread.interrupt();
            this.m_Thread = null;
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)msg;
            HttpResponseStatus status = response.status();
            int code = status.code();
            String message = "";
            message = response instanceof FullHttpResponse ? ((FullHttpResponse)response).content().toString(CharsetUtil.UTF_8) : status.reasonPhrase();
            this.m_ProgressBar.response(code, message);
        }
        if (msg instanceof LastHttpContent) {
            ctx.close();
        }
    }

    @Override
    public void run() {
        block16: {
            File file = this.m_File;
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream fStream = new FileInputStream(file);){
                    String filename = file.getName();
                    DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.GET, String.valueOf(this.m_Uri.getPath()) + filename);
                    request.setMethod(HttpMethod.POST);
                    String end = "\r\n";
                    String twoHyphens = "--";
                    String boundary = "Weforward_Boundary______" + System.currentTimeMillis();
                    StringBuilder startsb = new StringBuilder();
                    startsb.append(String.valueOf(twoHyphens) + boundary + end);
                    startsb.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + filename + "\"" + end);
                    startsb.append(end);
                    byte[] startbs = startsb.toString().getBytes();
                    StringBuilder endsb = new StringBuilder();
                    endsb.append(end);
                    endsb.append(String.valueOf(twoHyphens) + boundary + twoHyphens + end);
                    byte[] endbs = endsb.toString().getBytes();
                    request.headers().add("Charset", (Object)"UTF-8");
                    request.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)this.m_Uri.getHost());
                    request.headers().add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)("multipart/form-data;boundary=" + boundary));
                    request.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
                    if (!StringUtil.isEmpty(this.m_Username) && !StringUtil.isEmpty(this.m_Password)) {
                        String basic = "Basic " + new String(Base64.encodeBase64URLSafe((byte[])(String.valueOf(this.m_Username) + ":" + this.m_Password).getBytes()));
                        request.headers().add("Authorization", (Object)basic);
                    }
                    long l = (long)startbs.length + file.length() + (long)endbs.length;
                    request.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)l);
                    this.m_Ctx.writeAndFlush((Object)request);
                    ChannelFuture future = this.m_Ctx.writeAndFlush((Object)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])startbs)));
                    future.await();
                    int bufferSize = 0x100000;
                    byte[] buffer = new byte[bufferSize];
                    int length = -1;
                    if (this.m_ProgressBar != null) {
                        this.m_ProgressBar.start();
                    }
                    long count = 0L;
                    long sum = file.length();
                    while ((length = fStream.read(buffer)) != -1) {
                        count += (long)length;
                        if (this.m_ProgressBar != null) {
                            this.m_ProgressBar.progress(count, sum);
                        }
                        future = this.m_Ctx.writeAndFlush((Object)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])buffer, (int)0, (int)length))).sync();
                        future.await();
                    }
                    future = this.m_Ctx.writeAndFlush((Object)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])endbs)));
                    future.await();
                    if (this.m_ProgressBar != null) {
                        this.m_ProgressBar.end();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                if (this.m_ProgressBar == null) break block16;
                this.m_ProgressBar.exception(e);
            }
        }
    }
}

