/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.buildplugin.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class VersionUtil {
    public static final String VERSION_SPLITE = ".";
    private static final String VERSION_NODE = "version";
    private static final String PARENT_NODE = "parent";
    private static final DocumentBuilderFactory BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory TRANS_Factory = TransformerFactory.newInstance();

    private VersionUtil() {
    }

    public static String getIncVersion(MavenProject project, String mainVersion) throws MojoFailureException {
        int num = VersionUtil.getIncVersionNum(project.getVersion(), mainVersion);
        String newVersion = String.valueOf(num);
        return newVersion;
    }

    public static int getIncVersionNum(String projectVersion, String mainVersion) {
        int num;
        block3: {
            if (projectVersion.startsWith(mainVersion)) break block3;
            return 0;
        }
        try {
            String[] projectVersionArr = projectVersion.split("\\.");
            String[] mainVersionArr = mainVersion.split("\\.");
            num = projectVersionArr.length > mainVersionArr.length ? Integer.parseInt(projectVersionArr[mainVersionArr.length]) : 0;
        }
        catch (NumberFormatException e) {
            num = 0;
        }
        return num;
    }

    public static String genIncVersion(MavenProject project, String mainVersion) throws MojoFailureException {
        int num = VersionUtil.getIncVersionNum(project.getVersion(), mainVersion);
        String newVersion = String.valueOf(++num);
        return newVersion;
    }

    public static void setVersion(MavenProject project, String version) throws MojoFailureException {
        Transformer transFormer;
        Document doc;
        project.setVersion(version);
        Artifact a = project.getArtifact();
        if (a != null) {
            a.setVersion(version);
            a.setVersionRange(VersionRange.createFromVersion((String)version));
        }
        boolean change = false;
        File file = project.getFile();
        try {
            Node childnode;
            int j;
            NodeList childNodeList;
            Node node;
            doc = BUILDER_FACTORY.newDocumentBuilder().parse(file);
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            String prop = null;
            int i = 0;
            while (i < nodeList.getLength()) {
                node = nodeList.item(i);
                if (VERSION_NODE.equals(node.getNodeName())) {
                    String content = node.getTextContent();
                    if (content != null && content.startsWith("${") && content.endsWith("}")) {
                        prop = content.substring(2, content.length() - 1);
                        break;
                    }
                    node.setTextContent(version);
                    change = true;
                    break;
                }
                ++i;
            }
            if (!change) {
                i = 0;
                while (i < nodeList.getLength()) {
                    node = nodeList.item(i);
                    if (PARENT_NODE.equals(node.getNodeName())) {
                        childNodeList = node.getChildNodes();
                        j = 0;
                        while (j < childNodeList.getLength()) {
                            childnode = childNodeList.item(j);
                            if (VERSION_NODE.equals(childnode.getNodeName())) {
                                String content = childnode.getTextContent();
                                if (content != null && content.startsWith("${") && content.endsWith("}")) {
                                    prop = content.substring(2, content.length() - 1);
                                    break;
                                }
                                childnode.setTextContent(version);
                                change = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            if (prop != null) {
                project.getProperties().setProperty(prop, version);
                i = 0;
                while (i < nodeList.getLength()) {
                    node = nodeList.item(i);
                    if ("properties".equals(node.getNodeName())) {
                        childNodeList = node.getChildNodes();
                        j = 0;
                        while (j < childNodeList.getLength()) {
                            childnode = childNodeList.item(j);
                            if (prop.equals(childnode.getNodeName())) {
                                childnode.setTextContent(version);
                                change = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (ParserConfigurationException e) {
            throw new MojoFailureException("\u89e3\u6790\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
        catch (SAXException e) {
            throw new MojoFailureException("\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        catch (IOException e) {
            throw new MojoFailureException("\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        if (!change) {
            return;
        }
        DOMSource domSource = new DOMSource(doc);
        try {
            transFormer = TRANS_Factory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new MojoFailureException("\u8f6c\u6362\u914d\u7f6e\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        try {
            Throwable e = null;
            Object var9_17 = null;
            try (FileOutputStream out = new FileOutputStream(file);){
                transFormer.transform(domSource, new StreamResult(out));
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (TransformerException e) {
            throw new MojoFailureException("\u8f6c\u6362\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new MojoFailureException("IO\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
    }

    public static void setParentVersion(File file, String version) throws MojoFailureException {
        Transformer transFormer;
        Document doc;
        try {
            doc = BUILDER_FACTORY.newDocumentBuilder().parse(file);
            NodeList nodeList = doc.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (PARENT_NODE.contentEquals(node.getNodeName())) {
                    NodeList childList = node.getChildNodes();
                    int j = 0;
                    while (j < childList.getLength()) {
                        Node child = childList.item(j);
                        if (VERSION_NODE.equals(child.getNodeName())) {
                            child.setTextContent(version);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            throw new MojoFailureException("\u89e3\u6790\u914d\u7f6e\u5f02\u5e38", (Throwable)e);
        }
        catch (SAXException e) {
            throw new MojoFailureException("\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        catch (IOException e) {
            throw new MojoFailureException("\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        DOMSource domSource = new DOMSource(doc);
        try {
            transFormer = TRANS_Factory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new MojoFailureException("\u8f6c\u6362\u914d\u7f6e\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        try {
            Throwable e = null;
            Object var6_14 = null;
            try (FileOutputStream out = new FileOutputStream(file);){
                transFormer.transform(domSource, new StreamResult(out));
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (TransformerException e) {
            throw new MojoFailureException("\u8f6c\u6362\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new MojoFailureException("IO\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
    }
}

