/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.metrics;

import cn.weforward.common.KvPair;
import cn.weforward.common.crypto.Base64;
import cn.weforward.common.json.JsonOutputStream;
import cn.weforward.common.util.StringUtil;
import cn.weforward.metrics.RemoteRegisterConfig;
import cn.weforward.metrics.ext.AbstarctMeterRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RemoteMeterRegistry
extends AbstarctMeterRegistry {
    protected List<URL> m_Urls;
    protected String m_UserName;
    protected String m_Password;
    protected int m_ConnectTimeout = 3000;
    protected int m_ReadTimeout = 6000;

    public RemoteMeterRegistry(String url) throws MalformedURLException {
        this(Collections.singletonList(url), false);
    }

    public RemoteMeterRegistry(String url, boolean global) throws MalformedURLException {
        this(Collections.singletonList(url), global);
    }

    public RemoteMeterRegistry(List<String> urls, boolean global) throws MalformedURLException {
        super(RemoteRegisterConfig.DEFAULT, Clock.SYSTEM, global);
        if (urls == null || urls.size() == 0) {
            this.m_Urls = Collections.emptyList();
            return;
        }
        ArrayList<URL> ls = new ArrayList<URL>(urls.size());
        for (String url : urls) {
            if (StringUtil.isEmpty((String)url)) continue;
            ls.add(new URL(url));
        }
        this.m_Urls = ls;
    }

    public List<URL> getUrls() {
        return this.m_Urls;
    }

    public void setUserName(String username) {
        this.m_UserName = username;
    }

    public void setPassword(String password) {
        this.m_Password = password;
    }

    public void setConnectTimeoutSecond(int second) {
        this.m_ConnectTimeout = second * 1000;
    }

    public void setReadTimeoutSecond(int second) {
        this.m_ReadTimeout = second * 1000;
    }

    @Override
    protected void publish(Meter.Id id, List<KvPair<String, Double>> measure) throws IOException {
        for (URL url : this.m_Urls) {
            this.send(url, id, measure);
        }
    }

    private void send(URL url, Meter.Id id, List<KvPair<String, Double>> list) throws IOException {
        HttpURLConnection http = null;
        http = (HttpURLConnection)url.openConnection();
        http.setConnectTimeout(this.m_ConnectTimeout);
        http.setReadTimeout(this.m_ReadTimeout);
        http.setDoInput(true);
        http.setDoOutput(true);
        http.setUseCaches(false);
        http.setRequestMethod("POST");
        if (!StringUtil.isEmpty((String)this.m_UserName) && !StringUtil.isEmpty((String)this.m_Password)) {
            String basic = "Basic " + new String(Base64.encode((byte[])(String.valueOf(this.m_UserName) + ":" + this.m_Password).getBytes()));
            http.setRequestProperty("Authorization", basic);
        }
        OutputStream out = http.getOutputStream();
        JsonOutputStream sb = new JsonOutputStream(out);
        this.out((Appendable)sb, id, list);
        out.flush();
        sb.close();
        int status = http.getResponseCode();
        if (200 != status) {
            throw new UnknownServiceException(url + " \u670d\u52a1\u5f02\u5e38\uff1a" + status + " " + StringUtil.toString((Object)http.getResponseMessage()));
        }
        http.getInputStream().close();
    }
}

