/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.metrics;

import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;

public interface WeforwardMetrics {
    public static final String LABEL_SERVICE_ID = "serviceId";
    public static final String LABEL_SERVICE_NO = "serviceNo";
    public static final String LABEL_SERVICE_NAME = "serviceName";
    public static final String LABEL_SERVICE_VERSION = "serviceVersion";
    public static final String LABEL_METHOD_NAME = "method";
    public static final String LABEL_STATUS_CODE = "code";
    public static final String LABEL_TRACE_ID = "traceId";
    public static final String LABEL_TRACE_SPAN_ID = "traceSpanId";
    public static final String LABEL_TRACE_PARENT_ID = "traceParentId";
    public static final String LABEL_GATEWAY_ID = "gatewayId";
    public static final String LABEL_START_TIME_MS = "startTimeMillisecond";
    public static final String LABEL_END_TIME_MS = "endTimeMillisecond";
    public static final String RPC_REQUEST_KEY = "weforward.service.rpc.requests";
    public static final String RPC_CURRENT_REQUEST_KEY = "weforward.service.rpc.current.request";
    public static final String STREAM_REQUEST_KEY = "weforward.service.stream.requests";
    public static final String STREAM_CURRENT_REQUEST_KEY = "weforward.service.stream.current.request";
    public static final String TRACE_START_TIME = "weforward.service.trace.start";
    public static final String TRACE_END_TIME = "weforward.service.trace.end";
    public static final String TRACE_KEY = "weforward.service.trace";
    public static final String MEMORY_MAX = "weforward.service.memorymax";
    public static final String MEMORY_ALLOC = "weforward.service.memoryalloc";
    public static final String MEMORY_USED = "weforward.service.memoryused";
    public static final String GC_FULL_COUNT = "weforward.service.gcfullcount";
    public static final String GC_FULL_TIME = "weforward.service.gcfulltime";
    public static final String THREAD_COUNT = "weforward.service.threadcount";
    public static final String CPU_USAGE_RATE = "weforward.service.cpuusagerate";
    public static final String START_TIME = "weforward.service.starttime";
    public static final String UP_TIME = "weforward.service.uptime";
    public static final String GATEWAY_MEMORY_MAX = "weforward.gateway.memorymax";
    public static final String GATEWAY_MEMORY_USED = "weforward.gateway.memoryused";
    public static final String GATEWAY_MEMORY_ALLOC = "weforward.gateway.memoryalloc";
    public static final String GATEWAY_GC_FULL_COUNT = "weforward.gateway.gcfullcount";
    public static final String GATEWAY_GC_FULL_TIME = "weforward.gateway.gcfulltime";
    public static final String GATEWAY_THREAD_COUNT = "weforward.gateway.threadcount";
    public static final String GATEWAY_CPU_USAGE_RATE = "weforward.gateway.cpuusagerate";
    public static final String GATEWAY_START_TIME = "weforward.gateway.starttime";
    public static final String GATEWAY_UP_TIME = "weforward.gateway.uptime";
    public static final String GATEWAY_RPC_COUNT = "weforward.gateway.rpccount";
    public static final String GATEWAY_RPC_CONCURRENT = "weforward.gateway.rpcconcurrent";
    public static final String GATEWAY_STREAM_COUNT = "weforward.gateway.streamcount";
    public static final String GATEWAY_STREAM_CONCURRENT = "weforward.gateway.streamconcurrent";
    public static final String GATEWAY_TRACE_KEY = "weforward.gateway.trace";
    public static final String GATEWAY_SERVICE_RPC_COUNT = "weforward.gateway.service.rpc.count";
    public static final String GATEWAY_SERVICE_RPC_CONCURRENT = "weforward.gateway.service.rpc.concurrent";
    public static final String GATEWAY_SERVICE_RPC_FAIL = "weforward.gateway.service.rpc.fail";
    public static final Tag ONE_METRICS_TAG = new Tag(){

        public String getValue() {
            return "";
        }

        public String getKey() {
            return "";
        }
    };
    public static final TagHelper TAG = new TagHelper();

    public static class TagHelper {
        public static final Tag serviceId(String id) {
            if (id == null) {
                return null;
            }
            return new ImmutableTag(WeforwardMetrics.LABEL_SERVICE_ID, id);
        }

        public static final Tag serviceNo(String no) {
            if (no == null) {
                return null;
            }
            return new ImmutableTag(WeforwardMetrics.LABEL_SERVICE_NO, no);
        }

        public static final Tag serviceName(String name) {
            if (name == null) {
                return null;
            }
            return new ImmutableTag(WeforwardMetrics.LABEL_SERVICE_NAME, name);
        }

        public static final Tag method(String name) {
            if (name == null) {
                return null;
            }
            return new ImmutableTag(WeforwardMetrics.LABEL_METHOD_NAME, name);
        }

        public static final Tag code(int code) {
            return new ImmutableTag(WeforwardMetrics.LABEL_STATUS_CODE, String.valueOf(code));
        }

        public static final Tag code(String code) {
            if (code == null) {
                return null;
            }
            return new ImmutableTag(WeforwardMetrics.LABEL_STATUS_CODE, code);
        }

        public static final Tag traceId(String traceId) {
            if (traceId == null) {
                return null;
            }
            return new ImmutableTag(WeforwardMetrics.LABEL_TRACE_ID, traceId);
        }

        public static final Tag traceSpanId(String spanId) {
            if (spanId == null) {
                return null;
            }
            return new ImmutableTag(WeforwardMetrics.LABEL_TRACE_SPAN_ID, spanId);
        }

        public static final Tag traceParentId(String parentId) {
            if (parentId == null) {
                return null;
            }
            return new ImmutableTag(WeforwardMetrics.LABEL_TRACE_PARENT_ID, parentId);
        }

        public static final Tag gatewayId(String id) {
            if (id == null) {
                return null;
            }
            return new ImmutableTag(WeforwardMetrics.LABEL_GATEWAY_ID, id);
        }

        public static final Tag startTimeMs(long v) {
            return TagHelper.startTimeMs(String.valueOf(v));
        }

        public static final Tag startTimeMs(String id) {
            if (id == null) {
                return null;
            }
            return new ImmutableTag(WeforwardMetrics.LABEL_START_TIME_MS, id);
        }

        public static final Tag endTimeMs(long v) {
            return TagHelper.endTimeMs(String.valueOf(v));
        }

        public static final Tag endTimeMs(String id) {
            if (id == null) {
                return null;
            }
            return new ImmutableTag(WeforwardMetrics.LABEL_END_TIME_MS, id);
        }

        public static final Tags of(Tag ... tags) {
            if (tags == null || tags.length == 0) {
                return Tags.empty();
            }
            int idx = -1;
            int i = 0;
            while (i < tags.length) {
                if (tags[i] == null) {
                    idx = i;
                    break;
                }
                ++i;
            }
            if (-1 == idx) {
                return Tags.of((Tag[])tags);
            }
            ArrayList<Tag> list = new ArrayList<Tag>(tags.length);
            Tag[] tagArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                Tag tag = tagArray[n2];
                if (tag != null) {
                    list.add(tag);
                }
                ++n2;
            }
            return Tags.of(list);
        }
    }
}

