/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.metrics.ext;

import cn.weforward.common.KvPair;
import cn.weforward.common.json.JsonUtil;
import cn.weforward.common.util.SimpleKvPair;
import cn.weforward.common.util.StringUtil;
import cn.weforward.metrics.RemoteMeterRegistry;
import cn.weforward.metrics.WeforwardMetrics;
import cn.weforward.metrics.ext.InnerMetricsRegistry;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.step.StepMeterRegistry;
import io.micrometer.core.instrument.step.StepRegistryConfig;
import io.micrometer.core.instrument.util.NamedThreadFactory;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstarctMeterRegistry
extends StepMeterRegistry {
    protected static final Logger _Logger = LoggerFactory.getLogger(RemoteMeterRegistry.class);
    protected static final NamedThreadFactory FACTORY = new NamedThreadFactory("metrics-publisher");
    protected boolean m_AddGlobal = false;
    protected boolean m_AlreadAddGlobal = false;
    static NumberFormat NF;
    protected List<String> m_OneMetrics;

    static {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        NF = nf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String format(double number) {
        NumberFormat numberFormat = NF;
        synchronized (numberFormat) {
            return NF.format(number);
        }
    }

    public AbstarctMeterRegistry(StepRegistryConfig config, Clock clock, boolean global) {
        super(config, clock);
        this.m_AddGlobal = global;
        this.m_AlreadAddGlobal = false;
        this.start((ThreadFactory)FACTORY);
    }

    public void setEnableJvmMetrics(boolean enable) {
        if (enable) {
            InnerMetricsRegistry.JVM.bindTo((MeterRegistry)this);
        }
    }

    public void setEnableProcessorMetrics(boolean enable) {
        if (enable) {
            InnerMetricsRegistry.PROCESSOR.bindTo((MeterRegistry)this);
        }
    }

    public void setEnableUpTimeMetrics(boolean enable) {
        if (enable) {
            InnerMetricsRegistry.UPTIME.bindTo((MeterRegistry)this);
        }
    }

    public void setServiceId(String id) {
        this.config().commonTags(new String[]{"serviceId", id});
        if (this.m_AddGlobal) {
            Metrics.globalRegistry.config().commonTags(new String[]{"serviceId", id});
        }
    }

    public void setServiceNo(String no) {
        this.config().commonTags(new String[]{"serviceNo", no});
        if (this.m_AddGlobal) {
            Metrics.globalRegistry.config().commonTags(new String[]{"serviceNo", no});
        }
    }

    public void setServiceName(String name) {
        this.config().commonTags(new String[]{"serviceName", name});
        if (this.m_AddGlobal) {
            Metrics.globalRegistry.config().commonTags(new String[]{"serviceName", name});
        }
    }

    public void setOneMetrics(List<String> metrics) {
        this.m_OneMetrics = metrics;
    }

    protected void publish() {
        if (this.m_AddGlobal && !this.m_AlreadAddGlobal) {
            Metrics.addRegistry((MeterRegistry)this);
            this.m_AlreadAddGlobal = true;
        }
        ArrayList clears = new ArrayList();
        this.forEachMeter(m -> {
            Meter.Id id = m.getId();
            Iterator it = m.measure().iterator();
            ArrayList<KvPair<String, Double>> list2 = new ArrayList<KvPair<String, Double>>();
            while (it.hasNext()) {
                Measurement e = (Measurement)it.next();
                if (Double.isNaN(e.getValue())) continue;
                list2.add((KvPair<String, Double>)SimpleKvPair.valueOf((Object)e.getStatistic().name(), (Object)e.getValue()));
            }
            if (list2.isEmpty()) {
                clears.add(id);
            } else {
                block6: {
                    try {
                        this.publish(id, list2);
                    }
                    catch (Exception e) {
                        if (!_Logger.isDebugEnabled()) break block6;
                        _Logger.debug("\u5ffd\u7565\u63a8\u9001\u5f02\u5e38", (Throwable)e);
                    }
                }
                if (this.isOne(id)) {
                    clears.add(id);
                }
            }
        });
        for (Meter.Id id : clears) {
            this.remove(id);
            if (!this.m_AddGlobal) continue;
            Metrics.globalRegistry.remove(id);
        }
    }

    protected boolean isOne(Meter.Id id) {
        String name;
        List tags = id.getTags();
        if (!tags.isEmpty()) {
            for (Tag t : tags) {
                if (WeforwardMetrics.ONE_METRICS_TAG != t) continue;
                return true;
            }
        }
        if (StringUtil.eq((String)"weforward.service.trace.start", (String)(name = id.getName())) || StringUtil.eq((String)"weforward.service.trace.end", (String)name) || StringUtil.eq((String)"weforward.service.trace", (String)name) || StringUtil.eq((String)"weforward.gateway.trace", (String)name)) {
            return true;
        }
        List<String> ones = this.m_OneMetrics;
        return ones != null && ones.contains(name);
    }

    protected abstract void publish(Meter.Id var1, List<KvPair<String, Double>> var2) throws IOException;

    protected void out(Appendable sb, Meter.Id id, List<KvPair<String, Double>> list) throws IOException {
        int i;
        sb.append('{');
        sb.append("\"id\":{");
        sb.append("\"name\":\"");
        JsonUtil.escape((CharSequence)id.getName(), (Appendable)sb);
        sb.append("\",");
        sb.append("\"description\":\"");
        JsonUtil.escape((CharSequence)id.getDescription(), (Appendable)sb);
        sb.append("\",");
        sb.append("\"baseUnit\":\"");
        JsonUtil.escape((CharSequence)id.getBaseUnit(), (Appendable)sb);
        sb.append("\",");
        sb.append("\"type\":\"");
        JsonUtil.escape((CharSequence)id.getType().name(), (Appendable)sb);
        sb.append("\"");
        sb.append("},");
        sb.append("\"tags\":{");
        List tags = id.getTags();
        if (!tags.isEmpty()) {
            boolean first = true;
            i = 0;
            while (i < tags.size()) {
                Tag tag = (Tag)tags.get(i);
                if (WeforwardMetrics.ONE_METRICS_TAG != tag) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append("\"");
                    JsonUtil.escape((CharSequence)tag.getKey(), (Appendable)sb);
                    sb.append("\":\"");
                    JsonUtil.escape((CharSequence)tag.getValue(), (Appendable)sb);
                    sb.append("\"");
                }
                ++i;
            }
        }
        sb.append("},");
        sb.append("\"measure\":{");
        KvPair<String, Double> m = list.get(0);
        sb.append("\"");
        JsonUtil.escape((CharSequence)((CharSequence)m.getKey()), (Appendable)sb);
        sb.append("\":");
        sb.append(AbstarctMeterRegistry.format((Double)m.getValue()));
        i = 1;
        while (i < list.size()) {
            m = list.get(i);
            sb.append(",\"");
            JsonUtil.escape((CharSequence)((CharSequence)m.getKey()), (Appendable)sb);
            sb.append("\":");
            sb.append(AbstarctMeterRegistry.format((Double)m.getValue()));
            ++i;
        }
        sb.append("}");
        sb.append('}');
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }
}

