/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.trace.ext;

import cn.weforward.common.json.JsonUtil;
import cn.weforward.common.util.RingBuffer;
import cn.weforward.common.util.StringUtil;
import cn.weforward.trace.Trace;
import cn.weforward.trace.TraceRegistry;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Tag;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTraceRegistry
implements TraceRegistry,
Runnable {
    protected static final Logger _Logger = LoggerFactory.getLogger(AbstractTraceRegistry.class);
    protected RingBuffer<Trace> m_Items;
    final Object m_Lock = new Object();
    protected long m_Interval = 1000L;
    protected long m_MaxSupport = 100L;
    protected List<URL> m_Urls;
    protected List<Tag> m_Tags = new ArrayList<Tag>();
    protected Thread m_Thread;

    public AbstractTraceRegistry() {
        this.start();
    }

    public void setServiceId(String id) {
        this.setCommonTags("serviceId", id);
    }

    public void setServiceNo(String no) {
        this.setCommonTags("serviceNo", no);
    }

    public void setServiceName(String name) {
        this.setCommonTags("serviceName", name);
    }

    public void setCommonTags(String key, String value) {
        this.m_Tags.add((Tag)new ImmutableTag(key, value));
    }

    public List<Tag> getCommonTags() {
        return this.m_Tags;
    }

    public void setInterval(int interval) {
        this.m_Interval = interval;
    }

    public void setMaxSupport(int max) {
        this.m_MaxSupport = max;
    }

    public void start() {
        this.m_Items = new RingBuffer(1024);
        Thread thread = new Thread((Runnable)this, "trace-publisher");
        thread.setDaemon(true);
        this.m_Thread = thread;
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.m_Lock;
        synchronized (object) {
            this.m_Thread = null;
            this.m_Lock.notify();
        }
    }

    @Override
    public void register(Trace trace) {
        if (this.m_Thread == null) {
            return;
        }
        this.m_Items.offer((Object)trace);
    }

    @Override
    public void close() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.m_Thread != null) {
            Object object;
            try {
                do {
                    this.send();
                    object = this.m_Lock;
                    synchronized (object) {
                        try {
                            this.m_Lock.wait(this.m_Interval);
                        }
                        catch (InterruptedException e2) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                        if (this.m_Thread == null) {
                            return;
                        }
                    }
                } while (this.m_Thread != null);
            }
            catch (Throwable e) {
                try {
                    this.addError("\u8fd0\u884c\u51fa\u9519", e);
                }
                catch (Throwable e2) {
                    // empty catch block
                }
            }
            object = this;
            synchronized (object) {
                try {
                    this.wait(10000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }

    protected void send() {
        try {
            Trace vo;
            while ((vo = (Trace)this.m_Items.remove()) != null) {
                this.send(vo);
            }
        }
        catch (Exception e) {
            this.addError("Error occurred while sending Remote.", e);
        }
    }

    protected abstract void send(Trace var1) throws Exception;

    protected void addError(String msg, Throwable e) {
        if (_Logger.isDebugEnabled()) {
            _Logger.debug(msg, e);
        }
    }

    protected void out(Appendable sb, Trace vo) throws IOException {
        sb.append('{');
        sb.append("\"id\":\"");
        JsonUtil.escape((CharSequence)vo.getId(), (Appendable)sb);
        sb.append("\",");
        sb.append("\"parentId\":\"");
        JsonUtil.escape((CharSequence)vo.getParentId(), (Appendable)sb);
        sb.append("\",");
        sb.append("\"traceId\":\"");
        JsonUtil.escape((CharSequence)vo.getTraceId(), (Appendable)sb);
        sb.append("\",");
        sb.append("\"timestamp\":");
        sb.append(String.valueOf(vo.getTimestamp()));
        sb.append(",");
        sb.append("\"duration\":");
        sb.append(String.valueOf(vo.getDuration()));
        sb.append(",");
        sb.append("\"kind\":\"");
        JsonUtil.escape((CharSequence)vo.getKind(), (Appendable)sb);
        sb.append("\",");
        sb.append("\"tags\":{");
        Iterable<Tag> tags = vo.getTags();
        if (tags != null) {
            boolean first = true;
            for (Tag tag : tags) {
                if (tag == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append("\"");
                JsonUtil.escape((CharSequence)tag.getKey(), (Appendable)sb);
                sb.append("\":\"");
                JsonUtil.escape((CharSequence)tag.getValue(), (Appendable)sb);
                sb.append("\"");
            }
            List<Tag> commons = this.getCommonTags();
            int i = 0;
            while (i < commons.size()) {
                Tag tag = commons.get(i);
                if (tag != null && !AbstractTraceRegistry.exists(tags, tag)) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append("\"");
                    JsonUtil.escape((CharSequence)tag.getKey(), (Appendable)sb);
                    sb.append("\":\"");
                    JsonUtil.escape((CharSequence)tag.getValue(), (Appendable)sb);
                    sb.append("\"");
                }
                ++i;
            }
        }
        sb.append("}");
        sb.append("}");
    }

    protected static boolean exists(Iterable<Tag> tags, Tag tag) {
        for (Tag t : tags) {
            if (t == null || !StringUtil.eq((String)t.getKey(), (String)tag.getKey())) continue;
            return true;
        }
        return false;
    }
}

