/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol;

import cn.weforward.common.util.StringUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;

public interface Access {
    public static final char SPEARATOR = '-';
    public static final String SPEARATOR_STR = "-";
    public static final String KIND_SERVICE = "H";
    public static final String KIND_USER = "US";
    public static final String KIND_GATEWAY = "GW";
    public static final List<String> KIND_ALL = Arrays.asList("H", "US", "GW");

    public String getAccessId();

    public byte[] getAccessKey();

    public String getAccessKeyHex();

    public String getAccessKeyBase64();

    public String getKind();

    public String getTenant();

    public String getOpenid();

    public boolean isValid();

    public static final class Helper {
        public static String getKind(String accessId) {
            if (accessId == null || accessId.length() == 0) {
                return null;
            }
            int idx = accessId.indexOf(45);
            if (-1 == idx || idx == 0) {
                return null;
            }
            return accessId.substring(0, idx);
        }

        public static byte[] secretToAccessKey(String secret) throws NoSuchAlgorithmException {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            if (!StringUtil.isEmpty((String)secret)) {
                md.update(secret.getBytes());
            }
            return md.digest();
        }
    }
}

