/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol;

import cn.weforward.common.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class Header
implements Cloneable {
    public static final String WEFORWARD_PREFIX = "WF";
    public static final String AUTH_TYPE_NONE = "WF-None";
    public static final String AUTH_TYPE_SIGN = "WF-Sign";
    public static final String AUTH_TYPE_SHA2 = "WF-SHA2";
    public static final String AUTH_TYPE_AES = "WF-AES";
    public static final String GATEWAY_AUTH_TYPE_RELAY = "Relay";
    public static final String GATEWAY_AUTH_TYPE_MESH_RELAY = "Mesh-Relay";
    public static final String CONTENT_TYPE_JSON = "json";
    public static final String CHARSET_UTF8 = "utf-8";
    public static final String CHARSET_DEFAULT = "utf-8";
    public static final String CHANNEL_RPC = "rpc";
    public static final String CHANNEL_STREAM = "stream";
    public static final String CHANNEL_NOTIFY = "notify";
    public static final String CHANNEL_TOPIC = "topic";
    public static final List<String> CHANNEL_ALL = Arrays.asList("rpc", "stream", "notify", "topic");
    protected String m_Service;
    protected String m_ContentType;
    protected String m_Charset;
    protected String m_AccessId;
    protected String m_AuthType;
    protected String m_Noise;
    protected String m_Sign;
    protected String m_ContentSign;
    protected String m_Tag;
    protected String m_Channel;
    protected String m_UserAgent;
    protected String m_ServiceNo;
    @Deprecated
    protected String m_MeshAuth;
    protected String m_GatewayAuth;

    public Header(String serviceName) {
        this.m_Service = serviceName;
    }

    public static Header valueOf(String serviceName) {
        Header header = new Header(serviceName);
        header.setAuthType(AUTH_TYPE_NONE);
        header.setContentType(CONTENT_TYPE_JSON);
        header.setCharset("utf-8");
        header.setChannel(CHANNEL_RPC);
        return header;
    }

    public String getService() {
        return this.m_Service;
    }

    public void setService(String service) {
        this.m_Service = service;
    }

    public String getContentType() {
        return this.m_ContentType;
    }

    public void setContentType(String type) {
        this.m_ContentType = type;
    }

    public String getCharset() {
        return this.m_Charset;
    }

    public void setCharset(String charset) {
        this.m_Charset = charset;
    }

    public String getNoise() {
        return this.m_Noise;
    }

    public void setNoise(String noise) {
        this.m_Noise = noise;
    }

    public String getAuthType() {
        return this.m_AuthType;
    }

    public void setAuthType(String type) {
        this.m_AuthType = type;
    }

    public String getAccessId() {
        return this.m_AccessId;
    }

    public void setAccessId(String id) {
        this.m_AccessId = id;
    }

    public String getSign() {
        return this.m_Sign;
    }

    public void setSign(String sign) {
        this.m_Sign = sign;
    }

    public String getUserAgent() {
        return this.m_UserAgent;
    }

    public void setUserAgent(String agent) {
        this.m_UserAgent = agent;
    }

    public String getTag() {
        return this.m_Tag;
    }

    public void setTag(String tag) {
        this.m_Tag = tag;
    }

    public String getChannel() {
        return this.m_Channel;
    }

    public void setChannel(String channel) {
        this.m_Channel = channel;
    }

    public String getContentSign() {
        return this.m_ContentSign;
    }

    public void setContentSign(String contentSign) {
        this.m_ContentSign = contentSign;
    }

    public String getLogDetail() {
        return "{s:" + this.m_Service + ",acc:" + this.m_AccessId + ",at:" + this.m_AuthType + "}";
    }

    public String getServiceNo() {
        return this.m_ServiceNo;
    }

    public void setServiceNo(String serviceNo) {
        this.m_ServiceNo = serviceNo;
    }

    public String getMeshAuth() {
        return this.m_MeshAuth;
    }

    public void setMeshAuth(String meshAuth) {
        this.m_MeshAuth = meshAuth;
    }

    public String getGatewayAuth() {
        return this.m_GatewayAuth;
    }

    public void setGatewayAuth(String gatewayAuth) {
        this.m_GatewayAuth = gatewayAuth;
    }

    public String getGatewayAuthType() {
        if (StringUtil.isEmpty((String)this.m_GatewayAuth)) {
            return null;
        }
        int idx = this.m_GatewayAuth.indexOf(32);
        if (-1 == idx) {
            return null;
        }
        return this.m_GatewayAuth.substring(0, idx);
    }

    protected Header clone() throws CloneNotSupportedException {
        return (Header)super.clone();
    }

    public static Header copy(Header other) {
        try {
            return other.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static interface HeaderOutput {
        public void writeHeader(Header var1) throws IOException;
    }
}

