/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.http;

import cn.weforward.common.Dictionary;
import cn.weforward.common.DictionaryExt;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.Header;
import cn.weforward.protocol.aio.http.HttpClient;
import cn.weforward.protocol.aio.http.HttpContext;
import cn.weforward.protocol.aio.http.HttpHeaderOutput;
import java.io.IOException;
import java.util.HashMap;

public class HttpHeaderHelper {
    public static String getServiceName(String uri) {
        int idx = uri.indexOf("://");
        idx = -1 != idx ? uri.indexOf(47, idx + 3) : uri.indexOf(47);
        if (-1 != idx) {
            return uri.substring(idx + 1);
        }
        return uri;
    }

    public static DictionaryExt<String, String> toHttpHeaders(Header header) {
        HashMap<String, String> hs = new HashMap<String, String>();
        try {
            HttpHeaderHelper.outHeaders(header, new HttpHeaderOutput.MapOutput(hs));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new DictionaryExt.WrapMap(hs);
    }

    public static void responseHeaders(Header header, HttpContext ctx) throws IOException {
        HttpHeaderHelper.outHeaders(header, new HttpHeaderOutput.HttpContextOutput(ctx));
    }

    public static void requestHeaders(Header header, HttpClient client) throws IOException {
        HttpHeaderHelper.outHeaders(header, new HttpHeaderOutput.HttpClientOutput(client));
    }

    public static void outHeaders(Header header, HttpHeaderOutput out) throws IOException {
        String gatewayAuth;
        String serviceNo;
        String contentSign;
        String channel;
        String tag;
        String noise;
        String authType;
        String contentType = header.getContentType();
        if (!StringUtil.isEmpty((String)contentType)) {
            out.put("Content-Type", "application/" + contentType + ";charset=" + header.getCharset());
        }
        if (!StringUtil.isEmpty((String)(authType = header.getAuthType()))) {
            StringBuilder authHeader = StringBuilderPool._8k.poll();
            try {
                authHeader.append(authType);
                if (header.getAccessId() != null && header.getAccessId().length() > 0) {
                    authHeader.append(' ').append(header.getAccessId());
                    if (header.getSign() != null && header.getSign().length() > 0) {
                        authHeader.append(':').append(header.getSign());
                    }
                }
                out.put("Authorization", authHeader.toString());
            }
            finally {
                StringBuilderPool._8k.offer(authHeader);
            }
        }
        if (!StringUtil.isEmpty((String)(noise = header.getNoise()))) {
            out.put("WF-Noise", noise);
        }
        if (!StringUtil.isEmpty((String)(tag = header.getTag()))) {
            out.put("WF-Tag", tag);
        }
        if (!StringUtil.isEmpty((String)(channel = header.getChannel()))) {
            out.put("WF-Channel", channel);
        }
        if (!StringUtil.isEmpty((String)(contentSign = header.getContentSign()))) {
            out.put("WF-Content-Sign", contentSign);
        }
        if (!StringUtil.isEmpty((String)(serviceNo = header.getServiceNo()))) {
            out.put("WF-Service-No", serviceNo);
        }
        if (!StringUtil.isEmpty((String)(gatewayAuth = header.getGatewayAuth()))) {
            out.put("WF-GW-Auth", gatewayAuth);
        }
    }

    public static void fromHttpHeaders(Dictionary<String, String> hs, Header header) {
        String auth;
        int idx;
        String contentType = (String)hs.get((Object)"Content-Type");
        if (contentType != null && contentType.length() > 0) {
            if ((contentType = contentType.toLowerCase()).contains("json")) {
                header.setContentType("json");
            }
            if (-1 != (idx = contentType.indexOf("charset="))) {
                header.setCharset(contentType.substring(idx + 8));
            }
        }
        if ((auth = (String)hs.get((Object)"Authorization")) != null && auth.length() > 0) {
            idx = (auth = auth.trim()).indexOf(32);
            if (-1 == idx) {
                header.setAuthType(auth);
            } else {
                header.setAuthType(auth.substring(0, idx));
                int idx2 = auth.indexOf(58);
                if (-1 == idx2) {
                    header.setAccessId(auth.substring(idx + 1));
                } else {
                    header.setAccessId(auth.substring(idx + 1, idx2));
                    header.setSign(auth.substring(idx2 + 1));
                }
            }
        }
        String noise = (String)hs.get((Object)"WF-Noise");
        header.setNoise(noise);
        String tag = (String)hs.get((Object)"WF-Tag");
        header.setTag(tag);
        String channel = (String)hs.get((Object)"WF-Channel");
        header.setChannel(channel);
        String userAgent = (String)hs.get((Object)"User-Agent");
        header.setUserAgent(userAgent);
        String contentSign = (String)hs.get((Object)"WF-Content-Sign");
        header.setContentSign(contentSign);
        String serviceNo = (String)hs.get((Object)"WF-Service-No");
        header.setServiceNo(serviceNo);
        String gatewayAuth = (String)hs.get((Object)"WF-GW-Auth");
        header.setGatewayAuth(gatewayAuth);
    }
}

