/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.http;

import cn.weforward.protocol.aio.ClientContext;
import cn.weforward.protocol.aio.ServerContext;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Map;

public interface HttpHeaderOutput {
    public void put(String var1, String var2) throws IOException;

    public static class HttpClientOutput
    implements HttpHeaderOutput {
        ClientContext m_Client;

        public HttpClientOutput(ClientContext client) {
            this.m_Client = client;
        }

        @Override
        public void put(String name, String value) throws IOException {
            this.m_Client.setRequestHeader(name, value);
        }
    }

    public static class HttpContextOutput
    implements HttpHeaderOutput {
        ServerContext m_Ctx;

        public HttpContextOutput(ServerContext context) {
            this.m_Ctx = context;
        }

        @Override
        public void put(String name, String value) throws IOException {
            this.m_Ctx.setResponseHeader(name, value);
        }
    }

    public static class HttpURLConnectionOutput
    implements HttpHeaderOutput {
        HttpURLConnection m_Client;

        public HttpURLConnectionOutput(HttpURLConnection client) {
            this.m_Client = client;
        }

        @Override
        public void put(String name, String value) throws IOException {
            this.m_Client.setRequestProperty(name, value);
        }
    }

    public static class MapOutput
    implements HttpHeaderOutput {
        Map<String, String> m_Map;

        public MapOutput(Map<String, String> map) {
            this.m_Map = map;
        }

        @Override
        public void put(String name, String value) {
            this.m_Map.put(name, value);
        }
    }
}

