/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.http;

import cn.weforward.common.DictionaryExt;
import cn.weforward.common.GcCleanable;
import cn.weforward.common.crypto.Hex;
import cn.weforward.common.sys.GcCleaner;
import cn.weforward.common.util.RingBuffer;
import cn.weforward.common.util.StringBuilderPool;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class QueryStringParser {
    ByteBuffer m_ByteBuffer;
    CharBuffer m_CharBuffer;
    CharsetDecoder m_Decoder;
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static RingBuffer<QueryStringParser> _Pool = new RingBuffer<QueryStringParser>(512){

        protected QueryStringParser onEmpty() {
            return new QueryStringParser();
        }

        protected void onInit() {
            GcCleaner.register((GcCleanable)this);
        }
    };

    /*
     * Enabled aggressive block sorting
     */
    public Map<String, String> parse(CharSequence queryString, int offset, Charset charset, int paramsLimit) {
        int len = queryString.length();
        if (offset >= len) {
            return Collections.emptyMap();
        }
        if (this.m_Decoder == null || this.m_Decoder.charset() != charset) {
            this.m_Decoder = charset.newDecoder();
        }
        if (queryString.charAt(offset) == '?') {
            ++offset;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        int nameStart = offset;
        int valueStart = -1;
        int i = offset;
        block5: while (i < len) {
            switch (queryString.charAt(i)) {
                case '=': {
                    if (nameStart == i) {
                        nameStart = i + 1;
                        break;
                    }
                    if (valueStart >= nameStart) break;
                    valueStart = i + 1;
                    break;
                }
                case '&': {
                    if (this.addParam(queryString, nameStart, valueStart, i, params) && --paramsLimit == 0) {
                        return params;
                    }
                    nameStart = i + 1;
                    break;
                }
                case '#': {
                    break block5;
                }
            }
            ++i;
        }
        this.addParam(queryString, nameStart, valueStart, i, params);
        return params;
    }

    private boolean addParam(CharSequence queryString, int nameStart, int valueStart, int valueEnd, Map<String, String> params) {
        if (nameStart >= valueEnd) {
            return false;
        }
        if (valueStart <= nameStart) {
            valueStart = valueEnd + 1;
        }
        String name = this.decodeComponent(queryString, nameStart, valueStart - 1).toString();
        String value = this.decodeComponent(queryString, valueStart, valueEnd).toString();
        params.put(name, value);
        return true;
    }

    private void prepareBuffer(int capacity) {
        if (this.m_ByteBuffer != null && this.m_ByteBuffer.capacity() >= capacity) {
            this.m_ByteBuffer.clear();
        } else {
            this.m_ByteBuffer = ByteBuffer.allocate(capacity);
        }
        if (this.m_CharBuffer != null && this.m_CharBuffer.capacity() >= capacity) {
            this.m_CharBuffer.clear();
        } else {
            this.m_CharBuffer = CharBuffer.allocate(capacity);
        }
    }

    public CharSequence decodeComponent(CharSequence s, int from, int toExcluded) {
        int len = toExcluded - from;
        if (len <= 0) {
            return "";
        }
        int firstEscaped = -1;
        int i = from;
        while (i < toExcluded) {
            char c = s.charAt(i);
            if (c == '%' || c == '+') {
                firstEscaped = i;
                break;
            }
            ++i;
        }
        if (firstEscaped == -1) {
            return s.subSequence(from, toExcluded);
        }
        int decodedCapacity = (toExcluded - firstEscaped) / 3;
        this.prepareBuffer(decodedCapacity);
        StringBuilder strBuf = StringBuilderPool._8k.poll();
        try {
            strBuf.append(s, from, firstEscaped);
            int i2 = firstEscaped;
            while (i2 < toExcluded) {
                char c = s.charAt(i2);
                if (c != '%') {
                    strBuf.append(c != '+' ? c : (char)' ');
                } else {
                    this.m_ByteBuffer.clear();
                    do {
                        if (i2 + 3 > toExcluded) {
                            throw new IllegalArgumentException("unterminated escape sequence at index " + i2 + " of: " + s);
                        }
                        this.m_ByteBuffer.put(Hex.decodeByte((CharSequence)s, (int)(i2 + 1)));
                    } while ((i2 += 3) < toExcluded && s.charAt(i2) == '%');
                    --i2;
                    this.m_ByteBuffer.flip();
                    this.m_CharBuffer.clear();
                    CoderResult result = this.m_Decoder.reset().decode(this.m_ByteBuffer, this.m_CharBuffer, true);
                    try {
                        if (!result.isUnderflow()) {
                            result.throwException();
                        }
                        if (!(result = this.m_Decoder.flush(this.m_CharBuffer)).isUnderflow()) {
                            result.throwException();
                        }
                    }
                    catch (CharacterCodingException ex) {
                        throw new IllegalStateException(ex);
                    }
                    strBuf.append(this.m_CharBuffer.flip());
                }
                ++i2;
            }
            String string = strBuf.toString();
            return string;
        }
        finally {
            StringBuilderPool._8k.offer(strBuf);
        }
    }

    public static final DictionaryExt<String, String> toParams(CharSequence queryString) {
        return QueryStringParser.toParams(queryString, UTF_8);
    }

    public static final DictionaryExt<String, String> toParams(CharSequence queryString, Charset charset) {
        if (queryString == null || queryString.length() == 0) {
            return DictionaryExt._Empty;
        }
        QueryStringParser parser = (QueryStringParser)_Pool.poll();
        try {
            DictionaryExt.WrapMap wrapMap = new DictionaryExt.WrapMap(parser.parse(queryString, 0, charset, 50));
            return wrapMap;
        }
        finally {
            _Pool.offer((Object)parser);
        }
    }
}

