/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.http;

import cn.weforward.common.DictionaryExt;
import cn.weforward.common.restful.RestfulRequest;
import cn.weforward.common.restful.RestfulResponse;
import cn.weforward.common.restful.RestfulService;
import cn.weforward.common.util.IpRanges;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.aio.Headers;
import cn.weforward.protocol.aio.ServerContext;
import cn.weforward.protocol.aio.ServerHandler;
import cn.weforward.protocol.aio.ServerHandlerFactory;
import cn.weforward.protocol.aio.http.ResponseEndException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulServer
implements ServerHandlerFactory {
    public static final Logger _Logger = LoggerFactory.getLogger(RestfulServer.class);
    protected RestfulService m_Service;
    protected IpRanges m_AllowIps;
    protected IpRanges m_ProxyIps;
    protected Executor m_Executor;
    protected boolean m_QuickHandle;

    public RestfulServer(RestfulService service) {
        this.m_Service = service;
    }

    public void setExecutor(Executor executor) {
        this.m_Executor = executor;
    }

    public void setAllowIps(String ipList) {
        if (StringUtil.isEmpty((String)ipList)) {
            this.m_AllowIps = null;
            return;
        }
        IpRanges iprs = new IpRanges(ipList);
        this.setAllowIpRanges(iprs);
    }

    public void setAllowIpRanges(IpRanges iprs) {
        this.m_AllowIps = iprs;
    }

    public void setProxyIps(String ipList) {
        if (StringUtil.isEmpty((String)ipList)) {
            this.m_ProxyIps = null;
            return;
        }
        IpRanges iprs = new IpRanges(ipList);
        this.setProxyIpsRanges(iprs);
    }

    public void setProxyIpsRanges(IpRanges iprs) {
        this.m_ProxyIps = iprs;
    }

    public String toString() {
        return String.valueOf(this.m_Service);
    }

    @Override
    public ServerHandler handle(ServerContext context) throws IOException {
        if (this.isDeny(context)) {
            return null;
        }
        if (this.isQuickHandle() && this.m_Executor != null) {
            return new QuickHandler(context);
        }
        return new Handler(context);
    }

    public boolean isQuickHandle() {
        return this.m_QuickHandle;
    }

    public void setQuickHandle(boolean enabled) {
        this.m_QuickHandle = enabled;
    }

    protected boolean isDeny(ServerContext context) throws IOException {
        String ip;
        if (this.m_AllowIps != null && this.m_AllowIps.find(ip = this.getRealIp(context)) == null) {
            _Logger.warn("deny-ip: " + ip);
            context.response(403, ServerContext.RESPONSE_AND_CLOSE);
            return true;
        }
        return false;
    }

    public String getRealIp(ServerContext context) {
        String fip;
        Headers headers;
        String ip = context.getRemoteAddr();
        if (ip == null || ip.length() < 7) {
            return ip;
        }
        int idx = ip.lastIndexOf(58);
        if (idx > 0) {
            ip = ip.substring(0, idx);
        }
        if (this.m_ProxyIps != null && this.m_ProxyIps.find(ip) != null && (headers = context.getRequestHeaders()) != null && (fip = (String)headers.get("X-Forwarded-For")) != null && fip.length() > 0) {
            idx = fip.indexOf(44) - 1;
            while (idx > 7 && fip.charAt(idx) == ' ') {
                --idx;
            }
            ip = idx > 0 ? fip.substring(0, idx + 1) : fip;
        }
        return ip;
    }

    protected OutputStream wrapResponseOutput(ServerContext context, OutputStream out) throws IOException {
        return out;
    }

    class Handler
    implements ServerHandler,
    Runnable {
        ServerContext m_Context;
        Request m_Request;
        Response m_Response;

        Handler(ServerContext ctx) {
            this.m_Context = ctx;
        }

        protected void exception(Throwable e) {
            if (e instanceof ResponseEndException) {
                _Logger.error(String.valueOf(e), e);
                return;
            }
            try {
                String msg = e.getMessage();
                _Logger.error(String.valueOf(e), e);
                if (!this.m_Context.isRespond()) {
                    byte[] content = null;
                    if (msg != null && msg.length() > 0) {
                        content = msg.getBytes("UTF-8");
                    }
                    this.m_Context.response(500, content);
                } else {
                    this.m_Context.disconnect();
                }
            }
            catch (IOException ee) {
                _Logger.warn(String.valueOf(ee), (Throwable)ee);
            }
        }

        @Override
        public void requestHeader() {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug("requestHeader " + this.m_Context);
            }
            try {
                RestfulServer.this.m_Service.precheck((RestfulRequest)this.openRequest(), (RestfulResponse)this.openResponse());
            }
            catch (Exception e) {
                this.exception(e);
            }
        }

        protected Response openResponse() {
            if (this.m_Response == null) {
                this.m_Response = new Response(this.m_Context, RestfulServer.this);
            }
            return this.m_Response;
        }

        protected Request openRequest() {
            if (this.m_Request == null) {
                this.m_Request = new Request(this.m_Context, RestfulServer.this);
            }
            return this.m_Request;
        }

        @Override
        public void prepared(int available) {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug("prepared:" + available + "," + this.m_Context);
            }
        }

        @Override
        public void requestAbort() {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug("requestAbort " + this.m_Context);
            }
        }

        @Override
        public void requestCompleted() {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug("requestCompleted " + this.m_Context);
            }
            if (this.taskRun(RestfulServer.this.m_Executor)) {
                return;
            }
            this.run();
        }

        protected boolean taskRun(Executor executor) {
            if (executor == null) {
                return false;
            }
            try {
                executor.execute(this);
            }
            catch (RejectedExecutionException e) {
                try {
                    this.m_Context.response(429, ServerContext.RESPONSE_AND_CLOSE);
                    _Logger.warn(String.valueOf(e), (Throwable)e);
                }
                catch (IOException ee) {
                    _Logger.error(String.valueOf(e), (Throwable)ee);
                }
            }
            return true;
        }

        @Override
        public void responseTimeout() {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug("responseTimeout " + this.m_Context);
            }
            try {
                RestfulServer.this.m_Service.timeout((RestfulRequest)this.openRequest(), (RestfulResponse)this.openResponse());
            }
            catch (IOException e) {
                _Logger.error(String.valueOf(e), (Throwable)e);
            }
        }

        @Override
        public void responseCompleted() {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug("responseCompleted " + this.m_Context);
            }
        }

        @Override
        public void errorRequestTransferTo(IOException e, Object msg, OutputStream writer) {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug("err:" + msg + "," + this.m_Context, (Throwable)e);
            }
        }

        @Override
        public void run() {
            try {
                RestfulServer.this.m_Service.service((RestfulRequest)this.openRequest(), (RestfulResponse)this.openResponse());
            }
            catch (Throwable e) {
                this.exception(e);
            }
        }

        public String toString() {
            return String.valueOf(this.m_Context);
        }
    }

    class QuickHandler
    extends Handler {
        boolean runing;

        QuickHandler(ServerContext ctx) {
            super(ctx);
        }

        @Override
        public void requestHeader() {
            super.requestHeader();
            if (!this.runing && this.taskRun(RestfulServer.this.m_Executor)) {
                this.runing = true;
            }
        }

        @Override
        public void requestCompleted() {
            if (this.runing) {
                return;
            }
            _Logger.warn("\u6ca1\u80fd\u66f4\u65e9\u5f00\u59cb\u4e1a\u52a1\u5904\u7406\uff1f" + this);
            super.requestCompleted();
        }
    }

    public static class Request
    implements RestfulRequest {
        final RestfulServer m_Server;
        final ServerContext m_Context;

        Request(ServerContext ctx, RestfulServer server) {
            this.m_Context = ctx;
            this.m_Server = server;
        }

        public ServerContext getContext() {
            return this.m_Context;
        }

        public String getVerb() {
            return this.m_Context.getVerb();
        }

        public String getUri() {
            return this.m_Context.getUri();
        }

        public DictionaryExt<String, String> getParams() {
            return this.m_Context.getParams();
        }

        public DictionaryExt<String, String> getHeaders() {
            return this.m_Context.getRequestHeaders();
        }

        public InputStream getContent() throws IOException {
            return this.m_Context.getRequestStream();
        }

        public String getClientIp() {
            return this.m_Server.getRealIp(this.m_Context);
        }
    }

    public static class Response
    implements RestfulResponse {
        final RestfulServer m_Server;
        final ServerContext m_Context;
        int m_Status;

        Response(ServerContext ctx, RestfulServer server) {
            this.m_Context = ctx;
            this.m_Server = server;
        }

        public ServerContext getContext() {
            return this.m_Context;
        }

        public void setResponse(int timeout) throws IOException {
            this.m_Context.setResponseTimeout(timeout);
        }

        public void setHeader(String name, String value) throws IOException {
            this.m_Context.setResponseHeader(name, value);
        }

        public void setStatus(int status) throws IOException {
            this.m_Status = status;
        }

        public OutputStream openOutput() throws IOException {
            return this.m_Server.wrapResponseOutput(this.m_Context, this.m_Context.openResponseWriter(this.m_Status, null));
        }

        public void close() {
            this.m_Context.disconnect();
        }

        public boolean isRespond() {
            return this.m_Context.isRespond();
        }
    }
}

