/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.netty;

import cn.weforward.common.io.InputStreamNio;
import cn.weforward.protocol.aio.netty.ByteBufStream;
import cn.weforward.protocol.aio.netty.Leakable;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakTracker;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBufInput
extends InputStream
implements InputStreamNio,
ByteBufStream,
Leakable {
    static final Logger _Logger = LoggerFactory.getLogger(ByteBufInput.class);
    protected ByteBuf m_Buffer;
    protected boolean m_Completed;
    ResourceLeakTracker<Leakable> m_Leak;
    public static InputStream _empty = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };
    public static ByteBufInput _completed = new Closed(true){

        @Override
        public String toString() {
            return "_completed";
        }
    };
    public static ByteBufInput _aborted = new Closed(false){

        @Override
        public String toString() {
            return "_aborted";
        }
    };

    public ByteBufInput(ByteBuf byteBuf, boolean completed) {
        this.m_Buffer = byteBuf;
        this.m_Completed = completed;
        if (ResourceLeakDetector.Level.ADVANCED == ResourceLeakDetector.getLevel() || ResourceLeakDetector.Level.PARANOID == ResourceLeakDetector.getLevel()) {
            this.m_Leak = _LeakDetector.track((Object)this);
        }
    }

    private ByteBuf getByteBuf() throws EOFException {
        ByteBuf buf = this.m_Buffer;
        if (buf == null) {
            throw new EOFException("closed");
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        ByteBuf buf;
        ByteBuf byteBuf = buf = this.getByteBuf();
        synchronized (byteBuf) {
            block5: {
                if (this.readying(buf)) break block5;
                return -1;
            }
            if (len > buf.readableBytes()) {
                len = buf.readableBytes();
            }
            buf.readBytes(b, off, len);
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer dst) throws IOException {
        ByteBuf buf;
        ByteBuf byteBuf = buf = this.getByteBuf();
        synchronized (byteBuf) {
            block5: {
                if (this.readying(buf)) break block5;
                return -1;
            }
            if (dst.remaining() > buf.readableBytes()) {
                dst.limit(dst.position() + buf.readableBytes());
            }
            int len = dst.remaining();
            buf.readBytes(dst);
            return len;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        ByteBuf buf;
        ByteBuf byteBuf = buf = this.getByteBuf();
        synchronized (byteBuf) {
            block5: {
                if (this.readying(buf)) break block5;
                return -1L;
            }
            if (n > (long)buf.readableBytes()) {
                n = buf.readableBytes();
            }
            buf.skipBytes((int)n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        ByteBuf buf;
        ByteBuf byteBuf = buf = this.getByteBuf();
        synchronized (byteBuf) {
            return buf.readableBytes();
        }
    }

    @Override
    public void close() throws IOException {
        this.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        ByteBuf buf;
        ByteBuf byteBuf = buf = this.getByteBuf();
        synchronized (byteBuf) {
            block4: {
                if (this.readying(buf)) break block4;
                return -1;
            }
            int ret = buf.readByte();
            return ret < 0 ? 256 + ret : ret;
        }
    }

    protected boolean readying(ByteBuf buf) throws IOException {
        while (true) {
            if (this.m_Buffer == null) {
                throw new EOFException("closed");
            }
            if (buf.readableBytes() > 0) {
                return true;
            }
            if (this.m_Completed) {
                return false;
            }
            try {
                buf.wait();
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readable() {
        ByteBuf buf = this.m_Buffer;
        if (buf != null) {
            ByteBuf byteBuf = buf;
            synchronized (byteBuf) {
                buf.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readable(ByteBuf data) {
        ByteBuf buf = this.m_Buffer;
        if (buf != null) {
            ByteBuf byteBuf = buf;
            synchronized (byteBuf) {
                if (buf instanceof CompositeByteBuf) {
                    ((CompositeByteBuf)buf).addComponent(true, data.retain());
                } else {
                    buf.writeBytes(data);
                }
                buf.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed() {
        this.m_Completed = true;
        ByteBuf buf = this.m_Buffer;
        if (buf != null) {
            ByteBuf byteBuf = buf;
            synchronized (byteBuf) {
                buf.notify();
            }
        }
    }

    @Override
    public boolean isCompleted() {
        return this.m_Completed;
    }

    @Override
    public void abort() {
        this.end();
    }

    @Override
    public void touch(Object hint) {
        if (this.m_Leak != null) {
            this.m_Leak.record(hint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        ByteBuf buf = this.m_Buffer;
        if (buf != null) {
            ByteBuf byteBuf = buf;
            synchronized (byteBuf) {
                if (buf == this.m_Buffer) {
                    this.m_Buffer = null;
                }
                buf.release();
                buf.notifyAll();
            }
            if (this.m_Leak != null) {
                this.m_Leak.close((Object)this);
            }
        }
    }

    public InputStreamNio duplicate() throws IOException {
        if (!this.isCompleted()) {
            throw new IOException("\u6570\u636e\u672a\u5b8c\u6574\uff0c\u65e0\u6cd5\u521b\u5efa\u526f\u672c");
        }
        return new ByteBufInput(this.m_Buffer.retainedDuplicate(), true);
    }

    public static class Closed
    extends ByteBufInput {
        public Closed(boolean completed) {
            super(Unpooled.buffer((int)0), completed);
        }

        @Override
        public void readable() {
        }

        @Override
        public void completed() {
        }

        @Override
        public void end() {
        }

        public String toString() {
            return "_closed";
        }
    }
}

