/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.netty;

import cn.weforward.protocol.aio.netty.ByteBufInput;
import cn.weforward.protocol.aio.netty.ByteBufStream;
import cn.weforward.protocol.aio.netty.Leakable;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakTracker;
import java.io.IOException;
import java.io.InputStream;

public class CompositeByteBufStream
implements ByteBufStream,
Leakable {
    protected CompositeByteBuf m_Buffer;
    protected boolean m_Completed;
    ResourceLeakTracker<Leakable> m_Leak;

    public CompositeByteBufStream(CompositeByteBuf buffer) {
        this.m_Buffer = buffer;
        if (ResourceLeakDetector.Level.ADVANCED == ResourceLeakDetector.getLevel() || ResourceLeakDetector.Level.PARANOID == ResourceLeakDetector.getLevel()) {
            this.m_Leak = _LeakDetector.track((Object)this);
        }
    }

    @Override
    public synchronized void readable(ByteBuf data) {
        this.m_Buffer.addComponent(true, data.retain());
    }

    @Override
    public int available() {
        return this.m_Buffer == null ? 0 : this.m_Buffer.readableBytes();
    }

    @Override
    public synchronized void completed() {
        if (this.m_Buffer != null) {
            this.m_Completed = true;
        }
    }

    @Override
    public synchronized void abort() {
        if (this.m_Buffer != null) {
            this.m_Buffer.release();
            this.m_Buffer = null;
            this.cleanup();
        }
    }

    @Override
    public void touch(Object hint) {
        if (this.m_Leak != null) {
            this.m_Leak.record(hint);
        }
    }

    public synchronized ByteBuf detach() {
        CompositeByteBuf buffer = this.m_Buffer;
        this.m_Buffer = null;
        this.touch(null);
        this.cleanup();
        return buffer;
    }

    public synchronized ByteBufInput detachToStream() {
        ByteBufInput stream = new ByteBufInput(this.detach(), this.isCompleted());
        return stream;
    }

    @Override
    public boolean isCompleted() {
        return this.m_Completed;
    }

    public synchronized InputStream snapshot() {
        if (this.m_Buffer == null || !this.m_Buffer.isReadable()) {
            return ByteBufInput._empty;
        }
        this.touch(null);
        ByteBufInput stream = new ByteBufInput(this.m_Buffer.retainedDuplicate(), true);
        return stream;
    }

    public synchronized ByteBufInput toStream(int skipBytes) throws IOException {
        int readableBytes = this.available();
        if (skipBytes > 0 && skipBytes > readableBytes) {
            throw new IOException("\u8d85\u8fc7\u8303\u56f4" + skipBytes + ">" + readableBytes);
        }
        CompositeByteBuf mirrorBuffer = Unpooled.compositeBuffer();
        int i = 0;
        while (i < this.m_Buffer.numComponents()) {
            mirrorBuffer.addComponent(true, this.m_Buffer.component(i).retain());
            ++i;
        }
        if (skipBytes > 0) {
            mirrorBuffer.skipBytes(skipBytes);
        }
        return new ByteBufInput((ByteBuf)mirrorBuffer, this.isCompleted());
    }

    public void skipBytes(int skipBytes) {
        this.m_Buffer.skipBytes(skipBytes);
    }

    protected void cleanup() {
        if (this.m_Leak != null) {
            this.m_Leak.close((Object)this);
        }
    }
}

