/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.netty;

import cn.weforward.common.GcCleanable;
import cn.weforward.common.sys.GcCleaner;
import cn.weforward.common.util.RingBuffer;
import cn.weforward.common.util.StringPool;
import cn.weforward.protocol.aio.netty.NettyHttpHeaders;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.AppendableCharSequence;

public class HeadersParser
implements ByteProcessor {
    public static StringPool _NamePool = new StringPool(128);
    public static final int HEADER_LENGTH_MAX = 8192;
    protected final AppendableCharSequence m_Line = new AppendableCharSequence(1024);
    protected final int m_MaxLength;
    protected int m_Size;
    protected CharSequence m_Name;
    protected CharSequence m_Value;
    public static RingBuffer<HeadersParser> _Pool = new RingBuffer<HeadersParser>(512){

        public boolean offer(HeadersParser item) {
            item.reset();
            return super.offer((Object)item);
        }

        protected HeadersParser onEmpty() {
            return new HeadersParser();
        }

        protected void onInit() {
            GcCleaner.register((GcCleanable)this);
        }
    };

    public HeadersParser() {
        this(8192);
    }

    public HeadersParser(int maxLength) {
        this.m_MaxLength = maxLength;
    }

    public void reset() {
        this.m_Size = 0;
        this.m_Name = null;
        this.m_Value = null;
        this.m_Line.setLength(0);
    }

    public boolean process(byte value) throws Exception {
        char nextByte = (char)(value & 0xFF);
        if (nextByte == '\r') {
            return true;
        }
        if (nextByte == '\n') {
            return false;
        }
        if (++this.m_Size > this.m_MaxLength) {
            new TooLongFrameException("HTTP header is larger than " + this.m_MaxLength + " bytes.");
        }
        this.m_Line.append(nextByte);
        return true;
    }

    public HttpHeaders openHeaders(HttpHeaders headers) {
        if (EmptyHttpHeaders.INSTANCE == headers) {
            headers = new DefaultHttpHeaders(false);
        }
        return headers;
    }

    public cn.weforward.protocol.aio.http.HttpHeaders parse(ByteBuf buffer) {
        return NettyHttpHeaders.valueOf(this.parseRaw(buffer));
    }

    public HttpHeaders parseRaw(ByteBuf buffer) {
        AppendableCharSequence line = this.parseLine(buffer);
        if (line == null) {
            return EmptyHttpHeaders.INSTANCE;
        }
        EmptyHttpHeaders headers = EmptyHttpHeaders.INSTANCE;
        while (line.length() > 0) {
            char firstChar = line.charAt(0);
            if (this.m_Name != null && (firstChar == ' ' || firstChar == '\t')) {
                String trimmedLine = line.toString().trim();
                String valueStr = String.valueOf(this.m_Value);
                this.m_Value = String.valueOf(valueStr) + ' ' + trimmedLine;
            } else {
                if (this.m_Name != null) {
                    headers = this.openHeaders((HttpHeaders)headers);
                    headers.add(this.m_Name, (Object)this.m_Value);
                }
                this.splitHeader(line);
            }
            line = this.parseLine(buffer);
            if (line != null) continue;
            return headers;
        }
        if (this.m_Name != null) {
            headers = this.openHeaders((HttpHeaders)headers);
            headers.add(this.m_Name, (Object)this.m_Value);
        }
        this.m_Name = null;
        this.m_Value = null;
        return headers;
    }

    private AppendableCharSequence parseLine(ByteBuf buffer) {
        int oldSize = this.m_Size;
        this.m_Line.reset();
        int i = buffer.forEachByte((ByteProcessor)this);
        if (i == -1) {
            this.m_Size = oldSize;
            return null;
        }
        buffer.readerIndex(i + 1);
        return this.m_Line;
    }

    private void splitHeader(AppendableCharSequence sb) {
        int nameStart;
        int length = sb.length();
        int nameEnd = nameStart = HeadersParser.findNonWhitespace(sb, 0);
        while (nameEnd < length) {
            char ch = sb.charAt(nameEnd);
            if (ch == ':' || Character.isWhitespace(ch)) break;
            ++nameEnd;
        }
        int colonEnd = nameEnd;
        while (colonEnd < length) {
            if (sb.charAt(colonEnd) == ':') {
                ++colonEnd;
                break;
            }
            ++colonEnd;
        }
        this.m_Name = _NamePool.intern((CharSequence)sb, nameStart, nameEnd);
        int valueStart = HeadersParser.findNonWhitespace(sb, colonEnd);
        if (valueStart == length) {
            this.m_Value = "";
        } else {
            int valueEnd = HeadersParser.findEndOfString(sb);
            this.m_Value = sb.subStringUnsafe(valueStart, valueEnd);
        }
    }

    private static int findNonWhitespace(AppendableCharSequence sb, int offset) {
        int result = offset;
        while (result < sb.length()) {
            if (!Character.isWhitespace(sb.charAtUnsafe(result))) {
                return result;
            }
            ++result;
        }
        return sb.length();
    }

    private static int findEndOfString(AppendableCharSequence sb) {
        int result = sb.length() - 1;
        while (result > 0) {
            if (!Character.isWhitespace(sb.charAtUnsafe(result))) {
                return result + 1;
            }
            --result;
        }
        return 0;
    }
}

