/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.netty;

import cn.weforward.common.io.StayException;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.protocol.aio.ClientHandler;
import cn.weforward.protocol.aio.http.HttpClient;
import cn.weforward.protocol.aio.http.HttpHeaders;
import cn.weforward.protocol.aio.netty.ByteBufInput;
import cn.weforward.protocol.aio.netty.ByteBufStream;
import cn.weforward.protocol.aio.netty.CompositeByteBufStream;
import cn.weforward.protocol.aio.netty.NettyHttpClientFactory;
import cn.weforward.protocol.aio.netty.NettyHttpHeaders;
import cn.weforward.protocol.aio.netty.NettyOutputStream;
import cn.weforward.protocol.client.execption.TransportException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpClient
extends ChannelInboundHandlerAdapter
implements HttpClient {
    static final Logger _Logger = LoggerFactory.getLogger(NettyHttpClient.class);
    protected final NettyHttpClientFactory m_Factory;
    protected ClientHandler m_Handler;
    protected ChannelHandlerContext m_Ctx;
    protected io.netty.handler.codec.http.HttpHeaders m_RequestHeaders;
    protected HttpRequest m_Request;
    protected NettyOutputStream m_RequestWriter;
    protected long m_RequestTimepoint;
    protected int m_Timeout;
    protected ScheduledFuture<?> m_TimeoutTask;
    protected long m_BodyLength;
    protected long m_TransferTimepoint;
    protected int m_Bps;
    protected HttpResponse m_Response;
    protected ByteBufStream m_ResponseBody;
    protected NettyOutputStream m_ResponseTransferTo;
    protected int m_ReadTimeout;
    protected String m_UserAgent;

    protected NettyHttpClient(NettyHttpClientFactory factory, ClientHandler handler) {
        this.m_Factory = factory;
        this.m_Handler = handler;
        if (ClientHandler.SYNC == handler) {
            this.setReadTimeout(60000);
        }
        this.m_UserAgent = "netty";
    }

    public void setUserAgent(String agent) {
        this.m_UserAgent = agent;
    }

    public void connectFail(Throwable cause) {
        ClientHandler handler;
        if (this.isDebugEnabled()) {
            _Logger.warn("\u8fde\u63a5\u5931\u8d25", cause);
        }
        if ((handler = this.m_Handler) != null) {
            this.m_Handler = null;
            handler.connectFail();
        }
        this.cleanup();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.isDebugEnabled()) {
            _Logger.info(this.formatMessage("channelInactive"));
        }
        super.channelInactive(ctx);
        this.m_Ctx = null;
        this.close();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.m_Ctx = ctx;
        super.handlerAdded(ctx);
        this.beginRequest();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            if (msg instanceof HttpResponse) {
                this.responseHeader((HttpResponse)msg);
            }
            if (msg instanceof HttpContent) {
                this.readable(((HttpContent)msg).content());
            }
            if (msg instanceof LastHttpContent) {
                this.responseCompleted();
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    private io.netty.handler.codec.http.HttpHeaders openRequestHeaders() {
        io.netty.handler.codec.http.HttpHeaders headers = this.m_RequestHeaders;
        if (headers == null) {
            this.m_RequestHeaders = headers = new DefaultHttpHeaders();
        }
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginRequest() {
        if (this.isDebugEnabled()) {
            _Logger.info(this.formatMessage("requesting"));
        }
        NettyHttpClient nettyHttpClient = this;
        synchronized (nettyHttpClient) {
            if (this.m_Request == null) {
                _Logger.error(this.formatMessage("\u8bf7\u6c42\u672a\u5f00\u59cb\u5c31\u53d6\u6d88\u4e86\uff1f"));
                return;
            }
            this.m_TransferTimepoint = System.currentTimeMillis();
            if (this.m_Request instanceof FullHttpRequest) {
                this.m_Ctx.writeAndFlush((Object)this.m_Request).addListener(this.getSubmitListener());
            }
            if (this.m_Timeout > 0) {
                long remaind = (long)this.m_Timeout - (System.currentTimeMillis() - this.m_RequestTimepoint);
                if (remaind <= 0L) {
                    this.responseTimeout();
                } else {
                    this.setTimeoutTask(this.m_Ctx, remaind);
                }
            }
            this.notifyAll();
        }
        this.m_Handler.established(this);
    }

    private void setTimeoutTask(ChannelHandlerContext ctx, long millis) {
        ScheduledFuture<?> task = this.m_TimeoutTask;
        if (task != null) {
            this.m_TimeoutTask = null;
            task.cancel(false);
        }
        if (ctx == null || millis < 1L) {
            return;
        }
        this.m_TimeoutTask = ctx.executor().schedule((Runnable)new TimeoutChecker(), millis, TimeUnit.MILLISECONDS);
    }

    public int getReadTimeout() {
        return this.m_ReadTimeout;
    }

    public void setReadTimeout(int mills) {
        this.m_ReadTimeout = mills;
    }

    private synchronized void waitConnect(int timeout) throws IOException {
        long ts = System.currentTimeMillis();
        while (this.m_Ctx == null) {
            int mills = timeout - (int)(System.currentTimeMillis() - ts);
            if (mills <= 0) {
                throw new TransportException(4, "\u8d85\u65f6", null);
            }
            try {
                this.wait(mills);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
        }
    }

    private synchronized void waitResponse(int timeout) throws IOException {
        if (this.isClosed()) {
            throw new EOFException("closed");
        }
        long ts = System.currentTimeMillis();
        while (!this.isResponseCompleted()) {
            int mills = timeout - (int)(System.currentTimeMillis() - ts);
            if (mills <= 0) {
                throw new TransportException(2, "\u8d85\u65f6", null);
            }
            try {
                this.wait(mills);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestCompleted() {
        if (this.isDebugEnabled() && NettyOutputStream._end != this.m_RequestWriter) {
            _Logger.info(this.formatMessage("requestCompleted"));
        }
        ClientHandler handler = this.m_Handler;
        NettyHttpClient nettyHttpClient = this;
        synchronized (nettyHttpClient) {
            if (NettyOutputStream._end == this.m_RequestWriter) {
                handler = null;
            }
            this.m_RequestWriter = NettyOutputStream._end;
            this.m_Request = null;
            this.m_RequestHeaders = null;
        }
        if (handler != null) {
            handler.requestCompleted();
        }
    }

    private void requestAbort() {
        ClientHandler handler;
        if (this.isDebugEnabled()) {
            _Logger.info(this.formatMessage("requestAbort"));
        }
        if ((handler = this.m_Handler) != null) {
            this.m_Handler = null;
            this.disconnect();
            handler.requestAbort();
        }
    }

    private void calcBsp() {
        long ts = System.currentTimeMillis() - this.m_TransferTimepoint;
        if (ts > 0L) {
            this.m_Bps = (int)(this.m_BodyLength * 1000L / ts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void responseCompleted() {
        ClientHandler handler;
        if (this.isDebugEnabled()) {
            _Logger.info(this.formatMessage("responseCompleted"));
        }
        NettyHttpClient nettyHttpClient = this;
        synchronized (nettyHttpClient) {
            this.m_ResponseTransferTo = null;
            handler = this.m_Handler;
            if (handler == null) {
                _Logger.warn(this.formatMessage("\u6536\u5230\u54cd\u5e94\u524d\u5df2\u5173\u95ed\uff01"));
                this.cleanup();
                return;
            }
            if (this.m_Response == null) {
                _Logger.error(this.formatMessage("\u65e0\u54cd\u5e94\u5934\u7ed3\u675f\uff1f"));
                this.disconnect();
                return;
            }
            if (this.m_ResponseBody != null) {
                this.m_ResponseBody.completed();
            }
            this.m_Handler = null;
            this.free();
        }
        handler.responseCompleted();
    }

    private void responseTimeout() {
        this.m_Handler.responseTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readable(ByteBuf data) throws IOException {
        ByteBufStream body;
        if (data.readableBytes() == 0) {
            return;
        }
        this.m_BodyLength += (long)data.readableBytes();
        this.calcBsp();
        if (_Logger.isTraceEnabled()) {
            _Logger.trace("{\u6536\u5230:" + data.readableBytes() + ",total:" + this.m_BodyLength + ",bps:" + this.m_Bps + "}");
        }
        NettyHttpClient nettyHttpClient = this;
        synchronized (nettyHttpClient) {
            if (this.forwardResponse(data)) {
                return;
            }
            body = this.m_ResponseBody;
            if (body != null) {
                body.readable(data);
            }
        }
        ClientHandler handler = this.m_Handler;
        if (handler != null && body != null) {
            handler.prepared(body.available());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void responseHeader(HttpResponse rsp) {
        ByteBufStream body;
        this.m_Response = rsp;
        this.m_BodyLength = 0L;
        if (this.isDebugEnabled()) {
            _Logger.info(this.formatMessage("responseHeader"));
        }
        if ((body = this.m_ResponseBody) != null) {
            _Logger.error(this.formatMessage("responseBody!=null\uff1f" + body));
            body.abort();
        }
        this.m_ResponseBody = new CompositeByteBufStream(this.getAllocator().compositeBuffer());
        this.m_TransferTimepoint = System.currentTimeMillis();
        this.requestCompleted();
        if (ClientHandler.SYNC == this.m_Handler) {
            NettyHttpClient nettyHttpClient = this;
            synchronized (nettyHttpClient) {
                this.notifyAll();
            }
        } else {
            this.m_Handler.responseHeader();
        }
    }

    protected ByteBufAllocator getAllocator() {
        ChannelHandlerContext ctx = this.m_Ctx;
        if (ctx != null) {
            return ctx.alloc();
        }
        return ByteBufAllocator.DEFAULT;
    }

    protected boolean forwardResponse(ByteBuf data) {
        NettyOutputStream out = this.m_ResponseTransferTo;
        if (out == null) {
            return false;
        }
        ClientHandler handler = this.m_Handler;
        try {
            out.write(data);
            return true;
        }
        catch (Exception e) {
            this.disconnect();
            if (handler == null) {
                try {
                    out.cancel();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                _Logger.error(out.toString(), (Throwable)e);
            } else if (e instanceof IOException) {
                handler.errorResponseTransferTo((IOException)e, data, out);
            } else {
                handler.errorResponseTransferTo(new IOException(e), data, out);
            }
            return false;
        }
    }

    private void ensureResponse() throws IOException {
        if (this.m_Response == null || this.m_ResponseBody == null) {
            throw new IOException("\u672a\u6709\u54cd\u5e94");
        }
    }

    private void ensureResponseStream() throws IOException {
        this.ensureResponse();
        if (this.m_ResponseTransferTo != null) {
            throw new IOException("\u5df2\u8bbe\u4e3a\u8f6c\u4f20");
        }
    }

    private GenericFutureListener<Future<Void>> getSubmitListener() {
        return new GenericFutureListener<Future<Void>>(){

            public void operationComplete(Future<Void> future) throws Exception {
                if (future.isSuccess()) {
                    NettyHttpClient.this.requestCompleted();
                } else {
                    NettyHttpClient.this.requestAbort();
                }
            }
        };
    }

    public boolean isDebugEnabled() {
        return this.m_Factory.isDebugEnabled();
    }

    private boolean isClosed() {
        return this.m_Handler == null;
    }

    private boolean isRequestCompleted() {
        return NettyOutputStream._end == this.m_RequestWriter;
    }

    @Override
    public void request(String url, String method) throws IOException {
        this.request(url, method, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(String url, String method, int timeout) throws IOException {
        URL uri = new URL(url);
        int port = uri.getPort();
        String protocol = uri.getProtocol().toLowerCase();
        boolean ssl = false;
        if ("http".equals(protocol)) {
            if (port < 1) {
                port = 80;
            }
        } else if ("https".equals(protocol)) {
            if (port < 1) {
                port = 443;
            }
            ssl = true;
        } else {
            throw new MalformedURLException("\u4e0d\u652f\u6301\u7684\u534f\u8bae" + uri.getProtocol());
        }
        NettyHttpClient nettyHttpClient = this;
        synchronized (nettyHttpClient) {
            if (this.m_Request != null) {
                throw new IOException("\u8bf7\u6c42\u5728\u5904\u7406\u4e2d");
            }
            this.m_RequestTimepoint = System.currentTimeMillis();
            if (timeout > 0) {
                this.m_Timeout = timeout;
            }
            io.netty.handler.codec.http.HttpHeaders headers = this.openRequestHeaders();
            headers.set((CharSequence)HttpHeaderNames.HOST, (Object)uri.getHost());
            headers.set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            headers.set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.m_UserAgent);
            headers.set((CharSequence)HttpHeaderNames.ACCEPT, (Object)"*/*");
            headers.set((CharSequence)HttpHeaderNames.ACCEPT_CHARSET, (Object)"UTF-8");
            method = method.toUpperCase();
            HttpMethod httpMethod = HttpMethod.valueOf((String)method);
            if (HttpMethod.GET.equals((Object)httpMethod) || HttpMethod.HEAD.equals((Object)httpMethod)) {
                headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)HttpHeaderValues.ZERO);
                this.m_Request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, uri.getFile(), Unpooled.buffer((int)0), this.m_RequestHeaders, (io.netty.handler.codec.http.HttpHeaders)EmptyHttpHeaders.INSTANCE);
            } else {
                this.m_Request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, httpMethod, uri.getFile(), this.m_RequestHeaders);
            }
        }
        this.m_Factory.connect(this, uri.getHost(), port, ssl);
    }

    @Override
    public void setTimeout(int millis) throws IOException {
        this.m_Timeout = millis;
    }

    @Override
    public void setRequestHeader(String name, String value) throws IOException {
        if (value != null) {
            this.openRequestHeaders().set(name, (Object)value);
        } else {
            io.netty.handler.codec.http.HttpHeaders headers = this.m_RequestHeaders;
            if (headers != null) {
                headers.remove(name);
            }
        }
    }

    @Override
    public synchronized NettyOutputStream openRequestWriter() throws IOException {
        if (this.m_Request == null) {
            throw new IOException("\u672a\u8bf7\u6c42\u6216\u5df2\u4e2d\u65ad");
        }
        if (ClientHandler.SYNC == this.m_Handler) {
            this.waitConnect(this.m_Factory.getConnectTimeout());
        }
        if (this.m_Ctx == null) {
            throw new IOException("\u8fde\u63a5\u672a\u5c31\u7eea\u6216\u5df2\u5173\u95ed");
        }
        if (this.m_RequestWriter != null) {
            throw new IOException("\u8bf7\u6c42\u6d41\u5df2\u6253\u5f00");
        }
        this.m_RequestWriter = new RequestOutput();
        return this.m_RequestWriter;
    }

    @Override
    public int bps() {
        return this.m_Bps;
    }

    @Override
    public int getResponseCode() throws IOException {
        if (ClientHandler.SYNC == this.m_Handler) {
            this.waitResponse(this.getReadTimeout());
        }
        this.ensureResponse();
        return this.m_Response.status().code();
    }

    @Override
    public HttpHeaders getResponseHeaders() throws IOException {
        if (ClientHandler.SYNC == this.m_Handler) {
            this.waitResponse(this.getReadTimeout());
        }
        this.ensureResponse();
        return new NettyHttpHeaders(this.m_Response.headers());
    }

    @Override
    public synchronized void responseTransferTo(OutputStream writer, int skipBytes) throws IOException {
        this.ensureResponseStream();
        if (!(this.m_ResponseBody instanceof CompositeByteBufStream)) {
            throw new IOException("\u53ea\u80fd\u5728getResponseStream\u524d\u8c03\u7528");
        }
        CompositeByteBufStream bufStream = (CompositeByteBufStream)this.m_ResponseBody;
        int readableBytes = bufStream.available();
        if (skipBytes > 0) {
            if (skipBytes > readableBytes) {
                throw new IOException("\u8d85\u8fc7\u8303\u56f4" + skipBytes + ">" + readableBytes);
            }
            bufStream.skipBytes(skipBytes);
        }
        this.m_ResponseTransferTo = NettyOutputStream.wrap(writer);
        ByteBuf buf = bufStream.detach();
        if (buf != null) {
            try {
                this.m_ResponseBody = null;
                this.forwardResponse(buf);
            }
            finally {
                buf.release();
            }
        }
    }

    @Override
    public synchronized InputStream getResponseStream() throws IOException {
        if (ClientHandler.SYNC == this.m_Handler) {
            this.waitResponse(this.getReadTimeout());
        }
        this.ensureResponse();
        if (this.m_ResponseBody instanceof CompositeByteBufStream) {
            CompositeByteBufStream bufStream = (CompositeByteBufStream)this.m_ResponseBody;
            ByteBufInput stream = bufStream.detachToStream();
            this.m_ResponseBody = stream;
            return stream;
        }
        return (ByteBufInput)this.m_ResponseBody;
    }

    @Override
    public synchronized InputStream duplicateResponseStream() throws IOException {
        this.ensureResponseStream();
        if (!(this.m_ResponseBody instanceof CompositeByteBufStream)) {
            throw new IOException("\u53ea\u80fd\u5728getResponseStream\u524d\u4f7f\u7528");
        }
        CompositeByteBufStream bufStream = (CompositeByteBufStream)this.m_ResponseBody;
        return bufStream.snapshot();
    }

    @Override
    public boolean isResponseCompleted() {
        ByteBufStream input = this.m_ResponseBody;
        return this.m_Response != null && input != null && input.isCompleted();
    }

    private synchronized void free() {
        if (this.m_Ctx != null) {
            this.setTimeoutTask(null, 0L);
            this.m_Ctx.pipeline().remove((ChannelHandler)this);
            this.m_Factory.free(this.m_Ctx.channel());
            this.m_Ctx = null;
        }
        this.notifyAll();
    }

    private synchronized void cleanup() {
        NettyOutputStream responseTransferTo;
        if (this.isDebugEnabled()) {
            _Logger.info(this.formatMessage("cleanup"));
        }
        this.setTimeoutTask(null, 0L);
        NettyOutputStream requestWriter = this.m_RequestWriter;
        if (requestWriter != null) {
            this.m_RequestWriter = null;
            try {
                requestWriter.cancel();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.m_ResponseBody != null) {
            this.m_ResponseBody.abort();
            this.m_ResponseBody = null;
        }
        if ((responseTransferTo = this.m_ResponseTransferTo) != null) {
            this.m_ResponseTransferTo = null;
            try {
                responseTransferTo.cancel();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.m_Request = null;
        this.m_RequestHeaders = null;
        this.m_Response = null;
        this.m_Handler = null;
        this.m_Ctx = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isDebugEnabled()) {
            _Logger.info(this.formatMessage("close"));
        }
        ClientHandler handler = null;
        NettyHttpClient nettyHttpClient = this;
        synchronized (nettyHttpClient) {
            if (!this.isResponseCompleted()) {
                handler = this.m_Handler;
                this.disconnect();
            }
        }
        this.cleanup();
        if (handler != null) {
            handler.requestAbort();
        }
    }

    @Override
    public void disconnect() {
        ChannelHandlerContext ctx = this.m_Ctx;
        if (ctx != null) {
            this.m_Ctx = null;
            if (this.isDebugEnabled()) {
                _Logger.info(this.formatMessage("disconnect"));
            }
            ctx.close();
        }
        this.cleanup();
    }

    private String formatMessage(String caption) {
        StringBuilder builder = StringBuilderPool._128.poll();
        try {
            if (caption != null) {
                builder.append(caption);
            }
            this.toString(builder);
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderPool._128.offer(builder);
        }
    }

    public String toString() {
        StringBuilder builder = StringBuilderPool._128.poll();
        try {
            String string = this.toString(builder).toString();
            return string;
        }
        finally {
            StringBuilderPool._128.offer(builder);
        }
    }

    public StringBuilder toString(StringBuilder builder) {
        Channel channel = this.m_Ctx == null ? null : this.m_Ctx.channel();
        builder.append("{hash:").append(this.hashCode());
        if (channel != null) {
            builder.append(",remote:").append(channel.remoteAddress());
            builder.append(",local:").append(channel.localAddress());
        }
        builder.append(",state:");
        if (this.isResponseCompleted()) {
            builder.append("completed");
        } else if (this.m_Ctx == null) {
            builder.append("init");
        } else if (this.isRequestCompleted()) {
            builder.append("requested");
        } else if (this.m_Request != null) {
            builder.append("request");
        } else {
            builder.append("connect");
        }
        builder.append("}");
        return builder;
    }

    class RequestOutput
    extends NettyOutputStream.Stay {
        boolean m_RequestHeader = false;

        RequestOutput() {
        }

        public synchronized void stay() throws StayException {
            if (this.m_RequestHeader) {
                throw new StayException("\u5df2\u8f93\u51faHTTP\u5934");
            }
            this.m_StayBuffers = NettyHttpClient.this.getAllocator().compositeBuffer();
        }

        @Override
        public boolean isOpen() {
            return this == NettyHttpClient.this.m_RequestWriter;
        }

        @Override
        protected ByteBuf allocBuffer(int len) {
            return NettyHttpClient.this.getAllocator().buffer(len);
        }

        @Override
        protected void flush(ByteBuf buf) throws IOException {
            this.sendRequest(buf, false);
        }

        protected ChannelFuture sendRequest(ByteBuf content, boolean isFinal) throws IOException {
            ChannelFuture future;
            if (!this.m_RequestHeader) {
                io.netty.handler.codec.http.HttpHeaders headers = NettyHttpClient.this.openRequestHeaders();
                if (isFinal) {
                    if (content == null) {
                        headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)HttpHeaderValues.ZERO);
                        content = Unpooled.buffer((int)0);
                    } else {
                        headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)String.valueOf(content.readableBytes()));
                    }
                    DefaultFullHttpRequest hc = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, NettyHttpClient.this.m_Request.method(), NettyHttpClient.this.m_Request.uri(), content.retain(), headers, (io.netty.handler.codec.http.HttpHeaders)EmptyHttpHeaders.INSTANCE);
                    NettyHttpClient.this.m_RequestWriter = NettyOutputStream._pending;
                    this.m_RequestHeader = true;
                    ChannelFuture future2 = NettyHttpClient.this.m_Ctx.writeAndFlush((Object)hc);
                    return future2;
                }
                headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                this.m_RequestHeader = true;
                future = NettyHttpClient.this.m_Ctx.write((Object)NettyHttpClient.this.m_Request);
                if (content == null) {
                    return future;
                }
            }
            if (isFinal) {
                Object hc = content != null ? new DefaultLastHttpContent(content.retain()) : LastHttpContent.EMPTY_LAST_CONTENT;
                NettyHttpClient.this.m_RequestWriter = NettyOutputStream._pending;
                future = NettyHttpClient.this.m_Ctx.writeAndFlush(hc);
                return future;
            }
            future = NettyHttpClient.this.m_Ctx.write((Object)content.retain());
            return future;
        }

        @Override
        public synchronized void close() throws IOException {
            if (!this.isOpen()) {
                this.cleanup();
                throw new EOFException();
            }
            try {
                this.flush();
                ChannelFuture future = this.sendRequest(this.m_Last, true);
                future.addListener(NettyHttpClient.this.getSubmitListener());
            }
            finally {
                this.cleanup();
            }
        }

        public synchronized void cancel() throws IOException {
            this.cleanup();
            if (this == NettyHttpClient.this.m_RequestWriter) {
                NettyHttpClient.this.disconnect();
            }
        }
    }

    class TimeoutChecker
    implements Runnable {
        TimeoutChecker() {
        }

        @Override
        public void run() {
            long remaind;
            try {
                int timeout = NettyHttpClient.this.m_Timeout;
                if (timeout <= 0) {
                    return;
                }
                remaind = (long)timeout - System.currentTimeMillis() - NettyHttpClient.this.m_RequestTimepoint;
                if (remaind <= 0L) {
                    NettyHttpClient.this.responseTimeout();
                    return;
                }
            }
            finally {
                NettyHttpClient.this.m_TimeoutTask = null;
            }
            if (_Logger.isTraceEnabled()) {
                _Logger.trace("timeout-check(" + remaind + "ms)");
            }
            NettyHttpClient.this.setTimeoutTask(NettyHttpClient.this.m_Ctx, remaind);
        }
    }
}

