/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.netty;

import cn.weforward.common.execption.Unexpected;
import cn.weforward.common.util.NumberUtil;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.aio.ClientChannel;
import cn.weforward.protocol.aio.ClientContext;
import cn.weforward.protocol.aio.ClientHandler;
import cn.weforward.protocol.aio.netty.NettyHttpClient;
import cn.weforward.protocol.aio.netty.NettyMemMonitor;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.OutOfDirectMemoryError;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpClientFactory
implements ClientChannel {
    static final Logger _Logger = LoggerFactory.getLogger(NettyHttpClientFactory.class);
    private static final AttributeKey<ServiceChannel> KEEPALIVE_REQUESTS_KEY = AttributeKey.newInstance((String)"WF.KEEPALIVE_REQUESTS");
    protected Bootstrap m_Bootstrap;
    protected EventLoopGroup m_EventLoopGroup;
    protected Map<String, Service> m_Services;
    protected SslContext m_SslContext;
    protected String m_Name;
    protected int m_Threads;
    protected int m_IdleMillis = 600000;
    protected boolean m_DebugEnabled = false;
    protected int m_FineConnections = NumberUtil.toInt((String)System.getProperty("cn.weforward.protocol.aio.netty.FINE_CONNECTIONS"), (int)100);
    protected int m_KeepaliveRequests = NumberUtil.toInt((String)System.getProperty("cn.weforward.protocol.aio.netty.KEEPALIVE_REQUESTS"), (int)0);
    protected AtomicInteger m_Established = new AtomicInteger();
    protected long m_StartTime;

    public NettyHttpClientFactory() {
        this(false);
    }

    public NettyHttpClientFactory(boolean ssl) {
        this.m_Services = new HashMap<String, Service>();
        this.m_Threads = NettyRuntime.availableProcessors();
        if (this.m_Threads > 4) {
            this.m_Threads = 4;
        }
        try {
            this.setSsl(ssl);
        }
        catch (SSLException e) {
            throw new Unexpected((Throwable)e);
        }
    }

    public void setName(String name) {
        this.m_Name = name;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setThreads(int threads) {
        this.m_Threads = threads;
    }

    public void setFineConnections(int max) {
        this.m_FineConnections = max;
    }

    public void setKeepaliveRequests(int max) {
        this.m_KeepaliveRequests = max;
    }

    public void setIdle(int secs) {
        this.m_IdleMillis = secs * 1000;
    }

    public int getIdleMillis() {
        return this.m_IdleMillis;
    }

    private String genKey(String host, int port) {
        return String.valueOf(host) + ":" + port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Service openService(String host, int port) {
        Service service;
        String key = this.genKey(host, port);
        Map<String, Service> map = this.m_Services;
        synchronized (map) {
            service = this.m_Services.get(key);
            if (service == null) {
                service = new Service(key);
                this.m_Services.put(key, service);
            }
        }
        return service;
    }

    public NettyHttpClient open(ClientHandler handler) {
        NettyHttpClient client = new NettyHttpClient(this, handler);
        return client;
    }

    @Override
    public ClientContext request(ClientHandler handler, String uri, String verb) throws IOException {
        NettyHttpClient client = new NettyHttpClient(this, handler);
        client.request(uri, verb);
        return client;
    }

    public void connect(final NettyHttpClient client, String host, int port, final boolean ssl) throws IOException {
        if (ssl && this.m_SslContext == null) {
            throw new SSLException("\u4e0d\u652f\u6301");
        }
        final Service service = this.openService(host, port);
        Channel channel = service.get();
        if (channel == null) {
            try {
                channel = service.pending(this.m_FineConnections);
            }
            catch (InterruptedException e) {
                throw new InterruptedIOException(e.getMessage());
            }
        }
        if (channel != null) {
            channel.pipeline().addLast("client", (ChannelHandler)client);
            return;
        }
        ChannelFuture future = null;
        try {
            future = this.open().connect(host, port);
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    Channel channel = future.channel();
                    if (future.isSuccess()) {
                        ChannelPipeline pipeline = channel.pipeline();
                        if (ssl) {
                            pipeline.addFirst("ssl", (ChannelHandler)NettyHttpClientFactory.this.m_SslContext.newHandler(channel.alloc()));
                        }
                        pipeline.addLast("service", (ChannelHandler)service);
                        pipeline.addLast("client", (ChannelHandler)client);
                        service.establish(channel);
                        service.debug("\u5df2\u8fde\u63a5", channel);
                    } else {
                        service.fin();
                        client.connectFail(future.cause());
                        channel.close();
                    }
                }
            });
        }
        finally {
            if (future == null) {
                service.fin();
            }
        }
    }

    public void free(Channel channel) {
        if (channel == null || !channel.isActive()) {
            return;
        }
        InetSocketAddress ia = (InetSocketAddress)channel.remoteAddress();
        String host = ia.getHostString();
        int port = ia.getPort();
        Service service = this.openService(host, port);
        service.free(channel);
        service.debug("free", channel);
    }

    public synchronized void setConnectTimeout(int millis) {
        if (this.m_Bootstrap == null) {
            this.m_Bootstrap = new Bootstrap();
        }
        this.m_Bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)millis);
    }

    public int getConnectTimeout() {
        Integer v = (Integer)this.m_Bootstrap.config().options().get(ChannelOption.CONNECT_TIMEOUT_MILLIS);
        return v == null ? 0 : v;
    }

    public int getUptime() {
        return (int)((System.currentTimeMillis() - this.m_StartTime) / 1000L);
    }

    public void setSsl(boolean enabled) throws SSLException {
        if (enabled) {
            SslContextBuilder builder = SslContextBuilder.forClient();
            this.m_SslContext = builder.build();
        } else {
            this.m_SslContext = null;
        }
    }

    public void setDebugEnabled(boolean enabled) {
        this.m_DebugEnabled = enabled;
    }

    public boolean isDebugEnabled() {
        return this.m_DebugEnabled;
    }

    @Override
    public synchronized void close() {
        if (this.m_EventLoopGroup != null) {
            this.m_EventLoopGroup.shutdownGracefully();
        }
        this.m_EventLoopGroup = null;
        if (_Logger.isDebugEnabled()) {
            _Logger.debug(this.formatMessage("close"));
        }
    }

    public synchronized void reset() {
        if (this.m_EventLoopGroup != null) {
            this.m_EventLoopGroup.shutdownGracefully();
        }
        this.m_EventLoopGroup = null;
        this.m_Bootstrap = null;
    }

    @Override
    public boolean isValid() {
        return this.m_Bootstrap == null || this.m_EventLoopGroup != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bootstrap open() {
        if (this.m_EventLoopGroup != null) {
            return this.m_Bootstrap;
        }
        NettyHttpClientFactory nettyHttpClientFactory = this;
        synchronized (nettyHttpClientFactory) {
            if (this.m_EventLoopGroup != null) {
                return this.m_Bootstrap;
            }
            String name = this.getName();
            name = name == null || name.length() == 0 ? "hc" : String.valueOf(name) + "-hc";
            DefaultThreadFactory threadFactory = new DefaultThreadFactory(name, true);
            NioEventLoopGroup eventLoop = new NioEventLoopGroup(this.m_Threads, (ThreadFactory)threadFactory);
            this.m_Bootstrap = new Bootstrap();
            this.m_Bootstrap.group((EventLoopGroup)eventLoop);
            this.m_Bootstrap.channel(NioSocketChannel.class);
            this.m_Bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            this.m_Bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
            this.m_Bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast("c-encoder", (ChannelHandler)new HttpRequestEncoder());
                    pipeline.addLast("c-decoder", (ChannelHandler)new HttpResponseDecoder());
                }
            });
            this.m_EventLoopGroup = eventLoop;
            this.m_StartTime = System.currentTimeMillis();
            this.m_Established.set(0);
            if (_Logger.isDebugEnabled()) {
                _Logger.debug(this.formatMessage("open"));
            }
        }
        NettyMemMonitor.getInstance();
        return this.m_Bootstrap;
    }

    public String toString() {
        return this.formatMessage(null);
    }

    protected String formatMessage(String msg) {
        StringBuilder builder = StringBuilderPool._128.poll();
        try {
            if (!StringUtil.isEmpty((String)msg)) {
                builder.append(msg);
            }
            String string = this.toString(builder).toString();
            return string;
        }
        finally {
            StringBuilderPool._128.offer(builder);
        }
    }

    public StringBuilder toString(StringBuilder builder) {
        builder.append("{wk:").append(this.m_Threads);
        String name = this.getName();
        if (name != null && name.length() > 0) {
            builder.append(",name:").append(name);
        }
        builder.append(",uptime:").append(this.getUptime());
        builder.append(",est:").append(this.m_Established.get());
        builder.append(",ss:").append(this.m_Services.size());
        builder.append(",fine-conn:").append(this.m_FineConnections);
        builder.append(",ka-requests:").append(this.m_KeepaliveRequests);
        builder.append(",idle:").append(this.m_IdleMillis);
        if (this.m_SslContext != null) {
            builder.append(",ssl:true");
        }
        builder.append("}");
        return builder;
    }

    @ChannelHandler.Sharable
    class Service
    extends ChannelInboundHandlerAdapter {
        List<ServiceChannel> m_Channels = new LinkedList<ServiceChannel>();
        int m_Pending;
        long m_Reuses;
        long m_Requests;

        Service(String name) {
        }

        public synchronized void establish(Channel channel) {
            ++this.m_Requests;
            NettyHttpClientFactory.this.m_Established.incrementAndGet();
        }

        synchronized void fin() {
            --this.m_Pending;
            ((Object)((Object)this)).notifyAll();
        }

        synchronized Channel pending(int max) throws InterruptedException {
            if (this.m_Pending + this.m_Channels.size() >= max) {
                ((Object)((Object)this)).wait(100L);
                Channel ret = this.get();
                if (ret != null) {
                    return ret;
                }
                this.debug("\u8d85\u63a7", null);
            }
            ++this.m_Pending;
            return null;
        }

        public int size() {
            return this.m_Channels.size();
        }

        synchronized boolean remove(ServiceChannel serviceChannel) {
            if (this.m_Channels.remove(serviceChannel)) {
                this.fin();
                return true;
            }
            return false;
        }

        synchronized boolean remove(Channel channel) {
            return this.m_Channels.remove(channel);
        }

        public int getIdleMillis() {
            return NettyHttpClientFactory.this.getIdleMillis();
        }

        public synchronized Channel get() {
            ServiceChannel sc;
            if (this.m_Channels.size() > 0 && (sc = this.m_Channels.remove(this.m_Channels.size() - 1)) != null) {
                ++this.m_Pending;
                ++this.m_Reuses;
                ++this.m_Requests;
                return sc.take();
            }
            return null;
        }

        public synchronized void free(Channel channel) {
            ServiceChannel sc = null;
            Attribute attribute = null;
            if (NettyHttpClientFactory.this.m_KeepaliveRequests > 0 && (sc = (ServiceChannel)(attribute = channel.attr(KEEPALIVE_REQUESTS_KEY)).get()) != null && sc.getRequests() >= NettyHttpClientFactory.this.m_KeepaliveRequests) {
                channel.close();
                if (_Logger.isDebugEnabled()) {
                    this.debug("over keepalive requests[" + sc.getRequests() + "]", channel);
                }
                return;
            }
            if (sc == null) {
                sc = new ServiceChannel(this, channel);
                if (attribute != null) {
                    attribute.set((Object)sc);
                }
            }
            this.m_Channels.add(sc);
            --this.m_Pending;
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            Channel channel = ctx.channel();
            this.remove(channel);
            this.fin();
            int count = NettyHttpClientFactory.this.m_Established.decrementAndGet();
            super.channelInactive(ctx);
            this.debug("\u65ad\u5f00", channel);
            if (count == 0 && NettyHttpClientFactory.this.getUptime() > 43200) {
                NettyHttpClientFactory.this.reset();
                _Logger.info(NettyHttpClientFactory.this.formatMessage("reset"));
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof OutOfDirectMemoryError) {
                ctx.close();
            }
            super.exceptionCaught(ctx, cause);
        }

        public void debug(String msg, Channel channel) {
            String content;
            if (!_Logger.isDebugEnabled()) {
                return;
            }
            StringBuilder builder = StringBuilderPool._128.poll();
            try {
                if (msg != null) {
                    builder.append(msg);
                    builder.append(",");
                }
                builder.append("{idle:").append(this.size());
                if (this.m_Reuses > 0L) {
                    builder.append(",reuses:").append(this.m_Reuses);
                }
                if (this.m_Pending > 0) {
                    builder.append(",pending:").append(this.m_Pending);
                }
                builder.append("}");
                if (channel != null) {
                    builder.append(channel.toString());
                }
                content = builder.toString();
            }
            finally {
                StringBuilderPool._128.offer(builder);
            }
            _Logger.debug(content);
        }
    }

    static class ServiceChannel {
        final Service m_Service;
        final Channel m_Channel;
        ScheduledFuture<?> m_IdleTask;
        int m_Requests;

        ServiceChannel(Service service, Channel channel) {
            this.m_Service = service;
            this.m_Channel = channel;
            this.m_Requests = 1;
            this.startIdleTask();
        }

        Channel take() {
            if (this.m_IdleTask != null) {
                this.m_IdleTask.cancel(true);
                this.m_IdleTask = null;
            }
            if (this.m_Channel.isActive() && this.m_Channel.isOpen()) {
                ++this.m_Requests;
                return this.m_Channel;
            }
            return null;
        }

        public int getRequests() {
            return this.m_Requests;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof Channel && this.m_Channel == obj;
        }

        private void startIdleTask() {
            int timeout = this.m_Service.getIdleMillis();
            if (timeout > 0 && this.m_Channel != null && this.m_Channel.isActive()) {
                this.m_IdleTask = this.m_Channel.eventLoop().schedule((Runnable)new IdleChecker(), (long)timeout, TimeUnit.MILLISECONDS);
            }
        }

        class IdleChecker
        implements Runnable {
            IdleChecker() {
            }

            @Override
            public void run() {
                if (ServiceChannel.this.m_Service.remove(ServiceChannel.this)) {
                    ServiceChannel.this.m_Channel.close();
                    if (_Logger.isDebugEnabled()) {
                        ServiceChannel.this.m_Service.debug("Idle[" + ServiceChannel.this.getRequests() + "]", ServiceChannel.this.m_Channel);
                    }
                } else if (_Logger.isDebugEnabled()) {
                    ServiceChannel.this.m_Service.debug("not free[" + ServiceChannel.this.getRequests() + "]", ServiceChannel.this.m_Channel);
                }
            }
        }
    }
}

