/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.netty;

import cn.weforward.common.DictionaryExt;
import cn.weforward.common.io.StayException;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.protocol.aio.ServerHandler;
import cn.weforward.protocol.aio.http.HttpContext;
import cn.weforward.protocol.aio.http.HttpHeaders;
import cn.weforward.protocol.aio.http.QueryStringParser;
import cn.weforward.protocol.aio.http.ResponseEndException;
import cn.weforward.protocol.aio.netty.ByteBufInput;
import cn.weforward.protocol.aio.netty.ByteBufStream;
import cn.weforward.protocol.aio.netty.CompositeByteBufStream;
import cn.weforward.protocol.aio.netty.NettyHttpHandler;
import cn.weforward.protocol.aio.netty.NettyHttpHeaders;
import cn.weforward.protocol.aio.netty.NettyOutputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpContext
implements HttpContext {
    static final Logger _Logger = LoggerFactory.getLogger(NettyHttpContext.class);
    protected NettyHttpHandler m_HttpHandler;
    protected final HttpRequest m_Request;
    protected String m_Uri;
    protected String m_QueryString;
    protected DictionaryExt<String, String> m_Params;
    protected NettyHttpHeaders m_RequestHeaders;
    protected ByteBufStream m_RequestBody;
    protected ByteBufInput m_MirrorRequestBody;
    protected ServerHandler m_Handler;
    protected NettyOutputStream m_RequestTransferTo;
    protected HttpResponseStatus m_ResponseStatus;
    protected io.netty.handler.codec.http.HttpHeaders m_ResponseHeaders;
    protected NettyOutputStream m_ResponseWriter;
    protected long m_BodyLength;
    protected long m_TransferTimepoint;
    protected int m_Bps;
    protected ScheduledFuture<?> m_ResponseTimeoutTask;
    protected int m_ResponseTimeout;
    protected int m_MaxHttpSize;

    public NettyHttpContext(NettyHttpHandler httpHandler, HttpRequest request) {
        this.m_HttpHandler = httpHandler;
        this.m_Request = request;
        this.m_Handler = ServerHandler._init;
    }

    protected void request(ServerHandler handler) {
        this.m_Handler = handler;
        ByteBufStream body = this.m_RequestBody;
        if (body != null && !(body instanceof ByteBufInput.Closed)) {
            if (this.isDebugEnabled()) {
                _Logger.info(this.formatMessage("\u5df2\u6709\u8bf7\u6c42\u4f53\uff1f" + body));
            }
            body.abort();
        }
        this.m_RequestBody = new CompositeByteBufStream(this.m_HttpHandler.getAllocator().compositeBuffer());
        handler.requestHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readable(ByteBuf data) throws IOException {
        ByteBufStream body;
        int max;
        if (data.readableBytes() == 0) {
            return;
        }
        this.m_BodyLength += (long)data.readableBytes();
        this.calcBsp();
        if (_Logger.isTraceEnabled()) {
            _Logger.trace("{len:" + data.readableBytes() + ",total:" + this.m_BodyLength + ",bps:" + this.m_Bps + "}");
        }
        if ((max = this.getMaxHttpSize()) > 0 && this.m_BodyLength > (long)max) {
            _Logger.warn(this.formatMessage("\u8bf7\u6c42\u4f53\u592a\u5927\uff1a" + this.m_BodyLength + ">" + max));
            this.responseAndClose(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE);
            return;
        }
        ByteBufInput mirror = this.m_MirrorRequestBody;
        if (mirror != null) {
            mirror.readable(data.duplicate());
        }
        NettyHttpContext nettyHttpContext = this;
        synchronized (nettyHttpContext) {
            if (this.forwardRequest(data)) {
                return;
            }
            body = this.m_RequestBody;
            if (body != null) {
                body.readable(data);
            }
        }
        ServerHandler handler = this.m_Handler;
        if (handler != null && body != null) {
            handler.prepared(body.available());
        }
    }

    private void abortRequest() {
        ByteBufStream body;
        if (this.isDebugEnabled()) {
            _Logger.info(this.formatMessage("abortRequest"));
        }
        if ((body = this.m_RequestBody) != null) {
            body.abort();
        }
        this.m_RequestBody = ByteBufInput._aborted;
        if (this.m_MirrorRequestBody != null) {
            this.m_MirrorRequestBody.end();
            this.m_MirrorRequestBody = null;
        }
        if (this.m_RequestTransferTo != null) {
            try {
                this.m_RequestTransferTo.cancel();
                this.m_RequestTransferTo = null;
            }
            catch (IOException e) {
                _Logger.warn(String.valueOf(this.m_RequestTransferTo), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestCompleted() {
        NettyHttpContext nettyHttpContext = this;
        synchronized (nettyHttpContext) {
            if (this.isRespond()) {
                this.abortRequest();
                return;
            }
            this.m_RequestTransferTo = null;
            if (this.m_RequestBody == null) {
                this.m_RequestBody = ByteBufInput._completed;
            } else {
                this.m_RequestBody.completed();
            }
            if (this.m_MirrorRequestBody != null) {
                this.m_MirrorRequestBody.completed();
                this.m_MirrorRequestBody = null;
            }
        }
        this.m_Handler.requestCompleted();
    }

    protected synchronized void responding() throws IOException {
        if (this.isClosed() || this.isResponded()) {
            throw new ResponseEndException("\u5df2\u54cd\u5e94/\u5173\u95ed");
        }
        ByteBufStream body = this.m_RequestBody;
        if (body == null || !body.isCompleted()) {
            this.abortRequest();
        }
        this.m_ResponseWriter = NettyOutputStream._pending;
        this.m_TransferTimepoint = System.currentTimeMillis();
        this.m_BodyLength = 0L;
        ScheduledFuture<?> task = this.m_ResponseTimeoutTask;
        if (task != null) {
            this.m_ResponseTimeoutTask = null;
            task.cancel(false);
        }
    }

    private synchronized void respond(LastHttpContent msg) throws IOException {
        ByteBuf content = msg.content();
        try {
            if (this.isClosed() || this.isResponded()) {
                throw new IOException("\u65e9\u5df2\u7ed3\u675f");
            }
            if (this.isDebugEnabled()) {
                _Logger.info(this.formatMessage("respond"));
            }
            this.m_ResponseWriter = NettyOutputStream._end;
            this.m_HttpHandler.respond(this);
            ChannelFuture future = this.m_HttpHandler.writeAndFlush(msg);
            content = null;
            future.addListener(this.getEndListener());
        }
        finally {
            if (content != null) {
                content.release();
            }
        }
    }

    protected void responseTimeout() {
        if (this.isDebugEnabled()) {
            _Logger.info(this.formatMessage("Respond timeout"));
        }
        try {
            this.m_Handler.responseTimeout();
        }
        finally {
            if (!this.isRespond()) {
                this.responseAndClose(HttpResponseStatus.ACCEPTED);
            }
        }
    }

    protected void inactive() {
        if (this.isDebugEnabled()) {
            _Logger.info(this.formatMessage("inactive"));
        }
        this.end();
    }

    private boolean isDebugEnabled() {
        NettyHttpHandler hh = this.m_HttpHandler;
        return hh != null && hh.isDebugEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void end() {
        try {
            ServerHandler handler;
            if (this.isDebugEnabled()) {
                _Logger.info(this.formatMessage("end"));
            }
            NettyHttpContext nettyHttpContext = this;
            synchronized (nettyHttpContext) {
                block12: {
                    handler = this.m_Handler;
                    if (handler != null) break block12;
                    return;
                }
                this.m_Handler = null;
            }
            if (this.isResponded()) {
                handler.responseCompleted();
            } else {
                if (this.isDebugEnabled()) {
                    _Logger.info(this.formatMessage("requestAbort"));
                }
                handler.requestAbort();
            }
        }
        finally {
            this.cleanup();
        }
    }

    protected synchronized void cleanup() {
        NettyOutputStream out;
        ByteBufStream body;
        this.m_Handler = null;
        if (this.m_MirrorRequestBody != null) {
            this.m_MirrorRequestBody = null;
        }
        if ((body = this.m_RequestBody) != null) {
            body.abort();
            this.m_RequestBody = null;
        }
        if ((out = this.m_ResponseWriter) != null) {
            try {
                this.m_ResponseWriter = null;
                out.cancel();
            }
            catch (Exception e) {
                _Logger.warn(String.valueOf(out), (Throwable)e);
            }
        }
        if ((out = this.m_RequestTransferTo) != null) {
            try {
                this.m_RequestTransferTo = null;
                out.cancel();
            }
            catch (Exception e) {
                _Logger.warn(String.valueOf(out), (Throwable)e);
            }
        }
    }

    private boolean isResponded() {
        return NettyOutputStream._end == this.m_ResponseWriter;
    }

    @Override
    public boolean isRespond() {
        return NettyOutputStream._pending == this.m_ResponseWriter || NettyOutputStream._end == this.m_ResponseWriter;
    }

    private boolean isClosed() {
        return this.m_Handler == null || this.m_HttpHandler == null;
    }

    private void ensureRequestStream() throws IOException {
        if (this.m_ResponseWriter != null) {
            throw new IOException("\u8c03\u7528\u5728\u54cd\u5e94\u6216\u5df2\u7ed3\u675f");
        }
        if (this.m_RequestTransferTo != null) {
            throw new IOException("\u5df2\u8bbe\u4e3a\u8f6c\u4f20");
        }
        if (this.isClosed()) {
            throw new EOFException("\u8c03\u7528\u5df2\u5173\u95ed");
        }
    }

    private void calcBsp() {
        long ts = System.currentTimeMillis() - this.m_TransferTimepoint;
        if (ts > 0L) {
            this.m_Bps = (int)(this.m_BodyLength * 1000L / ts);
        }
    }

    private boolean forwardRequest(ByteBuf data) {
        NettyOutputStream out = this.m_RequestTransferTo;
        if (out == null) {
            return false;
        }
        ServerHandler handler = this.m_Handler;
        try {
            out.write(data);
            return true;
        }
        catch (Exception e) {
            this.m_HttpHandler.close();
            if (handler == null) {
                try {
                    out.cancel();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                _Logger.error(out.toString(), (Throwable)e);
            } else if (e instanceof IOException) {
                handler.errorRequestTransferTo((IOException)e, data, out);
            } else {
                handler.errorRequestTransferTo(new IOException(e), data, out);
            }
            return false;
        }
    }

    private io.netty.handler.codec.http.HttpHeaders openResponseHeaders() {
        io.netty.handler.codec.http.HttpHeaders headers = this.m_ResponseHeaders;
        if (headers == null) {
            this.m_ResponseHeaders = headers = new DefaultHttpHeaders();
        }
        return headers;
    }

    @Override
    public int bps() {
        return this.m_Bps;
    }

    @Override
    public String getMethod() {
        if (this.m_Request == null) {
            return null;
        }
        return this.m_Request.method().name();
    }

    @Override
    public String getVerb() {
        return this.getMethod();
    }

    @Override
    public DictionaryExt<String, String> getParams() {
        if (this.m_Params != null) {
            return this.m_Params;
        }
        this.m_Params = QueryStringParser.toParams(this.m_QueryString, QueryStringParser.UTF_8);
        return this.m_Params;
    }

    @Override
    public String getUri() {
        String uri = this.m_Uri;
        if (uri == null) {
            if (this.m_Request == null) {
                return null;
            }
            uri = this.m_Request.uri();
            int idx = uri.indexOf(63);
            if (idx >= 0) {
                this.m_QueryString = uri.substring(idx + 1);
                uri = uri.substring(0, idx);
            } else {
                this.m_QueryString = "";
            }
            this.m_Uri = uri;
        }
        return uri;
    }

    @Override
    public String getQueryString() {
        if ("" == this.m_QueryString) {
            return this.m_QueryString;
        }
        this.getUri();
        return this.m_QueryString;
    }

    @Override
    public String getRemoteAddr() {
        return this.m_HttpHandler == null ? null : this.m_HttpHandler.getRemoteAddr();
    }

    @Override
    public HttpHeaders getRequestHeaders() {
        if (this.m_RequestHeaders == null && this.m_Request != null) {
            this.m_RequestHeaders = new NettyHttpHeaders(this.m_Request.headers());
        }
        return this.m_RequestHeaders;
    }

    @Override
    public synchronized void requestTransferTo(OutputStream writer, int skipBytes) throws IOException {
        this.ensureRequestStream();
        if (!(this.m_RequestBody instanceof CompositeByteBufStream)) {
            throw new IOException("\u53ea\u80fd\u5728getRequestStream\u524d\u4f7f\u7528");
        }
        CompositeByteBufStream bufStream = (CompositeByteBufStream)this.m_RequestBody;
        int readableBytes = bufStream.available();
        if (skipBytes > 0) {
            if (skipBytes > readableBytes) {
                throw new IOException("\u8d85\u8fc7\u8303\u56f4" + skipBytes + ">" + readableBytes);
            }
            bufStream.skipBytes(skipBytes);
        }
        this.m_RequestTransferTo = NettyOutputStream.wrap(writer);
        ByteBuf buf = bufStream.detach();
        if (buf != null) {
            try {
                this.m_RequestBody = this.m_RequestBody.isCompleted() ? ByteBufInput._completed : null;
                this.forwardRequest(buf);
            }
            finally {
                buf.release();
            }
        }
    }

    @Override
    public synchronized InputStream mirrorRequestStream(int skipBytes) throws IOException {
        this.ensureRequestStream();
        ByteBufStream body = this.m_RequestBody;
        if (!(body instanceof CompositeByteBufStream)) {
            throw new IOException("\u53ea\u80fd\u5728getRequestStream\u524d\u8c03\u7528mirrorRequestStream");
        }
        if (this.m_MirrorRequestBody != null) {
            if (skipBytes > 0) {
                throw new IOException("\u4e0d\u80fd\u91cd\u590d\u6307\u5b9askipBytes\u83b7\u53d6mirrorRequestStream");
            }
            return this.m_MirrorRequestBody;
        }
        this.m_MirrorRequestBody = ((CompositeByteBufStream)body).toStream(skipBytes);
        return this.m_MirrorRequestBody;
    }

    @Override
    public synchronized InputStream getRequestStream() throws IOException {
        this.ensureRequestStream();
        ByteBufStream body = this.m_RequestBody;
        if (body instanceof CompositeByteBufStream) {
            CompositeByteBufStream bufStream = (CompositeByteBufStream)body;
            ByteBufInput stream = bufStream.detachToStream();
            this.m_RequestBody = stream;
            return stream;
        }
        return (ByteBufInput)body;
    }

    @Override
    public synchronized InputStream duplicateRequestStream() throws IOException {
        this.ensureRequestStream();
        ByteBufStream body = this.m_RequestBody;
        if (!(body instanceof CompositeByteBufStream)) {
            throw new IOException("\u53ea\u80fd\u5728getRequestStream\u524d\u4f7f\u7528");
        }
        return ((CompositeByteBufStream)body).snapshot();
    }

    @Override
    public boolean isRequestCompleted() {
        ByteBufStream body = this.m_RequestBody;
        return body != null && body.isCompleted();
    }

    @Override
    public void setResponseTimeout(int millis) {
        if (millis == this.m_ResponseTimeout && this.m_ResponseTimeoutTask != null) {
            return;
        }
        if (this.m_ResponseTimeoutTask != null) {
            this.m_ResponseTimeoutTask.cancel(false);
            this.m_ResponseTimeoutTask = null;
        }
        if (Integer.MAX_VALUE == millis) {
            millis = this.m_HttpHandler.getIdleMillis();
        }
        this.m_ResponseTimeout = millis;
        if (this.m_HttpHandler != null && millis > 0) {
            this.m_ResponseTimeoutTask = this.m_HttpHandler.schedule(new ResponseTimeoutChecker(), millis, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void setMaxHttpSize(int size) {
        this.m_MaxHttpSize = size;
    }

    public int getMaxHttpSize() {
        if (this.m_MaxHttpSize > 0) {
            return this.m_MaxHttpSize;
        }
        return this.m_HttpHandler.getMaxHttpSize();
    }

    @Override
    public void setResponseHeader(String name, String value) throws IOException {
        if (value != null) {
            this.openResponseHeaders().set(name, (Object)value);
        } else {
            io.netty.handler.codec.http.HttpHeaders headers = this.m_ResponseHeaders;
            if (headers != null) {
                headers.remove(name);
            }
        }
    }

    @Override
    public synchronized OutputStream openResponseWriter(int statusCode, String reasonPhrase) throws IOException {
        if (this.isClosed()) {
            throw new ResponseEndException("\u5df2\u5173\u95ed");
        }
        if (this.m_ResponseWriter != null) {
            if (this.isRespond()) {
                throw new ResponseEndException("\u5df2\u54cd\u5e94");
            }
            throw new IOException("\u4e0d\u80fd\u91cd\u590d\u6253\u5f00\u54cd\u5e94\u8f93\u51fa\u6d41\uff1a" + this.m_ResponseWriter);
        }
        if (reasonPhrase != null) {
            this.m_ResponseStatus = new HttpResponseStatus(statusCode, reasonPhrase);
        } else if (this.m_ResponseStatus == null || this.m_ResponseStatus.code() != statusCode) {
            this.m_ResponseStatus = HttpResponseStatus.valueOf((int)statusCode);
        }
        this.m_ResponseWriter = new ResponseOutput();
        return this.m_ResponseWriter;
    }

    @Override
    public synchronized void response(int statusCode, byte[] content) throws IOException {
        if (this.isClosed()) {
            throw new ResponseEndException("\u5df2\u5173\u95ed");
        }
        if (this.isRespond()) {
            throw new ResponseEndException("\u5df2\u54cd\u5e94");
        }
        if (this.m_ResponseStatus == null || statusCode != this.m_ResponseStatus.code()) {
            this.m_ResponseStatus = HttpResponseStatus.valueOf((int)statusCode);
        }
        if (RESPONSE_AND_CLOSE == content) {
            this.responseAndClose(this.m_ResponseStatus);
            return;
        }
        if (content == null) {
            this.response(null);
            return;
        }
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])content);
        try {
            this.response(buf);
        }
        finally {
            buf.release();
        }
    }

    private void responseAndClose(HttpResponseStatus status) {
        if (!this.isRespond() && !this.isClosed()) {
            this.m_HttpHandler.responseAndClose(status, this.m_ResponseHeaders);
        }
    }

    private synchronized void response(ByteBuf content) throws IOException {
        DefaultFullHttpResponse msg;
        HttpVersion httpVersion = this.m_Request.protocolVersion();
        io.netty.handler.codec.http.HttpHeaders headers = this.openResponseHeaders();
        this.responding();
        if (content != null) {
            headers.set(HttpHeaderNames.CONTENT_LENGTH.toString(), (Object)String.valueOf(content.readableBytes()));
            msg = new DefaultFullHttpResponse(httpVersion, this.m_ResponseStatus, content.retain(), headers, (io.netty.handler.codec.http.HttpHeaders)EmptyHttpHeaders.INSTANCE);
        } else {
            headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)HttpHeaderValues.ZERO);
            msg = new DefaultFullHttpResponse(httpVersion, this.m_ResponseStatus, Unpooled.buffer((int)0), headers, (io.netty.handler.codec.http.HttpHeaders)EmptyHttpHeaders.INSTANCE);
        }
        this.respond((LastHttpContent)msg);
    }

    @Override
    public void disconnect() {
        if (this.m_HttpHandler != null) {
            this.m_HttpHandler.close();
            this.m_HttpHandler = null;
        }
        this.cleanup();
    }

    private GenericFutureListener<Future<Void>> getEndListener() {
        return new GenericFutureListener<Future<Void>>(){

            public void operationComplete(Future<Void> future) throws Exception {
                NettyHttpHandler hh = null;
                if (!NettyHttpContext.this.isRequestCompleted()) {
                    hh = NettyHttpContext.this.m_HttpHandler;
                }
                NettyHttpContext.this.end();
                if (hh != null) {
                    hh.close();
                }
            }
        };
    }

    private String formatMessage(String caption) {
        StringBuilder sb = StringBuilderPool._128.poll();
        try {
            if (caption != null) {
                sb.append(caption);
            }
            this.toString(sb);
            String string = sb.toString();
            return string;
        }
        finally {
            StringBuilderPool._128.offer(sb);
        }
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("{hash:").append(this.hashCode());
        sb.append(",state:");
        if (this.isClosed()) {
            sb.append("closed");
        } else if (this.isResponded()) {
            sb.append("responded");
        } else if (this.isRespond()) {
            sb.append("respond");
        } else if (this.isRequestCompleted()) {
            sb.append("requested");
        } else {
            sb.append("head");
        }
        if (this.m_BodyLength > 0L) {
            sb.append(",body-len:").append(this.m_BodyLength);
        }
        if (this.m_Bps > 0) {
            sb.append(",bps:").append(this.m_Bps);
        }
        sb.append("}");
        NettyHttpHandler hh = this.m_HttpHandler;
        if (hh != null) {
            hh.toString(sb);
        }
        return sb;
    }

    public String toString() {
        StringBuilder sb = StringBuilderPool._128.poll();
        try {
            String string = this.toString(sb).toString();
            return string;
        }
        finally {
            StringBuilderPool._128.offer(sb);
        }
    }

    class ResponseOutput
    extends NettyOutputStream.Stay {
        ResponseOutput() {
        }

        protected void sendResponse(ByteBuf content, boolean isFinal) throws IOException {
            if (!this.isHead()) {
                if (isFinal) {
                    NettyHttpContext.this.response(content);
                    return;
                }
                io.netty.handler.codec.http.HttpHeaders headers = NettyHttpContext.this.openResponseHeaders();
                HttpVersion httpVersion = NettyHttpContext.this.m_Request.protocolVersion();
                headers.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
                DefaultHttpResponse msg = new DefaultHttpResponse(httpVersion, NettyHttpContext.this.m_ResponseStatus, NettyHttpContext.this.m_ResponseHeaders);
                NettyHttpContext.this.responding();
                NettyHttpContext.this.m_HttpHandler.write(msg);
                if (content == null) {
                    return;
                }
            }
            if (isFinal) {
                Object hc = content != null ? new DefaultLastHttpContent(content.retain()) : LastHttpContent.EMPTY_LAST_CONTENT;
                NettyHttpContext.this.respond(hc);
                return;
            }
            NettyHttpContext.this.m_HttpHandler.write(content.retain());
        }

        private boolean isHead() {
            return this != NettyHttpContext.this.m_ResponseWriter;
        }

        public void stay() throws StayException {
            if (NettyHttpContext.this.isRespond() || NettyHttpContext.this.isClosed()) {
                throw new StayException("\u5df2\u54cd\u5e94/\u5173\u95ed");
            }
            if (this.isHead()) {
                throw new StayException("\u5df2\u8f93\u51faHTTP\u5934");
            }
            this.m_StayBuffers = NettyHttpContext.this.m_HttpHandler.getAllocator().compositeBuffer();
        }

        @Override
        public boolean isOpen() {
            return NettyHttpContext.this.m_HttpHandler != null && (this == NettyHttpContext.this.m_ResponseWriter || NettyOutputStream._pending == NettyHttpContext.this.m_ResponseWriter);
        }

        @Override
        protected ByteBuf allocBuffer(int len) {
            return NettyHttpContext.this.m_HttpHandler.getAllocator().buffer(len);
        }

        @Override
        protected void flush(ByteBuf buffer) throws IOException {
            this.sendResponse(buffer, false);
        }

        @Override
        public synchronized void close() throws IOException {
            this.ensureOpen();
            try {
                this.flush();
                this.sendResponse(this.m_Last, true);
            }
            finally {
                this.cleanup();
            }
        }

        public synchronized void cancel() throws IOException {
            this.cleanup();
            if (NettyOutputStream._pending == NettyHttpContext.this.m_ResponseWriter || this == NettyHttpContext.this.m_ResponseWriter) {
                NettyHttpContext.this.disconnect();
            }
        }
    }

    class ResponseTimeoutChecker
    implements Runnable {
        ResponseTimeoutChecker() {
        }

        @Override
        public void run() {
            long interval;
            try {
                int timeout = NettyHttpContext.this.m_ResponseTimeout;
                if (timeout <= 0 || NettyHttpContext.this.m_TransferTimepoint <= 0L) {
                    return;
                }
                interval = System.currentTimeMillis() - NettyHttpContext.this.m_TransferTimepoint;
                if (interval >= (long)timeout) {
                    NettyHttpContext.this.responseTimeout();
                    return;
                }
                interval = (long)timeout - interval;
            }
            finally {
                NettyHttpContext.this.m_ResponseTimeoutTask = null;
            }
            if (_Logger.isTraceEnabled()) {
                _Logger.trace(NettyHttpContext.this.formatMessage("response-check(" + interval + "ms)"));
            }
            NettyHttpContext.this.m_ResponseTimeoutTask = NettyHttpContext.this.m_HttpHandler.schedule(this, interval, TimeUnit.MILLISECONDS);
        }
    }
}

