/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.netty;

import cn.weforward.common.util.NumberUtil;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.protocol.aio.ServerHandler;
import cn.weforward.protocol.aio.netty.NettyHttpContext;
import cn.weforward.protocol.aio.netty.NettyHttpServer;
import cn.weforward.protocol.aio.netty.websocket.WebSocketContext;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.OutOfDirectMemoryError;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpHandler
extends ChannelInboundHandlerAdapter {
    static final Logger _Logger = LoggerFactory.getLogger(NettyHttpHandler.class);
    protected final NettyHttpServer m_Server;
    protected volatile int m_Reuse;
    protected ChannelHandlerContext m_Ctx;
    protected NettyHttpContext m_HttpContext;
    protected String m_RemoteAddr;
    protected long m_BpsTotal;
    protected int m_BpsTimes;
    protected ScheduledFuture<?> m_IdleTask;

    public NettyHttpHandler(NettyHttpServer server) {
        this.m_Server = server;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.stopIdleTask();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            NettyHttpContext hc;
            if (this.m_Ctx != null && ctx != this.m_Ctx) {
                _Logger.error(this.formatMessage("\u4e0d\u4e00\u6837\u7684Context\uff1f" + this.m_Ctx + "!=" + ctx));
                ctx.close();
                return;
            }
            if (msg instanceof HttpRequest) {
                if (this.m_HttpContext == null) {
                    if (!this.requestHeader((HttpRequest)msg)) {
                        return;
                    }
                } else if (msg != this.m_HttpContext.m_Request) {
                    _Logger.warn(this.formatMessage("\u53d1\u751f\u4ec0\u4e48\u60c5\u51b5\uff01\u4e0a\u4e2a\u8c03\u7528\u672a\u5b8c\u6210\uff1f " + msg));
                    ctx.close();
                    return;
                }
            }
            if ((hc = this.m_HttpContext) != null && msg instanceof HttpContent) {
                hc.readable(((HttpContent)msg).content());
            }
            if (hc != null && msg instanceof LastHttpContent) {
                hc.requestCompleted();
            }
            if (this.isDebugEnabled() && hc == null) {
                _Logger.warn(this.formatMessage("\u8c03\u7528\u63d0\u524d\u7ed3\u675f/\u54cd\u5e94\uff1f" + msg));
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.isDebugEnabled()) {
            _Logger.info(this.formatMessage("channelActive"));
        }
        this.m_Reuse = 0;
        this.m_Ctx = ctx;
        this.startIdleTask(ctx);
        InetSocketAddress ip = (InetSocketAddress)ctx.channel().remoteAddress();
        this.m_RemoteAddr = String.valueOf(ip.getAddress().getHostAddress()) + ':' + ip.getPort();
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.isDebugEnabled()) {
            _Logger.info(this.formatMessage("channelInactive"));
        }
        try {
            NettyHttpContext hc = this.m_HttpContext;
            if (hc != null) {
                this.m_HttpContext = null;
                hc.inactive();
            }
            this.m_Ctx = null;
            this.stopIdleTask();
        }
        finally {
            super.channelInactive(ctx);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof OutOfDirectMemoryError || cause instanceof OutOfMemoryError) {
            ctx.close();
            if (this.m_Server.getUptime() > 43200) {
                _Logger.error("restart " + this.m_Server, cause);
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        NettyHttpHandler.this.m_Server.restart();
                    }
                };
                thread.setDaemon(true);
                thread.start();
            }
        }
        if (this.isDebugEnabled()) {
            _Logger.warn(this.toString(), cause);
        }
        super.exceptionCaught(ctx, cause);
    }

    private boolean requestHeader(HttpRequest request) throws IOException {
        String upgrade;
        int length;
        ++this.m_Reuse;
        if (this.isDebugEnabled()) {
            _Logger.info(this.formatMessage("requestHeader"));
        }
        HttpHeaders headers = request.headers();
        int max = this.getMaxHttpSize();
        if (max > 0 && headers != null && (length = NumberUtil.toInt((String)headers.get("Content-Length"), (int)0)) > max) {
            _Logger.warn(this.formatMessage("\u8bf7\u6c42\u4f53\u592a\u5927\uff1a" + length + ">" + max));
            this.responseAndClose(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, null);
            return false;
        }
        WebSocketServerHandshakerFactory wsFactory = this.m_Server.getWebSocketFactory();
        if (wsFactory != null && "websocket".equals(upgrade = headers.get("Upgrade"))) {
            WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(request);
            if (handshaker == null) {
                this.responseAndClose(HttpResponseStatus.UPGRADE_REQUIRED, null);
                return false;
            }
            ChannelFuture future = handshaker.handshake(this.m_Ctx.channel(), request);
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        NettyHttpHandler.this.m_Ctx.fireExceptionCaught(future.cause());
                        return;
                    }
                    ChannelPipeline pl = future.channel().pipeline();
                    pl.remove((ChannelHandler)NettyHttpHandler.this);
                    WebSocketContext handler = new WebSocketContext(NettyHttpHandler.this.m_Server.getHandlerFactory());
                    pl.addLast("ws-ctx", (ChannelHandler)handler);
                    handler.setKeepalive(NettyHttpHandler.this.m_Server.getWebSocketKeepalive());
                }
            });
            return false;
        }
        this.m_HttpContext = new NettyHttpContext(this, request);
        ServerHandler handler = null;
        try {
            handler = this.m_Server.handle(this.m_HttpContext);
        }
        finally {
            if (handler == null) {
                if (this.isRespond()) {
                    return false;
                }
                this.responseAndClose(HttpResponseStatus.NOT_IMPLEMENTED, null);
                return false;
            }
        }
        this.m_HttpContext.request(handler);
        return true;
    }

    private boolean isRespond() {
        return this.m_HttpContext == null;
    }

    public void respond(NettyHttpContext hc) {
        if (hc == this.m_HttpContext) {
            this.m_HttpContext = null;
            this.startIdleTask(this.m_Ctx);
            int bps = hc.bps();
            if (bps > 0) {
                this.m_BpsTotal += (long)bps;
                ++this.m_BpsTimes;
            }
        }
        if (this.isDebugEnabled()) {
            _Logger.info(this.formatMessage("respond"));
        }
    }

    public int bps() {
        if (this.m_BpsTotal < 1L) {
            return 0;
        }
        return (int)(this.m_BpsTotal / (long)this.m_BpsTimes);
    }

    public int getMaxHttpSize() {
        return this.m_Server.getMaxHttpSize();
    }

    public boolean isDebugEnabled() {
        return this.m_Server.isDebugEnabled();
    }

    public void close() {
        ChannelHandlerContext ctx = this.m_Ctx;
        if (ctx != null) {
            this.m_Ctx = null;
            ctx.close();
        }
    }

    protected void responseAndClose(HttpResponseStatus status, HttpHeaders responseHeaders) {
        this.responseAndClose(status, HttpVersion.HTTP_1_0, responseHeaders);
    }

    private void responseAndClose(HttpResponseStatus status, HttpVersion httpVersion, HttpHeaders responseHeaders) {
        NettyHttpContext hc = this.m_HttpContext;
        try {
            this.m_HttpContext = null;
            DefaultFullHttpResponse msg = responseHeaders == null ? new DefaultFullHttpResponse(httpVersion, status) : new DefaultFullHttpResponse(httpVersion, status, Unpooled.buffer((int)0), responseHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            HttpHeaders headers = msg.headers();
            headers.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)HttpHeaderValues.ZERO);
            this.m_Ctx.writeAndFlush((Object)msg).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ChannelHandlerContext ctx = NettyHttpHandler.this.m_Ctx;
                    if (ctx != null) {
                        ctx.close();
                    }
                }
            });
        }
        finally {
            if (hc != null) {
                hc.cleanup();
            }
        }
    }

    protected void idleTimeout() {
        if (!this.isRespond()) {
            _Logger.warn(this.formatMessage("Idle timeout(not respond)"));
        } else if (this.isDebugEnabled()) {
            _Logger.info(this.formatMessage("Idle timeout"));
        }
        this.close();
    }

    private void startIdleTask(ChannelHandlerContext ctx) {
        this.stopIdleTask();
        int timeout = this.getIdleMillis();
        if (timeout <= 0) {
            return;
        }
        if (ctx == null || ctx.channel() == null || !ctx.channel().isActive()) {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug(this.formatMessage("\u4e0d\u5177\u6761\u4ef6\u542f\u52a8HTTP\u8fde\u63a5\u7a7a\u95f2\u68c0\u67e5"));
            }
            return;
        }
        this.m_IdleTask = ctx.executor().schedule((Runnable)new IdleChecker(), (long)timeout, TimeUnit.MILLISECONDS);
    }

    private void stopIdleTask() {
        if (this.m_IdleTask == null) {
            return;
        }
        this.m_IdleTask.cancel(false);
        this.m_IdleTask = null;
    }

    private String formatMessage(String caption) {
        StringBuilder builder = StringBuilderPool._8k.poll();
        try {
            if (caption != null) {
                builder.append(caption);
            }
            this.toString(builder);
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderPool._8k.offer(builder);
        }
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("{").append(this.m_Server.getName()).append(":");
        if (this.m_HttpContext != null) {
            sb.append("request");
        } else {
            sb.append("idle");
        }
        sb.append(",reuse:").append(this.m_Reuse);
        int bps = this.bps();
        if (bps > 0) {
            sb.append(",bps:").append(bps);
        }
        if (this.m_RemoteAddr != null) {
            sb.append(",ip:").append(this.m_RemoteAddr);
        }
        sb.append("}");
        return sb;
    }

    public String toString() {
        StringBuilder builder = StringBuilderPool._8k.poll();
        try {
            String string = this.toString(builder).toString();
            return string;
        }
        finally {
            StringBuilderPool._8k.offer(builder);
        }
    }

    public ByteBufAllocator getAllocator() {
        if (this.m_Ctx != null) {
            return this.m_Ctx.alloc();
        }
        return ByteBufAllocator.DEFAULT;
    }

    public String getRemoteAddr() {
        return this.m_RemoteAddr;
    }

    public int getIdleMillis() {
        return this.m_Server.getIdleMillis();
    }

    public void write(Object msg) {
        this.m_Ctx.write(msg);
    }

    public ChannelFuture writeAndFlush(Object msg) {
        return this.m_Ctx.writeAndFlush(msg);
    }

    public ScheduledFuture<?> schedule(Runnable runnable, long delay, TimeUnit unit) {
        ChannelHandlerContext ctx = this.m_Ctx;
        if (ctx == null) {
            throw new IllegalStateException(this.formatMessage("inactived"));
        }
        return ctx.executor().schedule(runnable, delay, unit);
    }

    class IdleChecker
    implements Runnable {
        IdleChecker() {
        }

        @Override
        public void run() {
            try {
                if (!NettyHttpHandler.this.isRespond()) {
                    NettyHttpHandler.this.schedule(this, NettyHttpHandler.this.getIdleMillis(), TimeUnit.MILLISECONDS);
                    return;
                }
                NettyHttpHandler.this.idleTimeout();
            }
            finally {
                NettyHttpHandler.this.m_IdleTask = null;
            }
        }
    }
}

