/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.netty;

import cn.weforward.common.util.NumberUtil;
import cn.weforward.common.util.StringBuilderPool;
import cn.weforward.protocol.aio.ServerHandler;
import cn.weforward.protocol.aio.ServerHandlerFactory;
import cn.weforward.protocol.aio.http.HttpContext;
import cn.weforward.protocol.aio.netty.NettyHttpHandler;
import cn.weforward.protocol.aio.netty.NettyMemMonitor;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentEncoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpServer {
    public static final Logger _Logger = LoggerFactory.getLogger(NettyHttpServer.class);
    protected String m_Name;
    protected int m_Port;
    protected int m_Backlog;
    protected int m_AcceptThreads;
    protected int m_WorkThreads;
    protected String m_KeepAlive;
    protected int m_MaxHttpSize = 0x400000;
    protected boolean m_GzipEnabled = false;
    protected int m_GzipMinSize = 512;
    protected boolean m_DebugEnabled = false;
    protected int m_IdleMillis = 600000;
    protected int m_WebSocketKeepalive;
    protected long m_StartTime;
    protected volatile Channel m_Channel;
    protected ServerHandlerFactory m_HandlerFactory = ServerHandlerFactory._unassigned;
    protected WebSocketServerHandshakerFactory m_WebSocketFactory;

    public NettyHttpServer(int port) {
        this.m_Port = port;
        this.m_AcceptThreads = 1;
        this.m_WorkThreads = NettyRuntime.availableProcessors();
        if (this.m_WorkThreads < 2) {
            this.m_WorkThreads = 2;
        } else if (this.m_WorkThreads > 4) {
            this.m_WorkThreads = 4;
        }
    }

    public void setName(String name) {
        this.m_Name = name;
    }

    public void setBacklog(int backlog) {
        this.m_Backlog = backlog;
    }

    public void setDebugEnabled(boolean enabled) {
        this.m_DebugEnabled = enabled;
    }

    public boolean isDebugEnabled() {
        return this.m_DebugEnabled;
    }

    public synchronized void setAcceptThreads(int maxThreads) {
        if (maxThreads == this.m_AcceptThreads) {
            return;
        }
        this.m_AcceptThreads = maxThreads;
        if (this.isRunning()) {
            this.restart();
        }
    }

    public synchronized void setWorkThreads(int maxThreads) {
        if (maxThreads == this.m_WorkThreads) {
            return;
        }
        this.m_WorkThreads = maxThreads;
        if (this.isRunning()) {
            this.restart();
        }
    }

    public String getName() {
        return this.m_Name;
    }

    public int getPort() {
        return this.m_Port;
    }

    public void setKeepAlive(String keepAlive) {
        this.m_KeepAlive = keepAlive;
    }

    public String getKeepAlive() {
        return this.m_KeepAlive;
    }

    public void setMaxHttpSize(int maxHttpSize) {
        this.m_MaxHttpSize = maxHttpSize;
    }

    public int getMaxHttpSize() {
        return this.m_MaxHttpSize;
    }

    public boolean isRunning() {
        return this.m_Channel != null;
    }

    public void setGzipEnabled(boolean enabled) {
        this.m_GzipEnabled = enabled;
    }

    public boolean isGzipEnabled() {
        return this.m_GzipEnabled;
    }

    public void setGzipMinSize(int minSize) {
        this.m_GzipMinSize = minSize;
    }

    public void setHandlerFactory(ServerHandlerFactory factory) {
        this.m_HandlerFactory = factory;
    }

    public ServerHandlerFactory getHandlerFactory() {
        return this.m_HandlerFactory;
    }

    public void setIdle(int secs) {
        this.m_IdleMillis = secs * 1000;
    }

    public int getIdleMillis() {
        return this.m_IdleMillis;
    }

    public int getUptime() {
        return (int)((System.currentTimeMillis() - this.m_StartTime) / 1000L);
    }

    public void setWebSocketKeepalive(int secs) {
        this.m_WebSocketKeepalive = secs;
    }

    public int getWebSocketKeepalive() {
        return this.m_WebSocketKeepalive;
    }

    public void setWebSocket(String uri) {
        if (uri == null || uri.length() == 0) {
            this.m_WebSocketFactory = null;
            return;
        }
        if (this.m_WebSocketFactory == null) {
            this.m_WebSocketFactory = new WebSocketServerHandshakerFactory(uri, null, false);
        }
    }

    public boolean close() {
        Channel channel = this.m_Channel;
        if (channel == null) {
            return false;
        }
        _Logger.info("closing...");
        try {
            channel.close().sync();
        }
        catch (InterruptedException e) {
            _Logger.warn("close execption", (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        NettyHttpServer nettyHttpServer = this;
        synchronized (nettyHttpServer) {
            this.close();
            this.start();
        }
    }

    public synchronized boolean start() {
        if (this.m_Channel != null) {
            return true;
        }
        _Logger.info("starting... ");
        String name = this.getName();
        name = name != null && name.length() > 0 ? "at" : String.valueOf(name) + "-at";
        DefaultThreadFactory acceptorThreadFactory = new DefaultThreadFactory(name);
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(this.m_AcceptThreads, (ThreadFactory)acceptorThreadFactory);
        name = this.getName();
        name = name != null && name.length() > 0 ? "wk" : String.valueOf(name) + "-wk";
        DefaultThreadFactory workThreadFactory = new DefaultThreadFactory(name, true);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(this.m_WorkThreads, (ThreadFactory)workThreadFactory);
        ServerBootstrap boot = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)boot.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new Initializer()).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true);
        if (this.m_Backlog > 0) {
            boot.option(ChannelOption.SO_BACKLOG, (Object)this.m_Backlog);
            _Logger.info("set backlog=" + this.m_Backlog);
        }
        try {
            ChannelFuture f = boot.bind(this.m_Port).sync();
            _Logger.info("started " + this);
            this.m_Channel = f.channel();
            this.m_Channel.closeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup){
                private final /* synthetic */ EventLoopGroup val$bossGroup;
                private final /* synthetic */ EventLoopGroup val$workerGroup;
                {
                    this.val$bossGroup = eventLoopGroup;
                    this.val$workerGroup = eventLoopGroup2;
                }

                public void operationComplete(Future<Void> future) throws Exception {
                    _Logger.info("closed " + NettyHttpServer.this);
                    NettyHttpServer.this.m_Channel = null;
                    this.val$bossGroup.shutdownGracefully();
                    this.val$workerGroup.shutdownGracefully();
                }
            });
            this.m_StartTime = System.currentTimeMillis();
            NettyMemMonitor.getInstance();
            return true;
        }
        catch (InterruptedException e) {
            _Logger.error("Bind server socket failed! " + this, (Throwable)e);
            return false;
        }
    }

    public void run() {
        if (!this.start()) {
            return;
        }
        try {
            this.m_Channel.closeFuture().sync();
        }
        catch (InterruptedException e) {
            _Logger.error("Interrupted! " + this, (Throwable)e);
        }
        _Logger.info("Done. " + this);
    }

    public String toString() {
        StringBuilder builder = StringBuilderPool._128.poll();
        try {
            String string = this.toString(builder).toString();
            return string;
        }
        finally {
            StringBuilderPool._128.offer(builder);
        }
    }

    public StringBuilder toString(StringBuilder builder) {
        builder.append("{port:").append(this.m_Port);
        String name = this.getName();
        if (name != null && name.length() > 0) {
            builder.append(",name:").append(name);
        }
        builder.append(",at:").append(this.m_AcceptThreads).append(",wk:").append(this.m_WorkThreads).append(",uptime:");
        builder.append(this.getUptime());
        builder.append("}");
        return builder;
    }

    public ServerHandler handle(HttpContext httpContext) throws IOException {
        return this.m_HandlerFactory.handle(httpContext);
    }

    public WebSocketServerHandshakerFactory getWebSocketFactory() {
        return this.m_WebSocketFactory;
    }

    class Compressor
    extends HttpContentCompressor {
        Compressor() {
        }

        protected HttpContentEncoder.Result beginEncode(HttpResponse headers, String acceptEncoding) throws Exception {
            int length;
            if (NettyHttpServer.this.m_GzipMinSize > 0 && (length = NumberUtil.toInt((String)headers.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (int)0)) < NettyHttpServer.this.m_GzipMinSize) {
                return null;
            }
            return super.beginEncode(headers, acceptEncoding);
        }
    }

    class Initializer
    extends ChannelInitializer<SocketChannel> {
        Initializer() {
        }

        protected void initChannel(SocketChannel ch) throws Exception {
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast("s-decoder", (ChannelHandler)new HttpRequestDecoder());
            pipeline.addLast("s-encoder", (ChannelHandler)new HttpResponseEncoder());
            if (NettyHttpServer.this.isGzipEnabled()) {
                pipeline.addLast("s-deflater", (ChannelHandler)new Compressor());
            }
            pipeline.addLast("http-ctx", (ChannelHandler)new NettyHttpHandler(NettyHttpServer.this));
        }
    }
}

