/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.netty;

import cn.weforward.common.io.BytesOutputStream;
import cn.weforward.common.io.OutputStreamNio;
import cn.weforward.common.io.OutputStreamStay;
import cn.weforward.protocol.aio.netty.Leakable;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakTracker;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NettyOutputStream
extends OutputStream
implements OutputStreamNio,
WritableByteChannel,
Leakable {
    static final Logger _Logger = LoggerFactory.getLogger(NettyOutputStream.class);
    ResourceLeakTracker<Leakable> m_Leak;
    public static final NettyOutputStream _pending = new Fake();
    public static final NettyOutputStream _end = new Fake();

    public abstract void write(ByteBuf var1) throws IOException;

    protected NettyOutputStream() {
        if (ResourceLeakDetector.Level.ADVANCED == ResourceLeakDetector.getLevel() || ResourceLeakDetector.Level.PARANOID == ResourceLeakDetector.getLevel()) {
            this.m_Leak = _LeakDetector.track((Object)this);
        }
    }

    protected NettyOutputStream(boolean noLeak) {
    }

    @Override
    public void touch(Object hint) {
        if (this.m_Leak != null) {
            this.m_Leak.record(hint);
        }
    }

    protected void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("closed");
        }
    }

    public int write(InputStream src) throws IOException {
        return BytesOutputStream.transfer((InputStream)src, (OutputStream)this, (int)-1);
    }

    protected synchronized void cleanup() {
        if (this.m_Leak != null) {
            this.m_Leak.close((Object)this);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "." + this.hashCode();
    }

    public static NettyOutputStream wrap(OutputStream source) {
        if (source instanceof NettyOutputStream) {
            return (NettyOutputStream)source;
        }
        if (source instanceof OutputStreamNio) {
            return new WrapNio((OutputStreamNio)source);
        }
        return new Wrap(source);
    }

    static class Fake
    extends NettyOutputStream {
        Fake() {
            super(true);
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            throw new EOFException("\u4e0d\u53ef\u7528");
        }

        public void cancel() throws IOException {
        }

        @Override
        public void write(int b) throws IOException {
            throw new EOFException("\u4e0d\u53ef\u7528");
        }

        @Override
        public void write(ByteBuf src) throws IOException {
            throw new EOFException("\u4e0d\u53ef\u7528");
        }

        @Override
        public int write(InputStream src) throws IOException {
            throw new EOFException("\u4e0d\u53ef\u7528");
        }
    }

    public static abstract class Stay
    extends NettyOutputStream
    implements OutputStreamStay {
        protected ByteBuf m_Buffer;
        protected CompositeByteBuf m_StayBuffers;
        protected ByteBuf m_Last;

        protected abstract ByteBuf allocBuffer(int var1);

        protected abstract void flush(ByteBuf var1) throws IOException;

        protected synchronized void flushBuffer() throws IOException {
            this.ensureOpen();
            ByteBuf buf = this.m_Buffer;
            if (buf != null) {
                try {
                    this.m_Buffer = null;
                    this.write(buf);
                }
                finally {
                    buf.release();
                }
            }
        }

        protected ByteBuf ensureBuffer(int capacity) throws IOException {
            this.ensureOpen();
            ByteBuf buf = this.m_Buffer;
            if (buf != null) {
                if (buf.writableBytes() >= capacity) {
                    return buf;
                }
                try {
                    this.m_Buffer = null;
                    this.write(buf);
                }
                finally {
                    buf.release();
                }
            }
            if (capacity < 256) {
                capacity = 256;
            }
            this.m_Buffer = buf = this.allocBuffer(capacity);
            return buf;
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            while (len > 0) {
                ByteBuf buf = this.ensureBuffer(len);
                int count = buf.writableBytes();
                if (count > len) {
                    count = len;
                }
                len -= count;
                buf.writeBytes(b, off, count);
                off += count;
            }
        }

        @Override
        public synchronized int write(ByteBuffer src) throws IOException {
            int len = src.remaining();
            if (len < 1) {
                return 0;
            }
            ByteBuf buf = this.ensureBuffer(len);
            buf.writeBytes(src);
            return len;
        }

        @Override
        public synchronized void write(int b) throws IOException {
            ByteBuf buf = this.ensureBuffer(1);
            buf.writeByte(b);
        }

        @Override
        public synchronized void write(ByteBuf src) throws IOException {
            this.ensureOpen();
            if (!src.isReadable()) {
                return;
            }
            if (this.m_StayBuffers != null) {
                this.flushBuffer();
                this.m_StayBuffers.addComponent(true, src.retain());
                return;
            }
            ByteBuf last = this.m_Last;
            this.m_Last = src.retain();
            if (last != null) {
                try {
                    this.flushBuffer();
                    this.flush(last);
                }
                finally {
                    last.release();
                }
            }
        }

        @Override
        public synchronized void flush() throws IOException {
            this.flushBuffer();
            CompositeByteBuf buf = this.m_StayBuffers;
            if (buf != null) {
                this.m_StayBuffers = null;
                try {
                    this.write((ByteBuf)buf);
                }
                finally {
                    buf.release();
                }
            }
        }

        @Override
        protected synchronized void cleanup() {
            ByteBuf buf = this.m_Buffer;
            if (buf != null) {
                this.m_Buffer = null;
                buf.release();
            }
            if ((buf = this.m_Last) != null) {
                this.m_Last = null;
                buf.release();
            }
            if ((buf = this.m_StayBuffers) != null) {
                this.m_StayBuffers = null;
                buf.release();
            }
            super.cleanup();
        }

        @Override
        public String toString() {
            if (this.m_Buffer != null) {
                return String.valueOf(this.getClass().getSimpleName()) + "." + this.hashCode() + ":" + this.m_Buffer;
            }
            return String.valueOf(this.getClass().getSimpleName()) + "." + this.hashCode();
        }
    }

    static class Wrap
    extends NettyOutputStream {
        OutputStream m_Output;

        public Wrap(OutputStream source) {
            super(true);
            this.m_Output = source;
        }

        public void cancel() throws IOException {
            this.m_Output.close();
        }

        @Override
        public void write(ByteBuf src) throws IOException {
            while (src.isReadable()) {
                this.m_Output.write(src.readByte());
            }
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int i = 0;
            while (src.hasRemaining()) {
                this.m_Output.write(src.get());
                ++i;
            }
            return i;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.m_Output.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.m_Output.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.m_Output.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.m_Output.flush();
        }

        @Override
        public void close() throws IOException {
            OutputStream out = this.m_Output;
            if (out != null) {
                this.m_Output = null;
                out.close();
            }
        }

        @Override
        public boolean isOpen() {
            return this.m_Output != null;
        }
    }

    static class WrapNio
    extends NettyOutputStream {
        OutputStreamNio m_Output;

        public WrapNio(OutputStreamNio source) {
            super(true);
            this.m_Output = source;
        }

        public void cancel() throws IOException {
            this.m_Output.cancel();
        }

        @Override
        public void write(ByteBuf src) throws IOException {
            this.m_Output.write(src.nioBuffer());
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.m_Output.write(src);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.m_Output.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            OutputStreamNio out = this.m_Output;
            if (out != null) {
                this.m_Output = null;
                out.close();
            }
        }

        @Override
        public boolean isOpen() {
            return this.m_Output != null;
        }

        @Override
        public int write(InputStream src) throws IOException {
            return this.m_Output.write(src);
        }

        @Override
        public void write(int b) throws IOException {
            byte[] bs = new byte[]{(byte)b};
            this.m_Output.write(bs, 0, 1);
        }
    }
}

