/*
 * Decompiled with CFR 0.152.
 */
package cn.weforward.protocol.aio.netty;

import cn.weforward.common.execption.Unexpected;
import cn.weforward.common.util.StringUtil;
import cn.weforward.protocol.aio.ClientChannel;
import cn.weforward.protocol.aio.ConnectionListener;
import cn.weforward.protocol.aio.ServerHandlerFactory;
import cn.weforward.protocol.aio.netty.NettyMemMonitor;
import cn.weforward.protocol.aio.netty.websocket.WebSocketContext;
import cn.weforward.protocol.aio.netty.websocket.WebSocketContextClient;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.CharsetUtil;
import io.netty.util.NettyRuntime;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.OutOfDirectMemoryError;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebSocketFactory {
    protected static final Logger _Logger = LoggerFactory.getLogger(NettyWebSocketFactory.class);
    protected Bootstrap m_Bootstrap;
    protected EventLoopGroup m_EventLoopGroup;
    protected SslContext m_SslContext;
    protected String m_Name;
    protected int m_Threads = NettyRuntime.availableProcessors();
    protected int m_IdleSeconds;

    public NettyWebSocketFactory() {
        this(false);
    }

    public NettyWebSocketFactory(boolean ssl) {
        if (this.m_Threads > 4) {
            this.m_Threads = 4;
        }
        try {
            this.setSsl(ssl);
        }
        catch (SSLException e) {
            throw new Unexpected((Throwable)e);
        }
    }

    public void setName(String name) {
        this.m_Name = name;
    }

    public String getName() {
        return this.m_Name;
    }

    public synchronized void setThreads(int threads) {
        if (threads == this.m_Threads) {
            return;
        }
        this.m_Threads = threads;
        this.close();
    }

    public void setIdle(int secs) {
        this.m_IdleSeconds = secs;
    }

    public static boolean isWebSocket(String url) {
        if (url == null || url.length() < 6) {
            return false;
        }
        String protocol = url.substring(0, 6).toLowerCase();
        return protocol.startsWith("ws://") || protocol.startsWith("wss://");
    }

    public ClientChannel connect(ServerHandlerFactory factory, final String url, final ConnectionListener listener) throws IOException {
        boolean ssl;
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        int port = uri.getPort();
        String protocol = uri.getScheme().toLowerCase();
        if ("ws".equals(protocol)) {
            if (port < 1) {
                port = 80;
            }
            ssl = false;
        } else if ("wss".equals(protocol)) {
            if (port < 1) {
                port = 443;
            }
            if ((ssl = true) && this.m_SslContext == null) {
                throw new SSLException("\u4e0d\u652f\u6301");
            }
        } else {
            throw new MalformedURLException("\u4e0d\u652f\u6301\u7684\u534f\u8bae\uff1a" + protocol);
        }
        ChannelFuture future = null;
        final WebSocketContextClient handler = new WebSocketContextClient(factory);
        handler.setConnectionListener(listener);
        if (listener instanceof Keepalive) {
            ((Keepalive)listener).init(this, factory, url);
        }
        if (_Logger.isDebugEnabled()) {
            _Logger.debug("connecting " + url);
        }
        try {
            future = this.open().connect(uri.getHost(), port);
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    Channel channel = future.channel();
                    if (future.isSuccess()) {
                        ChannelPipeline pipeline = channel.pipeline();
                        if (ssl) {
                            pipeline.addFirst("ssl", (ChannelHandler)NettyWebSocketFactory.this.m_SslContext.newHandler(channel.alloc()));
                        }
                        WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders());
                        pipeline.addLast("http-cc", (ChannelHandler)new HttpClientCodec());
                        pipeline.addLast("http-agg", (ChannelHandler)new HttpObjectAggregator(8192));
                        pipeline.addLast("ws-hs", (ChannelHandler)new Handshaker(handshaker, handler));
                        if (_Logger.isDebugEnabled()) {
                            _Logger.debug("\u5df2\u8fde\u63a5 " + channel);
                        }
                        handshaker.handshake(channel);
                    } else {
                        channel.close();
                        if (listener != null) {
                            listener.fail(url, future.cause());
                        }
                    }
                }
            });
            future = null;
        }
        finally {
            if (future != null && listener != null) {
                listener.fail(url, null);
            }
        }
        return handler;
    }

    public synchronized void setConnectTimeout(int millis) {
        if (this.m_Bootstrap == null) {
            this.m_Bootstrap = new Bootstrap();
        }
        this.m_Bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)millis);
    }

    public int getConnectTimeout() {
        Integer v = (Integer)this.m_Bootstrap.config().options().get(ChannelOption.CONNECT_TIMEOUT_MILLIS);
        return v == null ? 0 : v;
    }

    public void setSsl(boolean enabled) throws SSLException {
        if (enabled) {
            SslContextBuilder builder = SslContextBuilder.forClient();
            this.m_SslContext = builder.build();
        } else {
            this.m_SslContext = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        EventLoopGroup eventLoop;
        NettyWebSocketFactory nettyWebSocketFactory = this;
        synchronized (nettyWebSocketFactory) {
            eventLoop = this.m_EventLoopGroup;
            this.m_EventLoopGroup = null;
            this.m_Bootstrap = null;
        }
        if (eventLoop != null) {
            eventLoop.shutdownGracefully();
        }
        if (_Logger.isDebugEnabled()) {
            _Logger.debug(this.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bootstrap open() {
        if (this.m_EventLoopGroup != null) {
            return this.m_Bootstrap;
        }
        NettyWebSocketFactory nettyWebSocketFactory = this;
        synchronized (nettyWebSocketFactory) {
            if (this.m_EventLoopGroup != null) {
                return this.m_Bootstrap;
            }
            String name = this.getName();
            name = name == null || name.length() == 0 ? "ws" : String.valueOf(name) + "-ws";
            DefaultThreadFactory threadFactory = new DefaultThreadFactory(name, true);
            NioEventLoopGroup eventLoop = new NioEventLoopGroup(this.m_Threads, (ThreadFactory)threadFactory);
            if (this.m_Bootstrap == null) {
                this.m_Bootstrap = new Bootstrap();
            }
            this.m_Bootstrap.group((EventLoopGroup)eventLoop);
            this.m_Bootstrap.channel(NioSocketChannel.class);
            this.m_Bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            this.m_Bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
            this.m_Bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                }
            });
            this.m_EventLoopGroup = eventLoop;
        }
        NettyMemMonitor.getInstance();
        if (_Logger.isDebugEnabled()) {
            _Logger.debug(this.toString());
        }
        return this.m_Bootstrap;
    }

    public String toString() {
        return "{hash:" + this.hashCode() + ",name:" + this.m_Name + ",ssl:" + (this.m_SslContext != null ? "true" : "false") + ",threads:" + this.m_Threads + ",idle:" + this.m_IdleSeconds + "}";
    }

    class Handshaker
    extends ChannelInboundHandlerAdapter {
        WebSocketClientHandshaker m_Handshaker;
        WebSocketContext m_Context;

        Handshaker(WebSocketClientHandshaker handshaker, WebSocketContext context) {
            this.m_Handshaker = handshaker;
            this.m_Context = context;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (cause instanceof OutOfDirectMemoryError || cause.getCause() instanceof OutOfDirectMemoryError) {
                ctx.close();
                NettyWebSocketFactory.this.close();
                _Logger.error("restart " + NettyWebSocketFactory.this, cause);
                NettyMemMonitor.getInstance().log();
            }
            super.exceptionCaught(ctx, cause);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            try {
                this.m_Context.lost(ctx);
            }
            finally {
                super.channelInactive(ctx);
            }
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            block9: {
                try {
                    if (!(msg instanceof FullHttpResponse)) break block9;
                    FullHttpResponse response = (FullHttpResponse)msg;
                    if (!this.m_Handshaker.isHandshakeComplete()) {
                        try {
                            this.m_Handshaker.finishHandshake(ctx.channel(), response);
                            ChannelPipeline pipeline = ctx.channel().pipeline();
                            pipeline.addBefore("ws-hs", "ws-ctx", (ChannelHandler)this.m_Context);
                            if (_Logger.isDebugEnabled()) {
                                _Logger.debug("\u63e1\u624b\u6210\u529f " + ctx.channel());
                            }
                            if (NettyWebSocketFactory.this.m_IdleSeconds > 0) {
                                this.m_Context.setIdle(NettyWebSocketFactory.this.m_IdleSeconds);
                            }
                            this.m_Context.getConnectionListener().establish(this.m_Context);
                        }
                        catch (Exception e) {
                            _Logger.error("websock handshake error " + ctx.channel(), (Throwable)e);
                            this.m_Context.getConnectionListener().fail(this.m_Handshaker.uri().toString(), e);
                            ctx.close();
                        }
                        return;
                    }
                    throw new IllegalStateException("Unexpected FullHttpResponse {status:" + response.status() + ",body:" + StringUtil.limit((String)response.content().toString(CharsetUtil.UTF_8), (int)200) + '}');
                }
                finally {
                    super.channelRead(ctx, msg);
                }
            }
        }
    }

    public static class Keepalive
    implements ConnectionListener,
    Runnable {
        protected NettyWebSocketFactory m_WsFactory;
        protected int m_RetryDelay;
        protected String m_Url;
        protected ServerHandlerFactory m_SvrFactory;

        public Keepalive() {
            this.m_RetryDelay = 30;
        }

        public Keepalive(int interval) {
            this.setRetryDelay(interval);
        }

        public void setRetryDelay(int secs) {
            if (secs < 1) {
                throw new IllegalArgumentException("tryInterval<1");
            }
            this.m_RetryDelay = secs;
        }

        protected void init(NettyWebSocketFactory wsFactory, ServerHandlerFactory svrFactory, String url) {
            this.m_WsFactory = wsFactory;
            this.m_SvrFactory = svrFactory;
            this.m_Url = url;
        }

        @Override
        public void establish(ClientChannel channel) {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug("establish " + channel);
            }
        }

        @Override
        public void fail(String url, Throwable cause) {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug("fail,retry " + this.m_Url);
            }
            this.retry(this.m_RetryDelay);
        }

        @Override
        public void lost(ClientChannel channel) {
            if (_Logger.isDebugEnabled()) {
                _Logger.debug("lost,retry " + this.m_Url);
            }
            this.retry(1);
        }

        protected void retry(int secs) {
            EventLoopGroup el = this.m_WsFactory.m_EventLoopGroup;
            if (el != null) {
                el.schedule((Runnable)this, (long)secs, TimeUnit.SECONDS);
            }
        }

        @Override
        public void run() {
            try {
                this.m_WsFactory.connect(this.m_SvrFactory, this.m_Url, this);
            }
            catch (IOException e) {
                _Logger.error(this.m_Url, (Throwable)e);
            }
        }

        public String toString() {
            return "[" + this.m_RetryDelay + "]" + this.m_Url;
        }
    }
}

